/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class ContentTypeMappingDialog
extends Dialog {
    Combo fContentType;
    Combo fLanguage;
    String fSelectedContentTypeName;
    String fSelectedContentTypeID;
    String fSelectedLanguageName;
    String fSelectedLanguageID;
    String fSelectedConfigurationID;
    String fSelectedConfigurationName;
    Map<String, String> fContentTypeNamesToIDsMap = new HashMap<String, String>();
    Map<String, String> fLanguageNamesToIDsMap = new HashMap<String, String>();

    public ContentTypeMappingDialog(Shell parentShell) {
        super(parentShell);
    }

    public String getSelectedContentTypeName() {
        return this.fSelectedContentTypeName;
    }

    public String getContentTypeID() {
        return this.fSelectedContentTypeID;
    }

    public String getSelectedLanguageName() {
        return this.fSelectedLanguageName;
    }

    public String getLanguageID() {
        return this.fSelectedLanguageID;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PreferencesMessages.ContentTypeMappingsDialog_title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getButton(0).setEnabled(false);
    }

    protected String[] getLanguages() {
        ILanguage[] languages = LanguageManager.getInstance().getRegisteredLanguages();
        Object[] descriptions = new String[languages.length];
        int i = 0;
        while (i < descriptions.length) {
            descriptions[i] = languages[i].getName();
            this.fLanguageNamesToIDsMap.put((String)descriptions[i], languages[i].getId());
            ++i;
        }
        Arrays.sort(descriptions);
        return descriptions;
    }

    protected abstract boolean isValidSelection();
}

