/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.internal.ui.browser.opentype.ElementSelectionDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class NewBaseClassSelectionDialog
extends ElementSelectionDialog {
    private static final String DIALOG_SETTINGS = NewBaseClassSelectionDialog.class.getName();
    private static final int[] VISIBLE_TYPES = new int[]{65, 67};
    private static final int ADD_ID = 1025;
    private List<ITypeInfo> fTypeList;
    private List<ITypeSelectionListener> fTypeListeners;

    public NewBaseClassSelectionDialog(Shell parent) {
        super(parent);
        this.setTitle(NewClassWizardMessages.NewBaseClassSelectionDialog_title);
        this.setMessage(NewClassWizardMessages.NewBaseClassSelectionDialog_message);
        this.setDialogSettings(DIALOG_SETTINGS);
        this.setVisibleTypes(VISIBLE_TYPES);
        this.setStatusLineAboveButtons(true);
        this.fTypeList = new ArrayList<ITypeInfo>();
        this.fTypeListeners = new ArrayList<ITypeSelectionListener>();
    }

    public void addListener(ITypeSelectionListener listener) {
        if (!this.fTypeListeners.contains(listener)) {
            this.fTypeListeners.add(listener);
        }
    }

    public void removeListener(ITypeSelectionListener listener) {
        this.fTypeListeners.remove(listener);
    }

    private void notifyTypeAddedListeners(ITypeInfo type) {
        ArrayList<ITypeSelectionListener> list = new ArrayList<ITypeSelectionListener>(this.fTypeListeners);
        for (ITypeSelectionListener listener : list) {
            listener.typeAdded(type);
        }
    }

    public ITypeInfo[] getAddedTypes() {
        return this.fTypeList.toArray(new ITypeInfo[this.fTypeList.size()]);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewClassWizardMessages.NewBaseClassSelectionDialog_addButton_label, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addType(this.getLowerSelectedElement());
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addType(this.getLowerSelectedElement());
        super.okPressed();
    }

    private void addType(Object elem) {
        if (elem instanceof ITypeInfo) {
            ITypeInfo type = (ITypeInfo)elem;
            if (this.fTypeList.contains(type)) {
                String qualifiedName = type.getQualifiedTypeName().getFullyQualifiedName();
                String message = NLS.bind((String)NewClassWizardMessages.NewBaseClassSelectionDialog_classalreadyadded_info, (Object)qualifiedName);
                this.updateStatus(new StatusInfo(1, message));
            } else {
                String qualifiedName = type.getQualifiedTypeName().getFullyQualifiedName();
                String message = NLS.bind((String)NewClassWizardMessages.NewBaseClassSelectionDialog_addingclass_info, (Object)qualifiedName);
                this.updateStatus(new StatusInfo(1, message));
                boolean canAdd = true;
                if (this.verifyBaseClasses()) {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    NewClassWizardUtil.resolveClassLocation(type, (IRunnableContext)service);
                    boolean bl = canAdd = type.getResolvedReference() != null;
                }
                if (canAdd) {
                    this.fTypeList.add(type);
                    message = NLS.bind((String)NewClassWizardMessages.NewBaseClassSelectionDialog_classadded_info, (Object)qualifiedName);
                    this.updateStatus(new StatusInfo(1, message));
                    this.notifyTypeAddedListeners(type);
                } else {
                    message = NLS.bind((String)NewClassWizardMessages.NewBaseClassSelectionDialog_error_classnotadded, (Object)qualifiedName);
                    this.updateStatus(new StatusInfo(4, message));
                }
            }
        }
    }

    public boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(1025);
        }
    }

    public static interface ITypeSelectionListener {
        public void typeAdded(ITypeInfo var1);
    }
}

