/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.templateengine;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ParsingUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.exception.TizenProcessFailureException;
import org.tizen.nativecommon.templateengine.Messages;
import org.tizen.nativecommon.templateengine.build.AbstractProjectGenerator;
import org.tizen.nativecommon.templateengine.build.BuildPluginManagerForCLI;
import org.tizen.nativecommon.templateengine.build.model.BuildProperty;
import org.tizen.nativecommon.templateengine.build.model.DevPackageModel;
import org.tizen.nativecommon.templateengine.build.model.TargetModel;
import org.tizen.nativecommon.templateengine.model.TizenProcessArgument;
import org.tizen.nativecommon.templateengine.model.TizenTemplate;
import org.tizen.nativecommon.templateengine.process.TizenProcessRunner;
import org.tizen.nativecommon.templateengine.util.TemplateUtil;
import org.w3c.dom.Element;

public class TizenTemplateEngine {
    public static final String FILE_NAME_SAMPLE = "sample.xml";
    public static final String TAG_PROCESS = "process";
    public static final String TAG_SLPPROPERTY = "slp-property";
    public static final String TAG_PROPERTYGROUP = "property-group";
    public static final String TAG_PROJTYPE = "project-type";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String PROJECTTYPE_APP = "org.tizen.nativecore.buildArtefactType.app";
    public static final String PROJECTTYPE_STATIC = "org.tizen.nativecore.buildArtefactType.staticLib";
    public static final String PROJECTTYPE_SHARED = "org.tizen.nativecore.buildArtefactType.sharedLib";
    public static final String MACRO_EMULATOR_TARGET = "emulTarget";
    public static final String MACRO_EMULINC = "emulInc";
    public static final String MACRO_EMULCF = "emulCf";
    public static final String MACRO_EMULLF = "emulLf";
    public static final String MACRO_PROJECTNAME = "projectName";
    public static final String MACRO_PROJECTNAME_WITHOUT_HYPHEN = "projectNameWithoutHyphen";
    public static final String MACRO_BASENAME = "baseName";
    public static final String MACRO_BASENAME_UPPER = "baseNameUpper";
    public static final String MACRO_PACKAGE_NAME = "packageName";
    public static final String MACRO_APP_NAME_UPPER = "appNameUpper";
    public static final String MACRO_APP_NAME_LOWER = "appNameLower";
    public static final String MACRO_APP_NAME = "appName";
    public static final String MACRO_APP_NAME_WITHOUT_HYPHEN = "appNameWithoutHyphen";
    public static final String MACRO_MANIFEST_APP_ID = "manifestAppId";
    public static final String MACRO_UUID = "uuid";
    public static final String MACRO_PRECOMPILE = "pcheader";
    public static final String MACRO_TOOL_CPP_COMPILER = "toolCppCompiler";
    public static final String MACRO_TOOL_C_COMPILER = "toolCCompiler";
    public static final String MACRO_TOOL_LINKER = "toolCppLinker";
    public static final String MACRO_TOOL_ASSEMBLER = "toolAssembler";
    public static final String MACRO_TOOL_ARCHIVER = "toolArchiver";
    public static final String MACRO_RPATH = "rpath";
    public static final String MACRO_PROFILE_NAME = "packageProfile";
    public static final String MACRO_PLATFORM = "platform";
    public static final String MACRO_VERSION = "version";
    public static final String MACRO_PROFILE = "profile";
    public static final String DEFAULT_PACKAGE_NAME = "org.example";
    public static final String VALUE_PRECOMPILE_ON = "#include \"tizenx.h\"";
    public static final String VALUE_PRECOMPILE_OFF = "#include <FApp.h>\n#include <FBase.h>\n#include <FSystem.h>\n#include <FUi.h>\n#include <FUiIme.h>\n#include <FGraphics.h>\n#include <gl.h>";
    private static Logger logger = LoggerFactory.getLogger(TizenTemplateEngine.class);

    public static void createProject(TizenTemplate template, AbstractProjectGenerator generator) throws TizenProcessFailureException {
        generator.setTemplate(template);
        Map<String, String> preValueStore = template.getValueStore();
        Version version = null;
        if (preValueStore != null) {
            TizenTemplateEngine.pressPreValueStore(preValueStore, template);
            boolean precompile = ParsingUtil.parseBoolean((String)((String)template.getProperty(MACRO_PRECOMPILE)), (boolean)false);
            TizenTemplateEngine.pressCommonValueStore(preValueStore, precompile, template);
            String platform = preValueStore.get(MACRO_PLATFORM);
            version = new Version(platform.substring(platform.lastIndexOf("-") + 1));
        }
        TizenTemplateEngine.doTemplateProcess(template, generator);
        String projectType = (String)template.getProperty("project_type");
        if (projectType == null) {
            logger.error(MessageFormat.format(Messages.getString("TizenTemplateEngine.ExceptionPrjTypeNull"), template.getProjectName()));
            return;
        }
        Object frameworks = template.getProperty("frameworks");
        List<DevPackageModel> emulDevPackageModelList = null;
        TargetModel emulTarget = null;
        emulTarget = version != null && version.isSameOrBiggerThanVersion10() ? BuildPluginManagerForCLI.getDefaultTarget(projectType, "x86_64") : (version != null && version.isSameOrBiggerThanVersion6() ? BuildPluginManagerForCLI.getDefaultTarget(projectType, "i586") : BuildPluginManagerForCLI.getDefaultTarget(projectType, "i386"));
        template.setProperty("emulator_target", emulTarget);
        List frameworkList = (List)frameworks;
        emulDevPackageModelList = TizenTemplateEngine.getDevPackageModels(emulTarget, frameworkList);
        BuildProperty emulBuildProperty = BuildPluginManagerForCLI.getBuildPropertyFromDevPkgs(emulDevPackageModelList, template, emulTarget, generator);
        generator.doRemainingJob(emulDevPackageModelList, template, emulTarget);
        template.setProperty("emulator_buildprop", emulBuildProperty);
        HashMap<String, String> postValueStore = new HashMap<String, String>();
        generator.pressDefaultPostValueStore(postValueStore, template);
        generator.pressPostValueStoreFromDevPkg(postValueStore, template);
        generator.createBuildFiles(postValueStore, template);
    }

    public static String convertCamelCase(String str) {
        String[] a = StringUtil.splitByCamelCase((String)str);
        StringBuilder b = new StringBuilder();
        int iMax = a.length - 1;
        if (iMax == -1) {
            return str;
        }
        int i = 0;
        while (true) {
            b.append(a[i].toUpperCase());
            if (i == iMax) break;
            b.append("_");
            ++i;
        }
        return b.toString();
    }

    public static void pressCommonValueStore(Map<String, String> valueStore, boolean precompiledHeader, TizenTemplate template) {
        String projectName = template.getProjectName();
        if (StringUtil.isEmpty((CharSequence)projectName)) {
            projectName = valueStore.get(MACRO_PROJECTNAME);
        }
        String s = TizenTemplateEngine.convertCamelCase(projectName);
        valueStore.put(MACRO_BASENAME_UPPER, s.replace('.', '_'));
        valueStore.put(MACRO_BASENAME, projectName.replace('.', '_'));
        valueStore.put(MACRO_UUID, UUID.randomUUID().toString());
        String appId = TemplateUtil.generateAppId();
        valueStore.put(MACRO_MANIFEST_APP_ID, appId);
        template.setProperty("app_id", appId);
        String appNameLower = projectName.toLowerCase();
        String appNameWithoutHyphen = appNameLower.replaceAll("-", "_");
        TizenTemplateEngine.putMacroValue(MACRO_PRECOMPILE, precompiledHeader ? VALUE_PRECOMPILE_ON : VALUE_PRECOMPILE_OFF, valueStore);
        TizenTemplateEngine.putMacroValue(MACRO_APP_NAME, appNameLower, valueStore);
        TizenTemplateEngine.putMacroValue(MACRO_APP_NAME_WITHOUT_HYPHEN, appNameWithoutHyphen.toUpperCase(), valueStore);
        TizenTemplateEngine.putMacroValue(MACRO_APP_NAME_LOWER, appNameLower, valueStore);
        TizenTemplateEngine.putMacroValue(MACRO_APP_NAME_UPPER, projectName.toUpperCase(), valueStore);
        TizenTemplateEngine.putMacroValue(MACRO_PACKAGE_NAME, "org.example." + appNameLower, valueStore);
    }

    private static void putMacroValue(String id, String value, Map<String, String> valueStore) {
        String oldValue = valueStore.get(id);
        if (StringUtil.isEmpty((CharSequence)oldValue)) {
            valueStore.put(id, value);
        }
    }

    private static void pressPreValueStore(Map<String, String> valueStore, TizenTemplate template) {
        String projectName = template.getProjectName();
        String projectNameWithoutHyphen = projectName.replaceAll("-", "_").toUpperCase();
        valueStore.put(MACRO_PROJECTNAME, projectName);
        valueStore.put(MACRO_PROJECTNAME_WITHOUT_HYPHEN, projectNameWithoutHyphen);
        valueStore.put(MACRO_BASENAME, projectName);
    }

    private static void doTemplateProcess(TizenTemplate template, AbstractProjectGenerator generator) throws TizenProcessFailureException {
        String samplePath = FileUtil.appendPath((String)template.getSamplePath(), (String)FILE_NAME_SAMPLE);
        File sampleFile = new File(samplePath);
        Element root = null;
        try {
            root = XMLUtil.getDocumentRootFromFile((File)sampleFile);
        }
        catch (Exception e) {
            throw new TizenProcessFailureException(MessageFormat.format(Messages.getString("TizenTemplateEngine.ExceptionParsingXML"), samplePath), e);
        }
        if (root == null) {
            throw new TizenProcessFailureException(MessageFormat.format(Messages.getString("TizenTemplateEngine.ExceptionTemplateRootNull"), samplePath));
        }
        String projectType = TizenTemplateEngine.getProjectType(root);
        template.setProperty("project_type", projectType);
        template.setProperty("frameworks", new ArrayList());
        TizenTemplateEngine.doTemplatePreProcess(template);
        List processElementList = XMLUtil.getElementsByTag((Element)root, (String)TAG_PROCESS);
        for (Element processElement : processElementList) {
            String templateId = processElement.getAttribute(ATTRIBUTE_TYPE);
            TizenProcessRunner runner = generator.getTemplateProcess(templateId, template);
            TizenProcessArgument[] args = TizenTemplateEngine.getProcessArguments(processElement);
            if (runner == null) continue;
            runner.process(args);
        }
    }

    public static List<DevPackageModel> getDevPackageModels(TargetModel target, List<String> frameworkList) {
        ArrayList<DevPackageModel> result = new ArrayList<DevPackageModel>();
        if (target == null) {
            return result;
        }
        for (String framework : frameworkList) {
            DevPackageModel model = BuildPluginManagerForCLI.getDevPackageModel(target.getRootstrap().getId(), framework);
            if (model == null) {
                logger.warn(MessageFormat.format(Messages.getString("TizenTemplateEngine.ExceptionFrameworkNotExist"), framework));
                continue;
            }
            result.add(model);
        }
        return result;
    }

    private static TizenProcessArgument[] getProcessArguments(Element processElement) {
        ArrayList<TizenProcessArgument> result = new ArrayList<TizenProcessArgument>();
        List argElementList = XMLUtil.getChildrenOfElement((Element)processElement);
        for (Element argElement : argElementList) {
            result.add(new TizenProcessArgument(argElement));
        }
        return result.toArray(new TizenProcessArgument[result.size()]);
    }

    private static String getProjectType(Element root) {
        Element slpPropertyElement = (Element)XMLUtil.getElementsByTag((Element)root, (String)TAG_SLPPROPERTY).get(0);
        Element propertyGroupElement = (Element)XMLUtil.getElementsByTag((Element)slpPropertyElement, (String)TAG_PROPERTYGROUP).get(0);
        Element projectTypeElement = (Element)XMLUtil.getElementsByTag((Element)propertyGroupElement, (String)TAG_PROJTYPE).get(0);
        String projectType = projectTypeElement.getTextContent();
        return projectType;
    }

    private static void doTemplatePreProcess(TizenTemplate template) throws TizenProcessFailureException {
        String rootPath = template.getProjectPath();
        String projectType = (String)template.getProperty("project_type");
        if (PROJECTTYPE_APP.equals(projectType)) {
            new File(rootPath, "src").mkdir();
            new File(rootPath, "res").mkdir();
            new File(rootPath, "inc").mkdir();
            new File(rootPath, "lib").mkdir();
            new File(rootPath, "data").mkdir();
        } else if (PROJECTTYPE_STATIC.equals(projectType)) {
            new File(rootPath, "src").mkdir();
            new File(rootPath, "inc").mkdir();
            new File(rootPath, "lib").mkdir();
        } else if (PROJECTTYPE_SHARED.equals(projectType)) {
            new File(rootPath, "src").mkdir();
            new File(rootPath, "inc").mkdir();
            new File(rootPath, "lib").mkdir();
        } else {
            throw new TizenProcessFailureException(MessageFormat.format(Messages.getString("TizenTemplateEngine.ExceptionUnexpectedPrjType"), projectType));
        }
    }
}

