/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoring;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

class RefactoringJob
extends Job {
    public static final Object FAMILY_TOGGLE_DEFINITION = new Object();
    private final ToggleRefactoring refactoring;

    RefactoringJob(ToggleRefactoring refactoring) {
        super("Toggle Function Definition code automation");
        this.refactoring = refactoring;
        this.setPriority(20);
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY_TOGGLE_DEFINITION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        CRefactoringContext context = new CRefactoringContext(this.refactoring);
        IUndoManager undoManager = RefactoringCore.getUndoManager();
        NullChange change = new NullChange();
        NullChange undoChange = new NullChange();
        boolean success = false;
        try {
            RefactoringStatus status = this.refactoring.checkAllConditions(monitor);
            if (status.hasFatalError()) {
                Status status2 = new Status(4, "org.eclipse.cdt.ui", status.getMessageMatchingSeverity(3));
                return status2;
            }
            change = this.refactoring.createChange(monitor);
            change.initializeValidationData(monitor);
            if (!change.isValid(monitor).isOK()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            undoManager.aboutToPerformChange((Change)change);
            undoChange = change.perform(monitor);
            success = true;
            return Status.OK_STATUS;
        }
        catch (IllegalStateException e) {
            CUIPlugin.log("Another refactoring is still in progress, aborting.", e);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            CUIPlugin.log("Failure during generation of changes.", e);
            return Status.OK_STATUS;
        }
        finally {
            context.dispose();
            undoChange.initializeValidationData(monitor);
            undoManager.changePerformed((Change)change, success);
            try {
                if (success && undoChange.isValid(monitor).isOK()) {
                    undoManager.addUndo(Messages.RefactoringJob_UndoName, (Change)undoChange);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (CoreException coreException) {}
        }
    }
}

