/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.ext.manifest.ProviderPrivilege;
import org.tizen.nativecore.misc.core.PrivilegeManager;
import org.tizen.nativecore.misc.utils.IApplicationUtil;

public class UiAppControlScreenDialog
extends SelectionStatusDialog {
    private Combo fOperation;
    private Combo fMime;
    private Combo fVisibility;
    private Text fUri;
    private String operation = "";
    private String uri = "";
    private String mime = "";
    private String visibility = "";
    private String[] operations;
    private String[] mimes;
    private String[] visibilities;
    private Button fAddButton;
    private Button fRemoveButton;
    private TableViewer fAddedPrivilegesViewer;
    private TableViewer fSupportedPrivilegesViewer;
    private Set<Privilege> addedPrivilegeList;
    private Set<Privilege> supportedPrivilegeList;
    private Manifest manifest;
    private AppControl appControl;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (e.widget == UiAppControlScreenDialog.this.fOperation) {
                UiAppControlScreenDialog.this.setOperation(UiAppControlScreenDialog.this.fOperation.getText());
            } else if (e.widget == UiAppControlScreenDialog.this.fUri) {
                UiAppControlScreenDialog.this.setUri(UiAppControlScreenDialog.this.fUri.getText());
            } else if (e.widget == UiAppControlScreenDialog.this.fMime) {
                UiAppControlScreenDialog.this.setMime(UiAppControlScreenDialog.this.fMime.getText());
            } else if (e.widget == UiAppControlScreenDialog.this.fVisibility) {
                UiAppControlScreenDialog.this.setVisibility(UiAppControlScreenDialog.this.fVisibility.getText());
            }
        }
    };

    public UiAppControlScreenDialog(FormToolkit tk, String[] operations, String[] mimes, String[] visibilities, Manifest manifest) {
        super(Display.getDefault().getActiveShell());
        this.setTitle("Attributes for App Control");
        this.operations = operations;
        this.mimes = mimes;
        this.manifest = manifest;
        this.visibilities = visibilities;
    }

    public UiAppControlScreenDialog(FormToolkit tk, String[] operations, String[] mimes, String[] visibilities, String op, String uri, String mime, String visibility, Manifest manifest) {
        super(Display.getDefault().getActiveShell());
        this.setTitle("Attributes for App Control");
        this.operations = operations;
        this.mimes = mimes;
        this.manifest = manifest;
        this.operation = op;
        this.uri = uri;
        this.mime = mime;
        this.visibility = visibility;
        this.visibilities = visibilities;
    }

    public void setInput(AppControl appControl) {
        this.appControl = appControl;
        this.setTitle("Edit App Control");
    }

    public AppControl getAppControl() {
        return this.appControl;
    }

    private Combo createLabelComboBox(Composite parent, String labelText, String[] comboValues) {
        Composite gridComposite = new Composite(parent, 0);
        gridComposite.setLayout((Layout)new GridLayout(2, false));
        gridComposite.setBackground(new Color(null, 255, 255, 255));
        GridData gData = new GridData(4, 1, true, false);
        gData.widthHint = 500;
        gridComposite.setLayoutData((Object)gData);
        GridData lgd = new GridData(4, 1, true, false);
        lgd.widthHint = 100;
        Label label = new Label(gridComposite, 16384);
        label.setText(labelText);
        label.setLayoutData((Object)lgd);
        GridData cmbgd = new GridData(4, 1, true, false);
        cmbgd.widthHint = 300;
        Combo combo = new Combo(gridComposite, 12);
        combo.setItems(comboValues);
        combo.setLayoutData((Object)cmbgd);
        return combo;
    }

    private Text createLabelTextBox(Composite parent, String labelText) {
        Composite gridComposite = new Composite(parent, 0);
        gridComposite.setLayout((Layout)new GridLayout(2, false));
        gridComposite.setBackground(new Color(null, 255, 255, 255));
        GridData gd = new GridData(4, 1, true, false);
        gd.widthHint = 500;
        gridComposite.setLayoutData((Object)gd);
        GridData lgd = new GridData(4, 1, true, false);
        lgd.widthHint = 85;
        Label label = new Label(gridComposite, 16384);
        label.setText(labelText);
        label.setLayoutData((Object)lgd);
        label.setBackground(new Color(null, 255, 255, 255));
        GridData txtgd = new GridData(4, 1, true, false);
        txtgd.widthHint = 300;
        Text text = new Text(gridComposite, 2048);
        text.setLayoutData((Object)txtgd);
        gridComposite.setBackground(new Color(null, 255, 255, 255));
        return text;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        parentComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 510;
        parentComposite.setLayoutData((Object)gd);
        parentComposite.setBackground(new Color(null, 255, 255, 255));
        this.fOperation = this.createLabelComboBox(parentComposite, "Operation:", this.operations);
        this.fOperation.setText(this.operation);
        this.fOperation.addModifyListener(this.modifyListener);
        this.fUri = this.createLabelTextBox(parentComposite, "Uri:");
        this.fUri.setText(this.uri);
        this.fUri.addModifyListener(this.modifyListener);
        this.fMime = this.createLabelComboBox(parentComposite, "Mime:", this.mimes);
        this.fMime.setText(this.mime);
        this.fMime.addModifyListener(this.modifyListener);
        this.fVisibility = this.createLabelComboBox(parentComposite, "Visibility:", this.visibilities);
        this.fVisibility.setText(this.visibility);
        this.fVisibility.addModifyListener(this.modifyListener);
        if (IApplicationUtil.compareVersion(this.manifest.getApiVersion(), "4.0") >= 0) {
            this.createPrivilegeSection(parentComposite);
        }
        return parentComposite;
    }

    private void setOperation(String text) {
        this.operation = text;
    }

    private void setUri(String text) {
        this.uri = text;
    }

    private void setMime(String text) {
        this.mime = text;
    }

    private void setVisibility(String text) {
        this.visibility = text;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getUri() {
        return this.uri;
    }

    public String getMime() {
        return this.mime;
    }

    public String getVisibility() {
        return this.visibility;
    }

    protected void computeResult() {
        if (this.appControl == null) {
            return;
        }
        if (IApplicationUtil.compareVersion(this.manifest.getApiVersion(), "4.0") >= 0) {
            this.appControl.getPrivilegeList().clear();
            for (Privilege prv : this.addedPrivilegeList) {
                if (this.appControl.getPrivilegeList().contains(prv)) continue;
                this.appControl.getPrivilegeList().add(prv);
            }
        }
    }

    private void loadPrivilegeLists() {
        this.addedPrivilegeList = new HashSet<Privilege>();
        this.supportedPrivilegeList = new HashSet<Privilege>();
        if (this.appControl != null) {
            for (Privilege privilege : this.appControl.getPrivilegeList()) {
                if (this.addedPrivilegeList.contains(privilege)) continue;
                this.addedPrivilegeList.add(privilege);
            }
        }
        for (Privilege privilege : this.manifest.getPrivilege_map().values()) {
            if (this.addedPrivilegeList.contains(privilege)) continue;
            this.supportedPrivilegeList.add(privilege);
        }
        for (ProviderPrivilege providerPrivilege : this.manifest.getProviderPrivilege_map().values()) {
            Privilege privilege = new Privilege(providerPrivilege.getValue());
            if (this.supportedPrivilegeList.contains(privilege) || this.addedPrivilegeList.contains(privilege)) continue;
            this.supportedPrivilegeList.add(privilege);
        }
        for (Privilege privilege : PrivilegeManager.getPlatformPrivileges()) {
            if (this.supportedPrivilegeList.contains(privilege) || this.addedPrivilegeList.contains(privilege)) continue;
            this.supportedPrivilegeList.add(privilege);
        }
    }

    private void createPrivilegeSection(Composite composite) {
        this.loadPrivilegeLists();
        this.fAddedPrivilegesViewer = new TableViewer(composite, 68354);
        Table table1 = this.fAddedPrivilegesViewer.getTable();
        table1.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 200;
        table1.setLayoutData((Object)gd);
        TableViewerColumn nameColumn = new TableViewerColumn(this.fAddedPrivilegesViewer, 0);
        nameColumn.getColumn().setText("Added Privileges");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.fAddedPrivilegesViewer.getTable().setLayout((Layout)tableLayout);
        this.fAddedPrivilegesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                HashSet model = (HashSet)inputElement;
                return model.toArray();
            }
        });
        this.fAddedPrivilegesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Privilege) {
                    return ((Privilege)element).getValue();
                }
                if (element instanceof ProviderPrivilege) {
                    return ((ProviderPrivilege)element).getValue();
                }
                return null;
            }
        });
        this.fAddedPrivilegesViewer.setInput(this.addedPrivilegeList);
        this.fAddedPrivilegesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    UiAppControlScreenDialog.this.fRemoveButton.setEnabled(true);
                } else {
                    UiAppControlScreenDialog.this.fRemoveButton.setEnabled(false);
                }
            }
        });
        Composite buttoncomposite = new Composite(composite, 0);
        buttoncomposite.setBackground(new Color(null, 255, 255, 255));
        buttoncomposite.setLayout((Layout)new GridLayout(2, true));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        buttoncomposite.setLayoutData((Object)gd);
        this.fAddButton = new Button(buttoncomposite, 140);
        this.fAddButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.fAddButton.setText("Add");
        this.fAddButton.setEnabled(false);
        this.fAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IStructuredSelection sel = UiAppControlScreenDialog.this.fSupportedPrivilegesViewer.getStructuredSelection();
                if (sel.isEmpty()) {
                    return;
                }
                UiAppControlScreenDialog.this.addedPrivilegeList.add((Privilege)sel.getFirstElement());
                UiAppControlScreenDialog.this.supportedPrivilegeList.remove(sel.getFirstElement());
                UiAppControlScreenDialog.this.fAddedPrivilegesViewer.refresh();
                UiAppControlScreenDialog.this.fSupportedPrivilegesViewer.refresh();
            }
        });
        this.fRemoveButton = new Button(buttoncomposite, 1036);
        this.fRemoveButton.setText("Remove");
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        this.fRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IStructuredSelection sel = UiAppControlScreenDialog.this.fAddedPrivilegesViewer.getStructuredSelection();
                if (sel.isEmpty()) {
                    return;
                }
                UiAppControlScreenDialog.this.addedPrivilegeList.remove(sel.getFirstElement());
                UiAppControlScreenDialog.this.supportedPrivilegeList.add((Privilege)sel.getFirstElement());
                UiAppControlScreenDialog.this.fAddedPrivilegesViewer.refresh();
                UiAppControlScreenDialog.this.fSupportedPrivilegesViewer.refresh();
            }
        });
        this.fSupportedPrivilegesViewer = new TableViewer(composite, 68354);
        Table table2 = this.fSupportedPrivilegesViewer.getTable();
        table2.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 200;
        table2.setLayoutData((Object)gd);
        TableViewerColumn nameColumn1 = new TableViewerColumn(this.fSupportedPrivilegesViewer, 0);
        nameColumn1.getColumn().setText("Supported Privileges");
        TableLayout tableLayout1 = new TableLayout();
        tableLayout1.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.fSupportedPrivilegesViewer.getTable().setLayout((Layout)tableLayout1);
        this.fSupportedPrivilegesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Set model = (Set)inputElement;
                return model.toArray();
            }
        });
        this.fSupportedPrivilegesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Privilege) {
                    return ((Privilege)element).getValue();
                }
                if (element instanceof ProviderPrivilege) {
                    return ((ProviderPrivilege)element).getValue();
                }
                return null;
            }
        });
        this.fSupportedPrivilegesViewer.setInput(this.supportedPrivilegeList);
        this.fSupportedPrivilegesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    UiAppControlScreenDialog.this.fAddButton.setEnabled(false);
                } else {
                    UiAppControlScreenDialog.this.fAddButton.setEnabled(true);
                }
            }
        });
    }
}

