/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;

public class CElementSet {
    private Set<ICElement> fSet = new LinkedHashSet<ICElement>();
    private int fHashCode;

    CElementSet(ICElement[] elements) {
        this.fSet.addAll(Arrays.asList(elements));
        this.fHashCode = 0;
        int i = 0;
        while (i < elements.length) {
            this.fHashCode = 31 * this.fHashCode + elements[i].hashCode();
            ++i;
        }
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CElementSet other = (CElementSet)obj;
        if (this.fHashCode != other.fHashCode) {
            return false;
        }
        if (this.fSet == null) {
            if (other.fSet != null) {
                return false;
            }
        } else {
            if (this.fSet.size() != other.fSet.size()) {
                return false;
            }
            Iterator<ICElement> iter = this.fSet.iterator();
            while (iter.hasNext()) {
                if (other.fSet.contains(iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEmpty() {
        return this.fSet.isEmpty();
    }

    public ICElement[] getElements(WorkingSetFilterUI filter) {
        ArrayList<ICElement> result = new ArrayList<ICElement>(this.fSet.size());
        for (ICElement element : this.fSet) {
            if (filter != null && !filter.isPartOfWorkingSet(element)) continue;
            result.add(element);
        }
        return result.toArray(new ICElement[result.size()]);
    }
}

