/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tizen.nativecore.ext.manifest.Account;
import org.tizen.nativecore.ext.manifest.Author;
import org.tizen.nativecore.ext.manifest.Compatibility;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.Dependencies;
import org.tizen.nativecore.ext.manifest.Description;
import org.tizen.nativecore.ext.manifest.Dynamicbox;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.ext.manifest.Font;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.IPrivilege;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Ime;
import org.tizen.nativecore.ext.manifest.ImeApplication;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Livebox;
import org.tizen.nativecore.ext.manifest.Notifications;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.ext.manifest.Profile;
import org.tizen.nativecore.ext.manifest.ProviderPrivilege;
import org.tizen.nativecore.ext.manifest.ServiceApplication;
import org.tizen.nativecore.ext.manifest.Shortcut;
import org.tizen.nativecore.ext.manifest.TrustAnchor;
import org.tizen.nativecore.ext.manifest.UiApplication;
import org.tizen.nativecore.ext.manifest.WatchApplication;
import org.tizen.nativecore.ext.manifest.Widget;
import org.tizen.nativecore.ext.manifest.WidgetApplication;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Manifest {
    public static final String ELEMENT = "manifest";
    public static final String MANIFEST_MARKER_ID = "org.tizen.nativecore.misc.manifestProblem";
    public static final String ATTR_XMLNS = "xmlns";
    public static final String ATTR_STORECLIENT_ID = "storeclient-id";
    public static final String ATTR_INSTALL_LOCATION = "install-location";
    public static final String ATTR_PACKAGE = "package";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_ROOT_PATH = "root_path";
    public static final String ATTR_CSC_PATH = "csc_path";
    public static final String ATTR_APPSETTING = "appsetting";
    public static final String ATTR_NODISPLAY_SETTING = "nodisplay-setting";
    public static final String ATTR_URL = "url";
    public static final String ATTR_SUPPORT_DISABLE = "support-disable";
    public static final String ATTR_API_VERSION = "api-version";
    private String xmlns = "http://tizen.org/ns/packages";
    private String storeclient_id;
    private String install_location;
    private String package_name;
    private String type;
    private String version;
    private String size;
    private String root_path;
    private String csc_path;
    private String appsetting;
    private String trust_anchor_path;
    private String nodisplay_setting;
    private String url;
    private String support_disable;
    private String api_version;
    private Dependencies dependencies = new Dependencies();
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private List<Label> label_list = new ArrayList<Label>();
    private Icon icon;
    private Author author;
    private Description description;
    private String defaultDesc;
    private List<LocaledValue> descriptions = new ArrayList<LocaledValue>();
    private Compatibility compatibility;
    private Profile profile;
    private List<IApplication> application_list = new ArrayList<IApplication>();
    private List<Shortcut> shortcutList = new ArrayList<Shortcut>();
    private Livebox livebox;
    private List<Dynamicbox> dbox_list = new ArrayList<Dynamicbox>();
    private List<Account> account_list = new ArrayList<Account>();
    private Notifications notifications;
    private Font font;
    private Ime ime;
    private Map<String, Privilege> privilege_map = new HashMap<String, Privilege>();
    private Map<String, Privilege> consumerPrivilege_map = new HashMap<String, Privilege>();
    private Map<String, ProviderPrivilege> providerPrivilege_map = new HashMap<String, ProviderPrivilege>();
    private TreeMap<String, String> feature_list = new TreeMap();
    private Map<String, Feature> feature_map = new HashMap<String, Feature>();
    private List<Widget> widgetList = new ArrayList<Widget>();
    private TrustAnchor trustAnchor;

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.xmlns = element.getAttribute(ATTR_XMLNS);
        this.storeclient_id = element.getAttribute(ATTR_STORECLIENT_ID);
        this.install_location = element.getAttribute(ATTR_INSTALL_LOCATION);
        this.setPackageId(element.getAttribute(ATTR_PACKAGE));
        this.type = element.getAttribute(ATTR_TYPE);
        this.setVersion(element.getAttribute(ATTR_VERSION));
        this.size = element.getAttribute(ATTR_SIZE);
        this.root_path = element.getAttribute(ATTR_ROOT_PATH);
        this.csc_path = element.getAttribute(ATTR_CSC_PATH);
        this.appsetting = element.getAttribute(ATTR_APPSETTING);
        this.nodisplay_setting = element.getAttribute(ATTR_NODISPLAY_SETTING);
        this.url = element.getAttribute(ATTR_URL);
        this.support_disable = element.getAttribute(ATTR_SUPPORT_DISABLE);
        this.setApiVersion(element.getAttribute(ATTR_API_VERSION));
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            IPrivilege privilege;
            Node p_item;
            NodeList pri;
            IApplication application;
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                this.label_list.add(label);
            } else if (nodeName.equals("icon")) {
                this.setIcon(new Icon());
                this.getIcon().loadElement((Element)node);
            } else if (nodeName.equals("author")) {
                this.author = new Author();
                this.author.loadElement((Element)node);
            } else if (nodeName.equals("description")) {
                if (node.getAttributes().getLength() > 0) {
                    this.description = new Description();
                    this.description.loadElement((Element)node);
                    this.descriptions.add(new LocaledValue(this.description.getLang(), this.description.getValue()));
                } else {
                    this.defaultDesc = node.getTextContent();
                }
            } else if (nodeName.equals("compatibility")) {
                this.compatibility = new Compatibility();
                this.compatibility.loadElement((Element)node);
            } else if (nodeName.equals("profile")) {
                this.profile = new Profile();
                this.profile.loadElement((Element)node);
            } else if (nodeName.equals("trust-anchor")) {
                this.trustAnchor = new TrustAnchor();
                this.trustAnchor.loadElement((Element)node);
            } else if (nodeName.equals("widget-application")) {
                application = new WidgetApplication();
                ((WidgetApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("watch-application")) {
                application = new WatchApplication();
                ((WatchApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("service-application")) {
                application = new ServiceApplication();
                ((ServiceApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("ui-application")) {
                application = new UiApplication();
                ((UiApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("dependencies")) {
                this.dependencies.loadElement((Element)node);
            } else if (nodeName.equals("ime-application")) {
                application = new ImeApplication();
                ((ImeApplication)application).loadElement((Element)node);
                this.getApplication_list().add(application);
            } else if (nodeName.equals("shortcut-list")) {
                Node child = node.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        Shortcut shortCut = new Shortcut();
                        shortCut.loadElement((Element)child);
                        this.getShortCutList().add(shortCut);
                    }
                    child = child.getNextSibling();
                }
            } else if (nodeName.equals("livebox")) {
                this.livebox = new Livebox();
                this.livebox.loadElement((Element)node);
            } else if (nodeName.equals("dynamicbox")) {
                Dynamicbox dbox = new Dynamicbox();
                dbox.loadElement((Element)node);
                this.dbox_list.add(dbox);
            } else if (nodeName.equals("widget")) {
                Widget widget = new Widget();
                widget.loadElement((Element)node);
                this.widgetList.add(widget);
            } else if (nodeName.equals("account")) {
                Account account = new Account();
                account.loadElement((Element)node);
                this.account_list.add(account);
            } else if (nodeName.equals("notifications")) {
                this.notifications = new Notifications();
                this.notifications.loadElement((Element)node);
            } else if (nodeName.equals("privileges")) {
                pri = node.getChildNodes();
                int i2 = 0;
                while (i2 < pri.getLength()) {
                    p_item = pri.item(i2);
                    if (p_item.getNodeName().equals("privilege")) {
                        privilege = new Privilege();
                        ((Privilege)privilege).loadElement((Element)p_item);
                        this.getPrivilege_map().put(((Privilege)privilege).getValue(), (Privilege)privilege);
                    } else if (p_item.getNodeName().equals("appdefined-privilege")) {
                        privilege = new Privilege();
                        ((Privilege)privilege).loadElement((Element)p_item);
                        ((Privilege)privilege).setLevel(PrivilegeLevel.APP_DEFINED_CONSUMER);
                        this.getConsumerPrivilege_map().put(((Privilege)privilege).getValue(), (Privilege)privilege);
                    }
                    ++i2;
                }
            } else if (nodeName.equals("provides-appdefined-privileges")) {
                pri = node.getChildNodes();
                int i3 = 0;
                while (i3 < pri.getLength()) {
                    p_item = pri.item(i3);
                    if (p_item.getNodeName().equals("appdefined-privilege")) {
                        privilege = new ProviderPrivilege();
                        ((ProviderPrivilege)privilege).loadElement((Element)p_item);
                        this.getProviderPrivilege_map().put(((ProviderPrivilege)privilege).getValue(), (ProviderPrivilege)privilege);
                    }
                    ++i3;
                }
            } else if (nodeName.equals("font")) {
                this.font = new Font();
                this.font.loadElement((Element)node);
            } else if (nodeName.equals("ime")) {
                this.ime = new Ime();
                this.ime.loadElement((Element)node);
            } else if (nodeName.equals("feature")) {
                Feature feature = new Feature();
                feature.loadElement((Element)node);
                this.getFeature_map().put(feature.getKey(), feature);
            } else if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        dom.appendChild(element);
        element.setAttribute(ATTR_XMLNS, this.xmlns);
        if (this.storeclient_id != null && this.storeclient_id.length() > 0) {
            element.setAttribute(ATTR_STORECLIENT_ID, this.storeclient_id);
        }
        if (this.install_location != null && this.install_location.length() > 0) {
            element.setAttribute(ATTR_INSTALL_LOCATION, this.install_location);
        }
        if (this.getPackageId() != null && this.getPackageId().length() > 0) {
            element.setAttribute(ATTR_PACKAGE, this.getPackageId());
        }
        if (this.type != null && this.type.length() > 0) {
            element.setAttribute(ATTR_TYPE, this.type);
        }
        if (this.getApiVersion() != null && this.getApiVersion().length() > 0) {
            element.setAttribute(ATTR_API_VERSION, this.getApiVersion());
        }
        if (this.getVersion() != null && this.getVersion().length() > 0) {
            element.setAttribute(ATTR_VERSION, this.getVersion());
        }
        if (this.size != null && this.size.length() > 0) {
            element.setAttribute(ATTR_SIZE, this.size);
        }
        if (this.root_path != null && this.root_path.length() > 0) {
            element.setAttribute(ATTR_ROOT_PATH, this.root_path);
        }
        if (this.csc_path != null && this.csc_path.length() > 0) {
            element.setAttribute(ATTR_CSC_PATH, this.csc_path);
        }
        if (this.appsetting != null && this.appsetting.length() > 0) {
            element.setAttribute(ATTR_APPSETTING, this.appsetting);
        }
        if (this.nodisplay_setting != null && this.nodisplay_setting.length() > 0) {
            element.setAttribute(ATTR_NODISPLAY_SETTING, this.nodisplay_setting);
        }
        if (this.url != null && this.url.length() > 0) {
            element.setAttribute(ATTR_URL, this.url);
        }
        if (this.support_disable != null && this.support_disable.length() > 0) {
            element.setAttribute(ATTR_SUPPORT_DISABLE, this.support_disable);
        }
        for (CustomAttribute c : this.getCustomAttrList()) {
            c.generateAttribute(element);
        }
        if (this.label_list.size() > 0) {
            int i = 0;
            while (i < this.label_list.size()) {
                this.label_list.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.getIcon() != null) {
            this.getIcon().generateElement(dom, element);
        }
        if (this.author != null) {
            this.author.generateElement(dom, element);
        }
        this.generateDescriptions(dom, element);
        if (this.compatibility != null) {
            this.compatibility.generateElement(dom, element);
        }
        if (this.profile != null) {
            this.profile.generateElement(dom, element);
        }
        if (this.getApplication_list().size() > 0) {
            int i = 0;
            while (i < this.getApplication_list().size()) {
                this.getApplication_list().get(i).generateElement(dom, element);
                ++i;
            }
        }
        this.dependencies.generateElement(dom, element);
        if (this.trustAnchor != null) {
            this.trustAnchor.generateElement(dom, element);
        }
        if (this.getShortCutList().size() > 0) {
            Element shortcutList = dom.createElement("shortcut-list");
            int i = 0;
            while (i < this.getShortCutList().size()) {
                this.getShortCutList().get(i).generateElement(dom, shortcutList);
                ++i;
            }
            element.appendChild(shortcutList);
        }
        if (this.livebox != null) {
            this.livebox.generateElement(dom, element);
        }
        if (this.dbox_list != null && this.dbox_list.size() > 0) {
            int i = 0;
            while (i < this.dbox_list.size()) {
                this.dbox_list.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.widgetList != null && this.widgetList.size() > 0) {
            int i = 0;
            while (i < this.widgetList.size()) {
                this.widgetList.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.account_list != null && this.account_list.size() > 0) {
            int i = 0;
            while (i < this.account_list.size()) {
                this.account_list.get(i).generateElement(dom, element);
                ++i;
            }
        }
        if (this.notifications != null) {
            this.notifications.generateElement(dom, element);
        }
        if (this.getPrivilege_map().size() > 0 || this.getConsumerPrivilege_map().size() > 0) {
            Element privileges = dom.createElement("privileges");
            element.appendChild(privileges);
            this.addPrivilegeElement(dom, privileges);
        }
        if (this.getProviderPrivilege_map().size() > 0) {
            Element appDefPrivileges = dom.createElement("provides-appdefined-privileges");
            element.appendChild(appDefPrivileges);
            this.addProviderPrivilegeElement(dom, appDefPrivileges);
        }
        if (this.getFeature_map().size() > 0) {
            Collection<Feature> values = this.getFeature_map().values();
            Iterator<Feature> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, element);
            }
        }
        if (this.font != null) {
            this.font.generateElement(dom, element);
        }
        if (this.ime != null) {
            this.ime.generateElement(dom, element);
        }
        for (CustomElement c : this.getCustomElementList()) {
            c.generateElement(dom, element);
        }
    }

    private void addPrivilegeElement(Document dom, Element privileges) {
        Collection<Privilege> values;
        if (!this.getPrivilege_map().isEmpty()) {
            values = this.getPrivilege_map().values();
            for (Privilege priv : values) {
                priv.generateElement(dom, privileges, priv.getLevel());
            }
        }
        if (!this.getConsumerPrivilege_map().isEmpty()) {
            values = this.getConsumerPrivilege_map().values();
            Iterator<Privilege> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, privileges, PrivilegeLevel.APP_DEFINED_CONSUMER);
            }
        }
    }

    private void addProviderPrivilegeElement(Document dom, Element privileges) {
        if (!this.getProviderPrivilege_map().isEmpty()) {
            Collection<ProviderPrivilege> values = this.getProviderPrivilege_map().values();
            Iterator<ProviderPrivilege> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, privileges, PrivilegeLevel.APP_DEFINED_PROVIDER);
            }
        }
    }

    public IApplication getDefaultApp() {
        try {
            return this.application_list.get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public List<IApplication> getApplication_list() {
        return this.application_list;
    }

    public void setApplication_list(List<IApplication> application_list) {
        this.application_list = application_list;
    }

    public void addPrivilege(String key) {
        Privilege priv = new Privilege(key);
        this.privilege_map.put(key, priv);
    }

    public void addConsumerPrivilege(String key, String license) {
        Privilege priv = new Privilege(key, PrivilegeLevel.APP_DEFINED_CONSUMER, "[App-defined-consumer] " + key, license);
        this.consumerPrivilege_map.put(key, priv);
    }

    public void addProviderPrivilege(String key, String license) {
        ProviderPrivilege priv = new ProviderPrivilege(key, PrivilegeLevel.APP_DEFINED_PROVIDER, "[App-defined-provider] " + key, license);
        this.providerPrivilege_map.put(key, priv);
    }

    public void addPrivilege(String key, PrivilegeLevel level, String desc) {
        Privilege priv = new Privilege(key, level, desc);
        this.privilege_map.put(key, priv);
    }

    public boolean hasPrivilege(String p) {
        return this.privilege_map.containsKey(p);
    }

    public void removePrivilege(String privilege) {
        this.privilege_map.remove(privilege);
    }

    public boolean hasConsumerPrivilege(String p) {
        return this.consumerPrivilege_map.containsKey(p);
    }

    public boolean hasProviderPrivilege(String p) {
        return this.providerPrivilege_map.containsKey(p);
    }

    public void removeConsumerPrivilege(String privilege) {
        this.consumerPrivilege_map.remove(privilege);
    }

    public void removeProviderPrivilege(String privilege) {
        this.providerPrivilege_map.remove(privilege);
    }

    public TreeMap<String, String> getFeature_list() {
        return this.feature_list;
    }

    public String getFeature(String key) {
        Feature feature = this.feature_map.get(key);
        return feature.getValue();
    }

    public void setFeature_list(TreeMap<String, String> feature_list) {
        this.feature_list = feature_list;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageId() {
        return this.package_name;
    }

    public void setPackageId(String package_name) {
        this.package_name = package_name;
    }

    public Map<String, Feature> getFeature_map() {
        return this.feature_map;
    }

    public void setFeature_map(Map<String, Feature> feature_map) {
        this.feature_map = feature_map;
    }

    public void addFeature(String key, String value) {
        this.feature_map.put(key, new Feature(key, value));
    }

    public void removeFeature(String key) {
        this.feature_map.remove(key);
    }

    public Map<String, Privilege> getPrivilege_map() {
        return this.privilege_map;
    }

    public void setPrivilege_map(Map<String, Privilege> privilege_map) {
        this.privilege_map = privilege_map;
    }

    public Map<String, Privilege> getConsumerPrivilege_map() {
        return this.consumerPrivilege_map;
    }

    public Map<String, ProviderPrivilege> getProviderPrivilege_map() {
        return this.providerPrivilege_map;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public String getStoreclient_id() {
        return this.storeclient_id;
    }

    public void setStoreclient_id(String storeclient_id) {
        this.storeclient_id = storeclient_id;
    }

    public String getInstall_location() {
        return this.install_location;
    }

    public void setInstall_location(String install_location) {
        this.install_location = install_location;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getRoot_path() {
        return this.root_path;
    }

    public void setRoot_path(String root_path) {
        this.root_path = root_path;
    }

    public String getCsc_path() {
        return this.csc_path;
    }

    public void setCsc_path(String csc_path) {
        this.csc_path = csc_path;
    }

    public String getNodisplay_setting() {
        return this.nodisplay_setting;
    }

    public void setNodisplay_setting(String nodisplay_setting) {
        this.nodisplay_setting = nodisplay_setting;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSupport_disable() {
        return this.support_disable;
    }

    public void setSupport_disable(String support_disable) {
        this.support_disable = support_disable;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public Notifications getNotifications() {
        return this.notifications;
    }

    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public String getDefaultDesc() {
        return this.defaultDesc;
    }

    public void setDefaultDesc(String defaultDesc) {
        this.defaultDesc = defaultDesc;
    }

    public List<LocaledValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<LocaledValue> descriptions) {
        this.descriptions = descriptions;
    }

    private void generateDescriptions(Document dom, Element parent) {
        List<LocaledValue> desces = this.getDescriptions();
        if (desces.isEmpty() && this.getDefaultDesc() == null) {
            return;
        }
        if (this.getDefaultDesc() != null && this.getDefaultDesc().length() > 0) {
            Element eDesc = dom.createElement("description");
            eDesc.setTextContent(this.getDefaultDesc());
            parent.appendChild(eDesc);
        }
        for (LocaledValue lv : desces) {
            Element eDesc = dom.createElement("description");
            eDesc.setAttribute("xml:lang", lv.getLocale());
            eDesc.setTextContent(lv.getValue());
            parent.appendChild(eDesc);
        }
    }

    public void clear() {
        this.descriptions.clear();
        this.label_list.clear();
        IApplication app = this.getDefaultApp();
        if (app != null) {
            if (app.getAppServiceList() != null) {
                app.getAppServiceList().clear();
            }
            if (app.getBgCategoryList() != null) {
                app.getBgCategoryList().clear();
            }
        }
        this.application_list.clear();
        this.privilege_map.clear();
        this.consumerPrivilege_map.clear();
        this.providerPrivilege_map.clear();
        this.feature_map.clear();
        this.account_list.clear();
        this.dbox_list.clear();
        this.widgetList.clear();
        this.shortcutList.clear();
        this.dependencies.clear();
        if (app instanceof WidgetApplication) {
            WidgetApplication widgetApp = (WidgetApplication)app;
            widgetApp.getSupportSizesMap().clear();
        }
        this.customElementList.clear();
        this.customAttrList.clear();
        this.trustAnchor = null;
    }

    public String getApiVersion() {
        return this.api_version;
    }

    public void setApiVersion(String api_version) {
        this.api_version = api_version;
        IApplication app = this.getDefaultApp();
        if (app != null) {
            if (CheckerUtil.isApplicationAPIVersionSupported(api_version)) {
                app.setApiVersion(api_version);
            } else {
                app.setApiVersion(null);
            }
        }
    }

    public List<Account> getAccounts() {
        return this.account_list;
    }

    public void setAccounts(Account account) {
        this.account_list.add(account);
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfileName(String profileName) {
        if (profileName == null) {
            return;
        }
        this.profile.setName(profileName);
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_API_VERSION)) {
            return false;
        }
        if (attr.equals(ATTR_APPSETTING)) {
            return false;
        }
        if (attr.equals(ATTR_CSC_PATH)) {
            return false;
        }
        if (attr.equals(ATTR_INSTALL_LOCATION)) {
            return false;
        }
        if (attr.equals(ATTR_NODISPLAY_SETTING)) {
            return false;
        }
        if (attr.equals(ATTR_PACKAGE)) {
            return false;
        }
        if (attr.equals(ATTR_ROOT_PATH)) {
            return false;
        }
        if (attr.equals(ATTR_SIZE)) {
            return false;
        }
        if (attr.equals(ATTR_STORECLIENT_ID)) {
            return false;
        }
        if (attr.equals(ATTR_SUPPORT_DISABLE)) {
            return false;
        }
        if (attr.equals(ATTR_TYPE)) {
            return false;
        }
        if (attr.equals(ATTR_URL)) {
            return false;
        }
        if (attr.equals(ATTR_VERSION)) {
            return false;
        }
        return !attr.equals(ATTR_XMLNS);
    }

    public List<Shortcut> getShortCutList() {
        return this.shortcutList;
    }

    public String getTrust_anchor_path() {
        return this.trust_anchor_path;
    }

    public void setTrust_anchor_path(String trust_anchor_path) {
        this.trust_anchor_path = trust_anchor_path;
    }

    public TrustAnchor getTrustAnchor() {
        return this.trustAnchor;
    }

    public void setTrustAnchor(TrustAnchor trustAnchor) {
        this.trustAnchor = trustAnchor;
    }
}

