/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.tizen.nativecommon.build.IProjectListener;

public class CurrentEnabledProject {
    private static IProject project = null;
    private static ISelectionListener listener;
    private static Set<IProjectListener> projectListener;

    static {
        projectListener = new HashSet<IProjectListener>();
        listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
                IProject tempProj = null;
                if (sourcepart instanceof IEditorPart) {
                    tempProj = CurrentEnabledProject.getProject(new Object[]{((IEditorPart)sourcepart).getEditorInput()});
                }
                if (selection instanceof IStructuredSelection) {
                    tempProj = CurrentEnabledProject.getProject(((IStructuredSelection)selection).toArray());
                }
                if (tempProj != null && project != tempProj) {
                    project = tempProj;
                    CurrentEnabledProject.notifySelectedProjectChangedListener();
                }
            }
        };
    }

    private CurrentEnabledProject() {
    }

    public static synchronized void addProjectListener(IProjectListener listener) {
        projectListener.add(listener);
    }

    public static synchronized void removeProjectListener(IProjectListener listener) {
        projectListener.remove(listener);
    }

    public static synchronized void notifySelectedProjectChangedListener() {
        for (IProjectListener tl : projectListener) {
            if (tl == null) continue;
            tl.SelectedProjectChanged(project);
        }
    }

    public static IProject getCurrentProject() {
        return project;
    }

    public static IProject setCurrentProject(IProject newProject) {
        IProject oldProject = project;
        project = newProject;
        return oldProject;
    }

    public static ISelectionListener getSelectionListener() {
        return listener;
    }

    private static IProject getProject(Object[] elements) {
        int nElements = elements.length;
        int i = 0;
        while (i < nElements) {
            IResource r;
            if (elements[i] instanceof IAdaptable && (r = (IResource)((IAdaptable)elements[i]).getAdapter(IResource.class)) != null) {
                return r.getProject();
            }
            ++i;
        }
        return null;
    }
}

