/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.tizen.sbilib.lib.PathUtil;

public class Log {
    private FileWriter writer = null;
    private FileWriter errorWriter = null;
    private String prefix = null;
    private int errorLevel = 2;
    private static final String LOG_TYPE_PRE_SEPERATOR = "[";
    private static final String LOG_TYPE_POST_SEPERATOR = "]";
    private static final String LOG_PREFIX_SEPERATOR = " ";
    private static final String LOG_ERROR_FILE = "error.log";
    private static Throwable logException = null;

    private Log(File logFile) {
        try {
            this.writer = new FileWriter(logFile);
        }
        catch (IOException e) {
            logException = e;
            return;
        }
        String errorLogPath = PathUtil.addPath(logFile.getParent(), LOG_ERROR_FILE);
        File errorLogFile = new File(errorLogPath);
        if (errorLogFile.exists()) {
            try {
                errorLogFile.delete();
            }
            catch (SecurityException e) {
                logException = e;
                return;
            }
        }
        try {
            errorLogFile.createNewFile();
        }
        catch (IOException e) {
            logException = e;
            return;
        }
        try {
            this.errorWriter = new FileWriter(errorLogPath);
        }
        catch (IOException e) {
            logException = e;
            return;
        }
    }

    public void setErrorLevel(int level) {
        this.errorLevel = level <= 0 ? 0 : (level >= 4 ? 4 : level);
    }

    public boolean log(String message) {
        return this.log(LogType.LOG, message);
    }

    public boolean info(String message) {
        return this.log(LogType.INFO, message);
    }

    public boolean warn(String message) {
        return this.log(LogType.WARN, message);
    }

    public boolean error(String message) {
        return this.log(LogType.ERROR, message);
    }

    public boolean exception(Throwable e) {
        boolean ret = this.log(LogType.EXCEPTION, e.getMessage());
        PrintWriter pw = new PrintWriter(this.writer);
        e.printStackTrace(pw);
        pw.flush();
        return ret;
    }

    public static String getCallerMethod() {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return className + "." + methodName;
    }

    public static Throwable getException() {
        return logException;
    }

    private boolean log(LogType logType, String message) {
        StringBuffer logMessage = this.getLogMessage(logType, message);
        try {
            this.writer.write(logMessage.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            logException = e;
            return false;
        }
        if (logType.getLevel() <= this.errorLevel) {
            this.errorLog(logMessage);
        }
        return true;
    }

    private boolean errorLog(StringBuffer msg) {
        try {
            this.errorWriter.write(msg.toString());
            this.errorWriter.flush();
            return true;
        }
        catch (IOException e) {
            logException = e;
            return false;
        }
    }

    private StringBuffer getLogMessage(LogType logType, String message) {
        StringBuffer sb = new StringBuffer(message);
        if (logType != null && logType != LogType.LOG) {
            sb.insert(0, LOG_TYPE_PRE_SEPERATOR + logType.toString() + LOG_TYPE_POST_SEPERATOR);
        }
        if (this.prefix != null && !this.prefix.isEmpty()) {
            sb.insert(0, this.prefix + LOG_PREFIX_SEPERATOR);
        }
        return sb;
    }

    public void setPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static Log createLog(String logFilePath) {
        if (logFilePath == null || logFilePath.isEmpty()) {
            return null;
        }
        File logFile = new File(logFilePath);
        if (logFile.exists()) {
            if (logFile.isDirectory()) {
                return null;
            }
            try {
                logFile.delete();
            }
            catch (SecurityException e) {
                logException = e;
                return null;
            }
        }
        File parentFile = logFile.getParentFile();
        if (!parentFile.exists()) {
            try {
                parentFile.mkdirs();
            }
            catch (SecurityException e) {
                logException = e;
                return null;
            }
        }
        try {
            logFile.createNewFile();
            return new Log(logFile);
        }
        catch (SecurityException e) {
            logException = e;
            return null;
        }
        catch (IOException e) {
            logException = e;
            return null;
        }
    }

    static enum LogType {
        LOG("", 4),
        INFO("info", 3),
        WARN("warn", 2),
        ERROR("error", 1),
        EXCEPTION("Excep", 0);

        private String logType = null;
        private int level;

        private LogType(String type, int level) {
            this.logType = type;
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public String toString() {
            return this.logType;
        }
    }
}

