/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.makefile;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.RebuildResourcesManager;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;

public class NativeCoreRebuildChecker {
    private static IBuildResource[] getRebuildIncludes(IProject project) {
        IBuildResource[] rcs = RebuildResourcesManager.getRebuildResources((IProject)project);
        ArrayList<IBuildResource> list = new ArrayList<IBuildResource>();
        IBuildResource[] iBuildResourceArray = rcs;
        int n = rcs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResource r = iBuildResourceArray[n2];
            IPath file = r.getLocation();
            String ext = file.getFileExtension();
            if (ext.equals("h")) {
                list.add(r);
            }
            ++n2;
        }
        return list.toArray(new IBuildResource[list.size()]);
    }

    private static boolean existsPCHSrc(IProject project) {
        IFile file = project.getFolder("inc").getFile("tizenx.h");
        return file.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isModifiedIncludes(IProject project) {
        if (!NativeCoreRebuildChecker.existsPCHSrc(project)) {
            return false;
        }
        IFile file = project.getFolder("inc").getFile("tizenx.h");
        IPath pchSourcePath = file.getFullPath();
        IBuildResource[] rcs = NativeCoreRebuildChecker.getRebuildIncludes(project);
        if (rcs.length <= 0) {
            return false;
        }
        IBuildResource[] iBuildResourceArray = rcs;
        int n = rcs.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResource h = iBuildResourceArray[n2];
            if (h.getFullPath().equals((Object)pchSourcePath)) {
                return true;
            }
            ++n2;
        }
        try {
            IPath[] includes = RebuildResourcesManager.findIncludes((IProject)project, (IPath)pchSourcePath);
            IBuildResource[] iBuildResourceArray2 = rcs;
            int n3 = rcs.length;
            n = 0;
            block3: while (true) {
                if (n >= n3) {
                    return false;
                }
                IBuildResource h = iBuildResourceArray2[n];
                String path = h.getLocation().toOSString();
                IPath[] iPathArray = includes;
                int n4 = includes.length;
                int n5 = 0;
                while (true) {
                    if (n5 >= n4) {
                        ++n;
                        continue block3;
                    }
                    IPath inc = iPathArray[n5];
                    String path2 = inc.toOSString();
                    if (path.equals(path2)) {
                        return true;
                    }
                    ++n5;
                }
                break;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isRemovedObjs(IProject project) {
        IConfiguration config = NativeCoreConfigurationManager.getDefaultConfiguration((IProject)project);
        if (config == null) {
            return false;
        }
        String configName = config.getName();
        File configDir = project.getFolder(configName).getLocation().toFile();
        if (!configDir.isDirectory()) {
            return false;
        }
        ArrayList<File> objList = new ArrayList<File>();
        NativeCoreRebuildChecker.findObjFile(configDir, objList);
        return objList.size() == 0;
    }

    private static void findObjFile(File file, List<File> list) {
        if (file.isDirectory()) {
            String[] files = file.list();
            if (files == null) {
                return;
            }
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                File f1 = new Path(file.getPath()).append(f).toFile();
                NativeCoreRebuildChecker.findObjFile(f1, list);
                ++n2;
            }
        } else if (NativeCoreRebuildChecker.isObjFile(file)) {
            list.add(file);
        }
    }

    private static boolean isObjFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        IPath path = Path.fromOSString((String)file.getAbsolutePath());
        String ext = path.getFileExtension();
        return ext != null && ext.equals("o");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean needsPCHBuild(IProject project, List<IPath> srcList) {
        if (!NativeCoreRebuildChecker.existsPCHSrc(project)) {
            return false;
        }
        IFile file = project.getFolder("inc").getFile("tizenx.h");
        try {
            Iterator<IPath> iterator = srcList.iterator();
            block2: while (true) {
                IPath[] includes;
                if (!iterator.hasNext()) {
                    return false;
                }
                IPath src = iterator.next();
                IPath[] iPathArray = includes = RebuildResourcesManager.findIncludes((IProject)project, (IPath)src);
                int n = includes.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    IPath inc = iPathArray[n2];
                    if (inc.equals((Object)file.getLocation())) {
                        return true;
                    }
                    ++n2;
                }
                break;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean needsPCHRebuild(IProject project) {
        return NativeCoreRebuildChecker.isModifiedIncludes(project) || NativeCoreRebuildChecker.isRemovedObjs(project);
    }
}

