/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IBuildModelBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IResourceRebuildStateContainer;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CommandBuilder
implements IBuildModelBuilder {
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private IBuildCommand fCmd;
    private Process fProcess;
    private String fErrMsg;
    private IProject fProject;

    public CommandBuilder(IBuildCommand cmd, IResourceRebuildStateContainer cr, IProject project) {
        this.fCmd = cmd;
        this.fProject = project;
    }

    protected OutputStream wrap(OutputStream out) {
        return new OutputStreamWrapper(out);
    }

    @Override
    public int build(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        int status = -2;
        try {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", this.getNumCommands());
                monitor.subTask(String.valueOf(ManagedMakeMessages.getResourceString("MakeBuilder.Invoking_Command")) + this.getCommandLine());
                ICommandLauncher launcher = this.createLauncher();
                launcher.showCommand(true);
                this.fProcess = launcher.execute(this.fCmd.getCommand(), this.fCmd.getArgs(), this.mapToStringArray(this.fCmd.getEnvironment()), this.fCmd.getCWD(), monitor);
                if (this.fProcess != null) {
                    try {
                        this.fProcess.getOutputStream().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    int st = launcher.waitAndRead(this.wrap(out), this.wrap(err), (IProgressMonitor)new SubProgressMonitor(monitor, this.getNumCommands()));
                    switch (st) {
                        case 0: {
                            status = this.fProcess.exitValue() == 0 ? 0 : -1;
                            break;
                        }
                        case 1: {
                            status = -3;
                            break;
                        }
                        default: {
                            status = -2;
                        }
                    }
                }
                this.fErrMsg = launcher.getErrorMessage();
                if (this.fErrMsg != null && !this.fErrMsg.isEmpty()) {
                    this.printMessage(this.fErrMsg, err);
                }
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Error launching command [" + this.fCmd.getCommand() + "]", (Throwable)e));
                status = -2;
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected ICommandLauncher createLauncher() {
        return CommandLauncherManager.getInstance().getCommandLauncher(this.fProject);
    }

    public String getErrMsg() {
        return this.fErrMsg;
    }

    private String[] mapToStringArray(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Set<Map.Entry<String, String>> entrySet = map.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            list.add(String.valueOf(entry.getKey()) + '=' + entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    protected void printMessage(String msg, OutputStream os) {
        if (os != null) {
            try {
                os.write((String.valueOf(msg) + NEWLINE).getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getNumCommands() {
        return 1;
    }

    protected String getCommandLine() {
        StringBuilder buf = new StringBuilder();
        if (this.fCmd != null) {
            buf.append(this.fCmd.getCommand().toOSString());
            String[] args = this.fCmd.getArgs();
            int i = 0;
            while (i < args.length) {
                buf.append(' ');
                buf.append(args[i]);
                ++i;
            }
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    protected class OutputStreamWrapper
    extends OutputStream {
        private OutputStream fOut;

        public OutputStreamWrapper(OutputStream out) {
            this.fOut = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.fOut.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.fOut.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.fOut.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.fOut.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

