/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.tizen.nativecore.misc.core.PrivilegeManager;
import org.tizen.nativecore.misc.editor.ManifestEditor;
import org.tizen.nativecore.misc.editor.ManifestSchemaValidator;
import org.tizen.nativecore.misc.editor.PrivilegePage;
import org.tizen.nativecore.misc.utils.CheckCycle;
import org.tizen.nativecore.misc.utils.Constants;
import org.tizen.nativecore.misc.utils.PositionalXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CheckerUtil {
    public static final String MANIFEST_MARKER_ID = "org.tizen.nativecore.misc.manifestProblem";
    private static Logger logger = LoggerFactory.getLogger(CheckerUtil.class);

    public static void runChecker(IProject project, ManifestEditor editor, String apiVersion) throws CoreException, ParserConfigurationException, SAXException, IOException {
        Document doc;
        if (project == null) {
            return;
        }
        IFile manifestFile = project.getFile("tizen-manifest.xml");
        assert (manifestFile.exists());
        manifestFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        PositionalXmlParser parser = new PositionalXmlParser();
        CheckerUtil.validateSchema(manifestFile, apiVersion);
        if (editor != null) {
            doc = parser.parse(editor.getStructuredDocument().get());
        } else {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(manifestFile.getContents());
        }
        PrivilegePage fCorePrivilegePage = null;
        if (editor != null) {
            fCorePrivilegePage = editor.getPrivilegePage();
        }
        NodeList nodes = doc.getElementsByTagName("privilege");
        int i = 0;
        while (i < nodes.getLength()) {
            PrivilegeManager privilegeManager;
            PrivilegeLevel level;
            Element e = (Element)nodes.item(i);
            if (fCorePrivilegePage != null && (level = (privilegeManager = fCorePrivilegePage.getPrivilegeManager()).getPrivilegeLevel(e.getTextContent())) != PrivilegeLevel.PUBLIC) {
                CheckerUtil.createWarningMarker(parser, (IResource)manifestFile, e, "This privilege requires " + level.getName().toLowerCase() + " level signing key.");
            }
            ++i;
        }
        CheckerUtil.validateElements(doc, (IResource)manifestFile, parser);
    }

    public static void validateElements(Document doc, IResource res, PositionalXmlParser parser) throws CoreException {
        Element manifest = doc.getDocumentElement();
        String packName = manifest.getAttribute("package");
        if (packName.length() > Constants.MAX_PKGID_LENGTH || packName.length() < Constants.MIN_PKGID_LENGTH) {
            CheckerUtil.createErrorMarker(parser, res, manifest, Constants.pkgIDErrorMsg);
        }
        String version = manifest.getAttribute("version");
        boolean isVersionError = false;
        if (version.isEmpty()) {
            isVersionError = true;
        } else {
            String[] num = version.split("\\.");
            if (num.length < 3) {
                isVersionError = true;
            } else {
                int majorVersion = Integer.parseInt(num[0]);
                int minorVersion = Integer.parseInt(num[1]);
                int minor_minor_Version = Integer.parseInt(num[2]);
                if (majorVersion < 0 || majorVersion > 255) {
                    isVersionError = true;
                }
                if (minorVersion < 0 || minorVersion > 255) {
                    isVersionError = true;
                }
                if (minor_minor_Version < 0 || minor_minor_Version > 65535) {
                    isVersionError = true;
                }
            }
        }
        if (isVersionError) {
            CheckerUtil.createErrorMarker(parser, res, manifest, "Invalid Version Number");
        }
        NodeList uiApps = manifest.getElementsByTagName("ui-application");
        int i = 0;
        while (i < uiApps.getLength()) {
            Element e = (Element)uiApps.item(i);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                CheckerUtil.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i;
        }
        NodeList serviceApps = manifest.getElementsByTagName("service-application");
        int i2 = 0;
        while (i2 < serviceApps.getLength()) {
            Element e = (Element)serviceApps.item(i2);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                CheckerUtil.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i2;
        }
        NodeList watchApps = manifest.getElementsByTagName("watch-application");
        int i3 = 0;
        while (i3 < watchApps.getLength()) {
            Element e = (Element)watchApps.item(i3);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                CheckerUtil.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i3;
        }
        NodeList widgetApps = manifest.getElementsByTagName("widget-application");
        int i4 = 0;
        while (i4 < widgetApps.getLength()) {
            Element e = (Element)widgetApps.item(i4);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                CheckerUtil.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                CheckerUtil.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i4;
        }
    }

    public static void validateSchema(IFile configFile, String apiVersion) {
        if (configFile == null) {
            return;
        }
        ManifestSchemaValidator msv = new ManifestSchemaValidator();
        String schemaFile = "manifest_core.xsd";
        if (apiVersion.equalsIgnoreCase("6.0")) {
            schemaFile = "manifest_6.0.xsd";
        } else if (apiVersion.equalsIgnoreCase("5.5")) {
            schemaFile = "manifest_5.5.xsd";
        } else if (apiVersion.equalsIgnoreCase("5.0")) {
            schemaFile = "manifest_5.0.xsd";
        } else if (apiVersion.equalsIgnoreCase("4.0")) {
            schemaFile = "manifest_4.0.xsd";
        } else if (apiVersion.equalsIgnoreCase("3.0")) {
            schemaFile = "manifest_3.0.xsd";
        } else if (apiVersion.equalsIgnoreCase("2.4")) {
            schemaFile = "manifest_2.4.xsd";
        } else if (apiVersion.equalsIgnoreCase("2.3.2")) {
            schemaFile = "manifest_2.3.2.xsd";
        } else if (apiVersion.equalsIgnoreCase("2.3.1")) {
            schemaFile = "manifest_2.3.1.xsd";
        } else if (apiVersion.equalsIgnoreCase("2.3")) {
            schemaFile = "manifest_2.3.xsd";
        }
        msv.validateConfigurationDocument(configFile, new String[]{"xml.xsd", schemaFile});
    }

    private static List<String> getDependentProject(String filepath) {
        if (!Files.exists(Paths.get(filepath, new String[0]), new LinkOption[0])) {
            return null;
        }
        ArrayList<String> dependencyList = new ArrayList<String>();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(filepath);
            doc.getDocumentElement().normalize();
            Element element = doc.getDocumentElement();
            Node node = element.getFirstChild();
            while (node != null) {
                String nodeName = node.getNodeName();
                if (nodeName.equals("dependencies")) {
                    Node subnode = node.getFirstChild();
                    while (subnode != null) {
                        String nodeName1 = subnode.getNodeName();
                        System.out.println(subnode.getTextContent());
                        if (nodeName1.equals("dependency")) {
                            dependencyList.add(subnode.getTextContent());
                        }
                        subnode = subnode.getNextSibling();
                    }
                }
                node = node.getNextSibling();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dependencyList;
    }

    public static List<String> checkCyclicDependency(String currentPkgID) {
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> projectList = new ArrayList<String>();
        ArrayList<String> pkgIDList = new ArrayList<String>();
        ArrayList<String> projectPathList = new ArrayList<String>();
        IProject[] iProjectArray = workspaceProjects;
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            projectList.add(project.getName());
            pkgIDList.add(CheckerUtil.getPkgIDFromManifest(String.valueOf(project.getLocation().toOSString()) + "/" + "tizen-manifest.xml"));
            projectPathList.add(project.getLocation().toOSString());
            ++n2;
        }
        CheckCycle graph = new CheckCycle();
        for (String pkgID : pkgIDList) {
            List<String> dependencyList = CheckerUtil.getDependentProject(String.valueOf((String)projectPathList.get(pkgIDList.indexOf(pkgID))) + "/" + "tizen-manifest.xml");
            if (dependencyList == null) continue;
            for (String dependent : dependencyList) {
                graph.addEdge(pkgID, dependent);
            }
        }
        return graph.check(currentPkgID);
    }

    public static String getPkgIDFromManifest(String filepath) {
        if (!Files.exists(Paths.get(filepath, new String[0]), new LinkOption[0])) {
            return "";
        }
        String pkgID = "";
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(filepath);
            doc.getDocumentElement().normalize();
            Element element = doc.getDocumentElement();
            pkgID = element.getAttribute("package").toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return pkgID;
    }

    private static void createErrorMarker(PositionalXmlParser parser, IResource res, Element e, String errorMessage) throws CoreException {
        PositionalXmlParser.NodePosition pos = parser.getPosition(e);
        if (pos == null) {
            return;
        }
        IMarker marker = res.createMarker(MANIFEST_MARKER_ID);
        marker.setAttribute("message", (Object)errorMessage);
        marker.setAttribute("lineNumber", pos.getStartLine() + 1);
        marker.setAttribute("severity", 2);
        marker.setAttribute("charStart", pos.getStart());
    }

    private static void createWarningMarker(PositionalXmlParser parser, IResource res, Element e, String errorMessage) throws CoreException {
        PositionalXmlParser.NodePosition pos = parser.getPosition(e);
        if (pos == null) {
            return;
        }
        IMarker marker = res.createMarker(MANIFEST_MARKER_ID);
        marker.setAttribute("message", (Object)errorMessage);
        marker.setAttribute("lineNumber", pos.getStartLine() + 1);
        marker.setAttribute("severity", 1);
        marker.setAttribute("charStart", pos.getStart());
    }

    public static boolean isApplicationAPIVersionSupported(String version) {
        String[] num = version.split("\\.");
        if (num.length <= 1) {
            return false;
        }
        int mainVersion = Integer.parseInt(num[0]);
        int subVersion = Integer.parseInt(num[1]);
        return mainVersion == 5 && subVersion >= 5 || mainVersion > 5 && subVersion >= 0;
    }
}

