/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class IncludeFolderDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        boolean isAccesible = true;
        if (element instanceof IncludeReferenceProxy) {
            IIncludeReference reference = ((IncludeReferenceProxy)((Object)element)).getReference();
            IPath path = reference.getPath();
            IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(path);
            isAccesible = container != null ? container.isAccessible() : path.toFile().exists();
        } else if (element instanceof IIncludeReference) {
            IPath path = ((IIncludeReference)element).getPath();
            isAccesible = path.toFile().exists();
        }
        if (!isAccesible) {
            decoration.addOverlay(CDTSharedImages.getImageDescriptor("icons/tovr16/warning_co.png"));
            decoration.setForegroundColor(JFaceResources.getColorRegistry().get("QUALIFIER_COLOR"));
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

