/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariableTemplate;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredVariableInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPDeferredVariableInstance;
import org.eclipse.core.runtime.CoreException;

public class CPPDeferredVariableInstance
extends CPPUnknownBinding
implements ICPPDeferredVariableInstance,
ISerializableType {
    private final ICPPVariableTemplate fTemplate;
    private final ICPPTemplateArgument[] fArguments;

    public CPPDeferredVariableInstance(ICPPVariableTemplate template, ICPPTemplateArgument[] arguments) {
        super(template.getNameCharArray());
        this.fTemplate = template;
        this.fArguments = arguments;
    }

    @Override
    public IBinding getOwner() {
        return this.fTemplate.getOwner();
    }

    @Override
    public ICPPVariableTemplate getSpecializedBinding() {
        return this.fTemplate;
    }

    @Override
    public ICPPTemplateParameterMap getTemplateParameterMap() {
        ICPPTemplateParameter[] params = this.fTemplate.getTemplateParameters();
        int size = Math.min(this.fArguments.length, params.length);
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(size);
        int i = 0;
        while (i < size) {
            map.put(params[i], this.fArguments[i]);
            ++i;
        }
        return map;
    }

    @Override
    public IType getType() {
        InstantiationContext context = new InstantiationContext(this.getTemplateParameterMap(), null);
        return CPPTemplates.instantiateType(this.fTemplate.getType(), context);
    }

    @Override
    public IValue getInitialValue() {
        return IntegralValue.UNKNOWN;
    }

    @Override
    public boolean isStatic() {
        return this.fTemplate.isStatic();
    }

    @Override
    public boolean isExtern() {
        return this.fTemplate.isExtern();
    }

    @Override
    public boolean isAuto() {
        return this.fTemplate.isAuto();
    }

    @Override
    public boolean isRegister() {
        return this.fTemplate.isRegister();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return this.fTemplate.isConstexpr();
    }

    @Override
    public boolean isExternC() {
        return this.fTemplate.isExternC();
    }

    @Override
    public ICPPVariableTemplate getTemplateDefinition() {
        return this.fTemplate;
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = 19;
        buffer.putShort(firstBytes);
        buffer.marshalBinding(this.fTemplate);
        buffer.putInt(this.fArguments.length);
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = this.fArguments;
        int n = this.fArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            buffer.marshalTemplateArgument(arg);
            ++n2;
        }
    }

    public static ICPPDeferredVariableInstance unmarshal(IIndexFragment fragment, short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        IBinding template = buffer.unmarshalBinding();
        int argcount = buffer.getInt();
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[argcount];
        int i = 0;
        while (i < argcount) {
            args[i] = buffer.unmarshalTemplateArgument();
            ++i;
        }
        return new PDOMCPPDeferredVariableInstance(fragment, (ICPPVariableTemplate)template, args);
    }
}

