/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.internal.ui.wizard.icon;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativecore.misc.core.IconType;
import org.tizen.nativecore.misc.core.ScreenDensity;
import org.tizen.nativecore.misc.internal.ui.wizard.icon.UiNewIconWizard;
import org.tizen.nativecore.misc.utils.Constants;

public class UiConfigureIconPage
extends WizardPage {
    private Text fText;
    private Button fBrowseBtn;
    private Combo fDensityCombo;
    private Label fPreviewImage;
    private Label fPreviewLabel;
    private Button fApplyEffectCheck;
    private UiNewIconWizard.Options fRefOptions;
    private BufferedImage fEffectImage;
    private BufferedImage fMaskImage;
    private Button fBtnMakeCircular;

    public UiConfigureIconPage(UiNewIconWizard wizard) {
        super("configIcon");
        this.setTitle("Configure Icon");
        this.setDescription("Select icon image");
        this.fRefOptions = wizard.getOptions();
    }

    public void createControl(Composite parent) {
        Composite grid = new Composite(parent, 0);
        this.setControl((Control)grid);
        grid.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(1808);
        grid.setLayoutData((Object)gd);
        Label lblImageFile = new Label(grid, 0);
        lblImageFile.setText("Image file");
        lblImageFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fText = new Text(grid, 2048);
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiConfigureIconPage.this.updatePageComplete();
            }
        });
        this.fText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fBrowseBtn = new Button(grid, 8);
        this.fBrowseBtn.setText("Browse...");
        this.fBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
                dialog.setFilterExtensions(Constants.IMAGE_EXTS);
                dialog.setFilterNames(new String[]{"Image Files"});
                String src = dialog.open();
                if (src == null) {
                    return;
                }
                UiConfigureIconPage.this.fText.setText(src);
            }
        });
        this.fBrowseBtn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.fPreviewLabel = new Label(grid, 0);
        this.fPreviewLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fPreviewLabel.setText("Preview:");
        this.fPreviewLabel.setAlignment(0x1000000);
        Label lblDensity = new Label(grid, 0);
        lblDensity.setText("Density");
        lblDensity.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.fDensityCombo = new Combo(grid, 8);
        ScreenDensity[] screenDensityArray = ScreenDensity.values();
        int n = screenDensityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScreenDensity sd = screenDensityArray[n2];
            this.fDensityCombo.add(sd.getName());
            ++n2;
        }
        this.fDensityCombo.select(0);
        this.fDensityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiConfigureIconPage.this.reloadMaskImages();
                UiConfigureIconPage.this.updatePageComplete();
            }
        });
        new Label(grid, 0);
        this.fPreviewImage = new Label(grid, 2048);
        gd = new GridData(0x1000000, 0x1000000, false, false, 1, 3);
        gd.widthHint = 140;
        gd.heightHint = 166;
        this.fPreviewImage.setLayoutData((Object)gd);
        this.fPreviewImage.setAlignment(0x1000000);
        new Label(grid, 0);
        this.fBtnMakeCircular = new Button(grid, 32);
        this.fBtnMakeCircular.setText("Apply a circular shape");
        this.fBtnMakeCircular.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiConfigureIconPage.this.updatePageComplete();
            }
        });
        new Label(grid, 0);
        new Label(grid, 0);
        this.fApplyEffectCheck = new Button(grid, 32);
        this.fApplyEffectCheck.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.fApplyEffectCheck.setText("Apply a shadow effect");
        this.fApplyEffectCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiConfigureIconPage.this.updatePageComplete();
            }
        });
        new Label(grid, 0);
        this.setPageComplete(false);
    }

    private int getRecommendedIconSize() {
        ScreenDensity density = ScreenDensity.getEnum(this.fDensityCombo.getText());
        if (density != null) {
            return this.fRefOptions.getIconType().getIconSize(density);
        }
        return 0;
    }

    private void updatePageComplete() {
        this.setMessage(null);
        this.setPageComplete(false);
        if (this.fRefOptions.getIconType() == null) {
            return;
        }
        this.fApplyEffectCheck.setEnabled(this.fBtnMakeCircular.getSelection());
        int size = 0;
        if (!this.fRefOptions.getIconType().equals((Object)IconType.ETC)) {
            size = this.getRecommendedIconSize();
        }
        if (size == 0) {
            this.fPreviewLabel.setText("Preview");
        } else {
            this.fPreviewLabel.setText(String.format("Preview(%1$dx%2$d)", size, size));
        }
        String filename = this.fText.getText().trim();
        if (filename.length() <= 0) {
            this.setMessage("Choose an icon file", 3);
            return;
        }
        File file = new File(filename);
        if (file.isDirectory() || !file.exists()) {
            this.setMessage("The file doesn't exist.", 3);
            return;
        }
        this.fRefOptions.setSrcFile(file);
        ScreenDensity density = ScreenDensity.getEnum(this.fDensityCombo.getText());
        this.fRefOptions.setDensity(density);
        this.updatePreview();
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.fRefOptions.getIconType() == IconType.ETC) {
                this.fDensityCombo.setEnabled(false);
            }
            if (this.fRefOptions.getIconType() == IconType.MAINMENU) {
                this.fApplyEffectCheck.setVisible(true);
                this.fBtnMakeCircular.setVisible(true);
            } else {
                this.fApplyEffectCheck.setVisible(false);
                this.fBtnMakeCircular.setVisible(false);
            }
            this.reloadMaskImages();
            this.updatePageComplete();
        }
    }

    private void reloadMaskImages() {
        if (this.fRefOptions.getIconType().isCircleIcon()) {
            String dir = String.format("/images/%1$s/%2$s/", this.fRefOptions.getIconType().name().toLowerCase(), this.fDensityCombo.getText());
            String maskPath = String.valueOf(dir) + "mask.png";
            String effectPath = String.valueOf(dir) + "effect.png";
            this.fMaskImage = this.fRefOptions.getCachedImage(maskPath, true);
            this.fEffectImage = this.fRefOptions.getCachedImage(effectPath, true);
            this.fRefOptions.setRecommendedSize(this.fMaskImage.getWidth());
        }
    }

    protected void updatePreview() {
        Shell shell = this.getShell();
        if (this.fRefOptions.getSrcFile() == null || shell == null) {
            return;
        }
        org.eclipse.swt.graphics.Image image = null;
        if (this.fRefOptions.getIconType().isCircleIcon() && this.fBtnMakeCircular.getSelection()) {
            BufferedImage srcImage = this.fRefOptions.getCachedImage(this.fRefOptions.getSrcFile().getAbsolutePath(), false);
            if (srcImage == null) {
                return;
            }
            int idealSize = this.fRefOptions.getRecommendedSize();
            if (srcImage.getWidth() != idealSize) {
                srcImage = ImageUtil.getScaledImage((BufferedImage)srcImage, (int)idealSize, (int)idealSize);
            }
            BufferedImage tempImage = new BufferedImage(this.fMaskImage.getWidth(), this.fMaskImage.getHeight(), 2);
            Graphics2D graph = tempImage.createGraphics();
            graph.drawImage((Image)this.fMaskImage, 0, 0, null);
            graph.setComposite(AlphaComposite.SrcAtop);
            graph.drawImage((Image)srcImage, 0, 0, null);
            if (this.fEffectImage != null && this.fApplyEffectCheck.getSelection()) {
                graph.drawImage((Image)this.fEffectImage, 0, 0, null);
            }
            graph.dispose();
            image = ImageUtil.convertImageToSWT((Display)shell.getDisplay(), (BufferedImage)tempImage);
        } else {
            int size;
            BufferedImage srcImage = this.fRefOptions.getCachedImage(this.fRefOptions.getSrcFile().getAbsolutePath(), false);
            if (!this.fRefOptions.getIconType().equals((Object)IconType.ETC) && (size = this.getRecommendedIconSize()) != 0 && srcImage.getWidth() != size && srcImage.getHeight() != size) {
                srcImage = ImageUtil.getScaledImage((BufferedImage)srcImage, (int)size, (int)size);
            }
            image = ImageUtil.convertImageToSWT((Display)this.fPreviewImage.getDisplay(), (BufferedImage)srcImage);
        }
        this.fRefOptions.setImage(image);
        this.fPreviewImage.setImage(image);
    }
}

