/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.nativeappcommon";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void logAndDisplayError(String message, Exception e) {
        this.logError(message, e);
        this.displayError(message, e);
    }

    public void logError(String mainMessage, Exception exception) {
        this.log(4, mainMessage, exception);
    }

    public void displayError(final String mainMessage, Exception exception) {
        final IStatus status = mainMessage == null && exception instanceof CoreException ? ((CoreException)exception).getStatus() : this.createStatus(4, exception == null ? mainMessage : null, exception);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = null;
                if (plugin != null) {
                    window = plugin.getWorkbench().getActiveWorkbenchWindow();
                }
                Shell shell = null;
                if (window != null) {
                    shell = window.getShell();
                }
                ErrorDialog.openError((Shell)shell, (String)"Error", (String)mainMessage, (IStatus)status);
            }
        };
        if (plugin != null) {
            plugin.getWorkbench().getDisplay().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void log(int severity, String mainMessage, Exception exception) {
        IStatus status = mainMessage == null && exception instanceof CoreException ? ((CoreException)exception).getStatus() : this.createStatus(severity, mainMessage, exception);
        if (plugin != null) {
            plugin.getLog().log(status);
        } else {
            System.err.println(status.toString());
        }
    }

    private IStatus createStatus(int severity, String mainMessage, Exception exception) {
        Status status = new Status(severity, PLUGIN_ID, 0, mainMessage != null ? mainMessage : (exception != null ? exception.getMessage() : null), (Throwable)exception);
        return status;
    }
}

