/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumeration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPEnumerationSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumeratorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPEnumerationSpecialization
extends CPPSpecialization
implements ICPPEnumerationSpecialization {
    private final IEnumerator[] fEnumerators;
    private final IType fFixedType;
    private boolean fInitializationComplete;

    public static IBinding createInstance(ICPPEnumeration enumeration, ICPPClassSpecialization owner, ICPPTemplateParameterMap tpMap, IASTNode point) {
        IType fixedType = enumeration.getFixedType();
        if (fixedType != null) {
            ICPPClassSpecialization within = CPPTemplates.getSpecializationContext(owner);
            InstantiationContext context = new InstantiationContext(tpMap, within, point);
            fixedType = CPPTemplates.instantiateType(fixedType, context);
        }
        CPPEnumerationSpecialization specializedEnumeration = new CPPEnumerationSpecialization(enumeration, owner, tpMap, fixedType);
        specializedEnumeration.initialize(point);
        return specializedEnumeration;
    }

    private CPPEnumerationSpecialization(ICPPEnumeration specialized, IBinding owner, ICPPTemplateParameterMap argumentMap, IType fixedType) {
        super(specialized, owner, argumentMap);
        this.fFixedType = fixedType;
        this.fEnumerators = new IEnumerator[specialized.getEnumerators().length];
    }

    private void initialize(IASTNode point) {
        ICPPTemplateParameterMap tpMap = this.getTemplateParameterMap();
        IEnumerator[] enumerators = this.getSpecializedBinding().getEnumerators();
        IType previousInternalType = CPPBasicType.INT;
        int i = 0;
        while (i < enumerators.length) {
            IEnumerator enumerator = enumerators[i];
            InstantiationContext context = new InstantiationContext(tpMap, this, point);
            IValue specializedValue = CPPTemplates.instantiateValue(enumerator.getValue(), context, 25);
            IType internalType = null;
            if (this.fFixedType == null && enumerator instanceof ICPPInternalEnumerator) {
                internalType = ((ICPPInternalEnumerator)enumerator).getInternalType();
                if (internalType != null) {
                    internalType = CPPTemplates.instantiateType(internalType, context);
                } else if (previousInternalType instanceof IBasicType) {
                    internalType = ASTEnumerator.getTypeOfIncrementedValue(previousInternalType, specializedValue);
                }
                if (internalType != null) {
                    previousInternalType = internalType;
                }
            }
            this.fEnumerators[i] = new CPPEnumeratorSpecialization(enumerator, this, tpMap, specializedValue, internalType);
            ++i;
        }
        this.fInitializationComplete = true;
    }

    public boolean isInitializing() {
        return !this.fInitializationComplete;
    }

    @Override
    public ICPPEnumeration getSpecializedBinding() {
        return (ICPPEnumeration)super.getSpecializedBinding();
    }

    @Override
    public IEnumerator[] getEnumerators() {
        return this.fEnumerators;
    }

    @Override
    public long getMinValue() {
        return SemanticUtil.computeMinValue(this);
    }

    @Override
    public long getMaxValue() {
        return SemanticUtil.computeMaxValue(this);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPEnumerationSpecialization)) {
            return false;
        }
        ICPPEnumerationSpecialization otherEnumSpec = (ICPPEnumerationSpecialization)type;
        return this.getSpecializedBinding().isSameType(otherEnumSpec.getSpecializedBinding()) && ((IType)((Object)this.getOwner())).isSameType((IType)((Object)otherEnumSpec.getOwner()));
    }

    @Override
    public boolean isScoped() {
        return this.getSpecializedBinding().isScoped();
    }

    @Override
    public IType getFixedType() {
        return this.fFixedType;
    }

    @Override
    public ICPPScope asScope() {
        return this.getSpecializedBinding().asScope();
    }

    @Override
    public Object clone() {
        throw new IllegalArgumentException("Enums must not be cloned");
    }

    @Override
    public IEnumerator specializeEnumerator(IEnumerator enumerator) {
        if (enumerator instanceof ICPPSpecialization && ((ICPPSpecialization)((Object)enumerator)).getOwner() == this) {
            return enumerator;
        }
        IEnumerator[] unspecializedEnumerators = this.getSpecializedBinding().getEnumerators();
        int i = 0;
        while (i < this.fEnumerators.length) {
            if (enumerator.equals(unspecializedEnumerators[i])) {
                IEnumerator specializedEnumerator = this.fEnumerators[i];
                return specializedEnumerator == null ? enumerator : specializedEnumerator;
            }
            ++i;
        }
        return enumerator;
    }
}

