/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.wizards.project;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.ui.wizards.ICDTCommonProjectWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.core.application.tproject.TprojectHandler;
import org.tizen.nativeappcommon.wizards.Messages;

public class TizenNativeCDTWizardOperation
extends BasicNewResourceWizard
implements ICDTCommonProjectWizard {
    private final Logger logger = LoggerFactory.getLogger(TizenNativeCDTWizardOperation.class);
    private IProject newProject = null;
    private IProgressMonitor continueCreationMonitor;

    public TizenNativeCDTWizardOperation(IProject project) {
        this(Messages.WIZARD_NATIVE_TITLE, Messages.WIZARD_NATIVE_DESC, project);
    }

    public TizenNativeCDTWizardOperation(String title, String desc, IProject project) {
        this.newProject = project;
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
    }

    public IProject createIProject(String arg0, URI arg1) throws CoreException {
        return null;
    }

    public IProject createIProject(String name, URI location, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating .project file", 100);
        if (this.newProject != null) {
            return this.newProject;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocationURI(location);
            }
            this.newProject = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            this.newProject = newProjectHandle;
        }
        if (!this.newProject.isOpen()) {
            this.newProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 25));
        }
        this.continueCreationMonitor = new SubProgressMonitor(monitor, 25);
        IProject proj = this.continueCreation(this.newProject);
        monitor.done();
        return proj;
    }

    protected IProject continueCreation(IProject prj) {
        if (this.continueCreationMonitor == null) {
            this.continueCreationMonitor = new NullProgressMonitor();
        }
        try {
            try {
                this.continueCreationMonitor.beginTask(Messages.TizenProjectWizard_2, 1);
                CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
                CCProjectNature.addCCNature((IProject)prj, (IProgressMonitor)new SubProgressMonitor(this.continueCreationMonitor, 1));
            }
            catch (CoreException e) {
                this.logger.error("Failed to add natures", (Throwable)e);
                this.continueCreationMonitor.done();
            }
        }
        finally {
            this.continueCreationMonitor.done();
        }
        return prj;
    }

    public String[] getContentTypeIDs() {
        return new String[]{"org.eclipse.cdt.core.cxxSource", "org.eclipse.cdt.core.cxxHeader"};
    }

    public String[] getExtensions() {
        String[] contentTypeIds = this.getContentTypeIDs();
        if (contentTypeIds.length > 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<String> extensions = new ArrayList<String>();
            int i = 0;
            while (i < contentTypeIds.length) {
                IContentType contentType = manager.getContentType(contentTypeIds[i]);
                if (contentType != null) {
                    String[] thisTypeExtensions = contentType.getFileSpecs(8);
                    extensions.addAll(Arrays.asList(thisTypeExtensions));
                }
                ++i;
            }
            return extensions.toArray(new String[extensions.size()]);
        }
        return new String[0];
    }

    public String[] getLanguageIDs() {
        String[] contentTypeIds = this.getContentTypeIDs();
        if (contentTypeIds.length > 0) {
            IContentTypeManager manager = Platform.getContentTypeManager();
            ArrayList<String> languageIDs = new ArrayList<String>();
            int i = 0;
            while (i < contentTypeIds.length) {
                ILanguage language;
                IContentType contentType = manager.getContentType(contentTypeIds[i]);
                if (contentType != null && (language = LanguageManager.getInstance().getLanguage(contentType)) != null && !languageIDs.contains(language.getId())) {
                    languageIDs.add(language.getId());
                }
                ++i;
            }
            return languageIDs.toArray(new String[languageIDs.size()]);
        }
        return new String[0];
    }

    public IProject getLastProject() {
        return null;
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature"};
    }

    public IProject getProject(boolean arg0) {
        return null;
    }

    public IProject getProject(boolean arg0, boolean arg1) {
        return null;
    }

    public void setInitializationData(IConfigurationElement arg0, String arg1, Object arg2) throws CoreException {
    }

    public boolean performFinish() {
        return false;
    }

    protected boolean setCreated() throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(this.newProject, false);
        if (des == null) {
            return false;
        }
        if (des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(this.newProject, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(this.newProject, des, false, null);
            return true;
        }
        return false;
    }

    public void createTProject(IProject project, ProfileInfo profileInfo) {
        TprojectHandler handler = new TprojectHandler(project);
        TizenProjectDescription desc = new TizenProjectDescription(project);
        desc.setPlatform(profileInfo);
        desc.setUsePrebuiltIndexer(Boolean.valueOf(true));
        handler.marshal(desc);
    }
}

