/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli.model;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.tizen.nativecore.cli.model.AppendixFile;

public class AppendixFileWriter {
    private static final String DEF_PREBUILD_STEP = "PREBUILD_COMMAND";
    private static final String DEF_POSTBUILD_STEP = "POSTBUILD_COMMAND";
    private static final String DEF_PREBUILD_STEP_DESC = "PREBUILD_DESC";
    private static final String DEF_POSTBUILD_STEP_DESC = "POSTBUILD_DESC";
    private AppendixFile appendix;

    public AppendixFileWriter(AppendixFile appendix) {
        this.appendix = appendix;
    }

    public void write(String filePath) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
        try {
            out.newLine();
            out.write("# Add pre/post build process");
            out.newLine();
            out.write(this.makeStatement(DEF_PREBUILD_STEP_DESC, this.appendix.getPreBuildStepDesc()));
            out.newLine();
            out.write(this.makeStatement(DEF_PREBUILD_STEP, this.appendix.getPreBuildStep()));
            out.newLine();
            out.write(this.makeStatement(DEF_POSTBUILD_STEP_DESC, this.appendix.getPostBuildStepDesc()));
            out.newLine();
            out.write(this.makeStatement(DEF_POSTBUILD_STEP, this.appendix.getPostBuildStep()));
            out.newLine();
        }
        finally {
            out.close();
        }
    }

    private String makeStatement(String key, String value) {
        return String.valueOf(key) + " = " + value;
    }
}

