/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPTwoPhaseBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPParameter
extends PlatformObject
implements ICPPParameter,
ICPPInternalBinding,
ICPPTwoPhaseBinding {
    private IType fType;
    private IASTName[] fDeclarations;
    private int fPosition;

    public CPPParameter(IASTName name, int pos) {
        this.fDeclarations = new IASTName[]{name};
        this.fPosition = pos;
    }

    public CPPParameter(IType type, int pos) {
        this.fType = type;
        this.fPosition = pos;
    }

    @Override
    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.fDeclarations;
    }

    @Override
    public IASTNode getDefinition() {
        return null;
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        this.fDeclarations = this.fDeclarations == null || this.fDeclarations.length == 0 ? new IASTName[]{name} : (this.isDeclaredBefore((ASTNode)node, (ASTNode)((Object)this.fDeclarations[0])) ? ArrayUtil.prepend(IASTName.class, this.fDeclarations, name) : ArrayUtil.append(IASTName.class, this.fDeclarations, name));
    }

    private boolean isDeclaredBefore(ASTNode n1, ASTNode n2) {
        if (n1.getLength() == 0) {
            return false;
        }
        if (n2.getLength() == 0) {
            return true;
        }
        return n1.getOffset() < n2.getOffset();
    }

    private IASTName getPrimaryDeclaration() {
        if (this.fDeclarations != null) {
            int i = 0;
            while (i < this.fDeclarations.length && this.fDeclarations[i] != null) {
                IASTNode node = this.fDeclarations[i].getParent();
                while (!(node instanceof IASTDeclaration)) {
                    node = node.getParent();
                }
                if (node instanceof IASTFunctionDefinition) {
                    return this.fDeclarations[i];
                }
                ++i;
            }
            return this.fDeclarations[0];
        }
        return null;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        IASTName name = this.getPrimaryDeclaration();
        if (name != null) {
            return name.getSimpleID();
        }
        return CharArrayUtils.EMPTY;
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getPrimaryDeclaration());
    }

    public IASTNode getPhysicalNode() {
        if (this.fDeclarations != null) {
            return this.fDeclarations[0];
        }
        return null;
    }

    @Override
    public IType getType() {
        if (this.fType == null && this.fDeclarations != null) {
            IASTNode parent = this.fDeclarations[0].getParent();
            while (parent != null) {
                if (parent instanceof ICPPASTParameterDeclaration) {
                    this.fType = CPPVisitor.createType((ICPPASTParameterDeclaration)parent, false);
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.fType;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return new char[][]{this.getNameCharArray()};
    }

    @Override
    public boolean isGloballyQualified() {
        return false;
    }

    @Override
    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return false;
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    public boolean hasStorageClass(int storage) {
        IASTNode[] ns = this.getDeclarations();
        if (ns == null) {
            return false;
        }
        int i = 0;
        while (i < ns.length && ns[i] != null) {
            IASTDeclSpecifier declSpec;
            IASTNode parent = ns[i].getParent();
            while (parent != null && !(parent instanceof IASTParameterDeclaration)) {
                parent = parent.getParent();
            }
            if (parent != null && (declSpec = ((IASTParameterDeclaration)parent).getDeclSpecifier()).getStorageClass() == storage) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IASTInitializer getInitializer() {
        if (this.fDeclarations == null) {
            return null;
        }
        int i = 0;
        while (i < this.fDeclarations.length && this.fDeclarations[i] != null) {
            IASTNode parent = this.fDeclarations[i].getParent();
            while (parent.getPropertyInParent() == IASTDeclarator.NESTED_DECLARATOR) {
                parent = parent.getParent();
            }
            IASTInitializer init = ((IASTDeclarator)parent).getInitializer();
            if (init != null) {
                return init;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.getInitializer() != null;
    }

    @Override
    public IValue getDefaultValue() {
        IASTInitializer init = this.getInitializer();
        if (init != null) {
            return SemanticUtil.getValueOfInitializer(init, this.getType());
        }
        return null;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    public String toString() {
        String name = this.getName();
        return name.length() != 0 ? name : "<unnamed>";
    }

    @Override
    public IBinding getOwner() {
        IASTFunctionDeclarator decl = ASTQueries.findAncestorWithType(this.fDeclarations[0], IASTFunctionDeclarator.class);
        if (decl == null) {
            return null;
        }
        IASTName name = decl.getName();
        return name != null ? name.resolveBinding() : null;
    }

    @Override
    public IValue getInitialValue() {
        return null;
    }

    @Override
    public IBinding resolveFinalBinding(CPPASTNameBase name) {
        IASTName funcName;
        IBinding b;
        IBinding current = name.getPreBinding();
        if (current != this) {
            return current;
        }
        IASTNode node = this.getPrimaryDeclaration();
        while (node != null && !(node instanceof IASTFunctionDeclarator)) {
            node = node.getParent();
        }
        if (node instanceof IASTFunctionDeclarator && (b = (funcName = ASTQueries.findInnermostDeclarator((IASTFunctionDeclarator)node).getName()).resolvePreBinding()) instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)b).resolveParameter(this);
        }
        return this;
    }

    public int getParameterPosition() {
        return this.fPosition;
    }

    public static class CPPParameterProblem
    extends ProblemBinding
    implements ICPPParameter {
        public CPPParameterProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }
    }
}

