/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.tizen.nativecommon.Activator;
import org.tizen.nativecommon.apihover.BrowserInformationControl;

public class InformationControlCreator
extends AbstractReusableInformationControlCreator {
    private BrowserInformationControl browserInformationControl;
    private static final int BROWSER_WIDTH = 550;
    private static final int BROWSER_HEIGHT = 320;

    protected IInformationControl doCreateInformationControl(Shell parent) {
        if (BrowserInformationControl.isAvailable((Composite)parent)) {
            ToolBarManager toolBarmanager = new ToolBarManager(0x800000);
            this.browserInformationControl = new BrowserInformationControl(parent, toolBarmanager){

                public Point computeSizeHint() {
                    return new Point(550, 320);
                }

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return new InformationControlCreator();
                }
            };
            final GoExternalBrowserAction goExternalAction = new GoExternalBrowserAction(this.browserInformationControl);
            toolBarmanager.add((IAction)goExternalAction);
            final GoHomeAction goHomeAction = new GoHomeAction(this.browserInformationControl);
            toolBarmanager.add((IAction)goHomeAction);
            final GoBackAction goBackAction = new GoBackAction(this.browserInformationControl);
            toolBarmanager.add((IAction)goBackAction);
            final GoForwardAction goForwardAction = new GoForwardAction(this.browserInformationControl);
            toolBarmanager.add((IAction)goForwardAction);
            toolBarmanager.update(true);
            LocationListener locationListener = new LocationListener(){

                public void changed(LocationEvent event) {
                    goBackAction.setEnabled(InformationControlCreator.this.browserInformationControl.isBackEnabled());
                    goForwardAction.setEnabled(InformationControlCreator.this.browserInformationControl.isForwardEnabled());
                    goExternalAction.setEnabled(InformationControlCreator.this.browserInformationControl.isOpenbrowserEnabled());
                    goHomeAction.setEnabled(InformationControlCreator.this.browserInformationControl.isGohomeEnabled());
                }

                public void changing(LocationEvent event) {
                }
            };
            this.browserInformationControl.addLocationListener(locationListener);
            FocusListener focusListener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    InformationControlCreator.this.browserInformationControl.dispose();
                }

                public void focusGained(FocusEvent e) {
                    InformationControlCreator.this.browserInformationControl.setFocus();
                }
            };
            this.browserInformationControl.addFocusListener(focusListener);
            return this.browserInformationControl;
        }
        return new DefaultInformationControl(parent, true);
    }

    public boolean canReuse(IInformationControl control) {
        return false;
    }

    public boolean canReplace(IInformationControlCreator creator) {
        return super.canReplace(creator);
    }

    private static final class GoBackAction
    extends Action {
        private final BrowserInformationControl finalBrowserInformationControl;

        public GoBackAction(BrowserInformationControl infoControl) {
            this.finalBrowserInformationControl = infoControl;
            this.setText("Back");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        }

        public void run() {
            this.finalBrowserInformationControl.back();
        }
    }

    private static final class GoExternalBrowserAction
    extends Action {
        private final BrowserInformationControl finalBrowserInformationControl;

        public GoExternalBrowserAction(BrowserInformationControl infoControl) {
            this.finalBrowserInformationControl = infoControl;
            this.setText("Open External Browser");
            this.setImageDescriptor(Activator.getImageDescriptorFromPlugin("icons/obj16/external_browser.gif"));
        }

        public void run() {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                String url = this.finalBrowserInformationControl.getURL();
                if (url == null) {
                    return;
                }
                String[] urls = url.split("#");
                if (urls.length != 2) {
                    browserSupport.getExternalBrowser().openURL(new URL(urls[0]));
                } else {
                    browserSupport.getExternalBrowser().openURL(new URL(urls[0]));
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class GoForwardAction
    extends Action {
        private final BrowserInformationControl finalBrowserInformationControl;

        public GoForwardAction(BrowserInformationControl infoControl) {
            this.finalBrowserInformationControl = infoControl;
            this.setText("Forward");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
        }

        public void run() {
            this.finalBrowserInformationControl.forward();
        }
    }

    private static final class GoHomeAction
    extends Action {
        private final BrowserInformationControl finalBrowserInformationControl;

        public GoHomeAction(BrowserInformationControl infoControl) {
            this.finalBrowserInformationControl = infoControl;
            this.setText("Home");
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_ETOOL_HOME_NAV"));
        }

        public void run() {
            this.finalBrowserInformationControl.goToHome();
        }
    }
}

