/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui;

import java.io.File;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.util.ImageUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;

public class TizenRemoteTab
extends CLaunchConfigurationTab {
    private final Logger logger = LoggerFactory.getLogger(TizenRemoteTab.class);
    public static final String ID = "org.tizen.nativecommon.launch.ui.TizenRemoteTab";
    private Text hostText = null;
    private Text portText = null;
    private Button verboseButton = null;

    public String getId() {
        return ID;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createRemoteOptionGroup(comp, 1);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.tizen.nativecommon.ATTR_LAUNCH_VERBOSE_CONSOLE", true);
        ICElement cElement = this.getContext((ILaunchConfiguration)configuration, this.getPlatform((ILaunchConfiguration)configuration));
        if (cElement != null) {
            ICProject cProject = cElement.getCProject();
            IProject project = cProject.getProject();
            String appId = ProjectUtil.getAppId(project);
            String activeConfigName = ProjectUtil.getDefaultConfiguration(project).getName();
            String programName = String.valueOf(activeConfigName) + File.separatorChar + ProjectUtil.getBinaryName(project);
            IDevice device = LaunchUtils.getCurrentDeployDevice();
            String name = NLS.bind((String)LaunchMessages.CMainTab_Configuration_name, (Object)project.getName(), (Object)activeConfigName);
            name = this.getLaunchConfigurationDialog().generateName(name);
            this.initializeCProject(cElement, configuration);
            configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            configuration.setAttribute("org.tizen.nativecommon.launch.app.id", appId);
            LaunchUtils.setDeviceToLaunchConfiguration(configuration, device);
            configuration.rename(name);
        } else {
            this.logger.error("Failed to get cElement from " + configuration);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (LaunchUtils.isVerboseMode(configuration)) {
            this.verboseButton.setSelection(true);
        }
        try {
            this.hostText.setText(configuration.getAttribute("org.tizen.common.launch.device.id", ""));
        }
        catch (CoreException coreException) {
            this.logger.error("Failed to set host text");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.tizen.nativecommon.ATTR_LAUNCH_VERBOSE_CONSOLE", this.verboseButton.getSelection());
    }

    public String getName() {
        return TizenLaunchMessages.TizenRemoteTab_Tab_Title;
    }

    public Image getImage() {
        return ImageUtil.getImage((Plugin)ConnectionPlugin.getDefault(), (String)"icons/connection/obj16/connection_explorer.png");
    }

    protected void createRemoteOptionGroup(Composite parent, int colSpan) {
        Group remoteGroup = new Group(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = colSpan;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        remoteGroup.setLayoutData((Object)gridData);
        remoteGroup.setLayout((Layout)gridLayout);
        remoteGroup.setText(TizenLaunchMessages.TizenRemoteTab_Group_Title);
        Label hostLabel = new Label((Composite)remoteGroup, 0);
        hostLabel.setText(TizenLaunchMessages.TizenRemoteTab_Connect_Host);
        this.hostText = new Text((Composite)remoteGroup, 2052);
        GridData gd = new GridData(768);
        this.hostText.setLayoutData((Object)gd);
        this.hostText.setEditable(false);
        Label portLabel = new Label((Composite)remoteGroup, 0);
        portLabel.setText(TizenLaunchMessages.TizenRemoteTab_Connect_Port);
        this.portText = new Text((Composite)remoteGroup, 2052);
        gd = new GridData(768);
        this.portText.setLayoutData((Object)gd);
        this.portText.setEnabled(false);
        this.verboseButton = this.createCheckButton((Composite)remoteGroup, TizenLaunchMessages.TizenRemoteTab_Print_Verbosemode);
        this.verboseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TizenRemoteTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }
}

