/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sdb.command.ApplicationCommand;
import org.tizen.common.sdb.command.LaunchCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.command.NativeLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.ApplicationCmdService;
import org.tizen.sdblib.util.ApplicationUtil;

public class NativeDebugCommand
extends NativeLaunchCommand {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean isAttach = false;

    public NativeDebugCommand(IDevice device, ILaunchConfiguration config, boolean isGcov, boolean isTest, String args, boolean isAttach, ITizenConsoleManager console) {
        super(device, config, isGcov, isTest, args, console);
        this.isAttach = isAttach;
    }

    protected List<String> getDebugCommand() throws CoreException {
        String gdbserverPort = LaunchUtils.getGdbserverPort(this.config);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getSdbPath());
        command.add("-s");
        command.add(this.getDevice().getSerialNumber());
        command.add("launch");
        command.add("-a");
        command.addAll(this.splitParams(this.getAppId()));
        command.add("-p");
        command.add("-e");
        command.add("-m");
        command.add("debug");
        command.add("-P");
        command.add(gdbserverPort);
        command.addAll(this.splitParams(this.getArgs()));
        return command;
    }

    public void execute() throws Exception {
        this.runWidgetViewer();
        this.executeCommand();
    }

    @Override
    protected void executeCommand() throws Exception {
        int pId = this.getPid();
        if (ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            ApplicationCmdService appcmd = this.getApplicationCmdService();
            String gdbserverPort = LaunchUtils.getGdbserverPort(this.config);
            int n = pId = this.isAttach ? pId : -1;
            if (pId < 0) {
                this.newCoreException("Application is not running on the device:" + this.getAppId(), null);
            }
            String gdbServerPath = String.valueOf(this.device.getAppInstallPath()) + "/gdbserver/gdbserver";
            if (!appcmd.debugNativeApplication(Integer.parseInt(gdbserverPort), this.getAppId(), pId, gdbServerPath)) {
                this.newCoreException("Debug command failed: " + this.getAppId(), null);
            }
        } else if (pId >= 0) {
            this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), null);
            List<String> command = this.getDebugCommand();
            this.helper.runHostCommand(command, false);
            Thread.sleep(500L);
        } else {
            this.newCoreException("Application is not running on the device", null);
        }
    }

    private void runWidgetViewer() throws Exception {
        if (this.isWidgetViewer() && !this.isAttach) {
            LaunchCommand command = new LaunchCommand(this.getDevice(), "org.tizen.widget_viewer_sdk", null, null);
            command.setConsole(this.getConsole());
            command.execute();
        }
    }

    @Override
    protected String getAppId() throws CoreException {
        IProject project = ProjectUtil.getProject(this.config);
        String appId = ProjectUtil.getAppId(project);
        this.widgetId = this.isWidgetViewer() && !this.isAttach ? "org.tizen.widget_viewer_sdk widget_id " + appId : appId;
        String format = this.WIDGET_ID_FORMAT_OTHERS;
        if (OSChecker.isWindows() && !ApplicationCommand.isAppCmdSupported((IDevice)this.getDevice())) {
            format = this.WIDGET_ID_FORMAT_WIN;
        }
        return String.format(format, this.widgetId);
    }

    @Override
    protected String getArgs() {
        if (this.isAttach) {
            this.args = "-attach " + this.getPid();
            return this.args;
        }
        return super.getArgs();
    }

    private int getPid() {
        int pid = -1;
        IPath exePath = null;
        try {
            exePath = CDebugUtils.verifyProgramPath((ILaunchConfiguration)this.config);
        }
        catch (CoreException coreException) {
            this.logger.error("cannot get exePath");
            return -1;
        }
        if (exePath != null) {
            String name = exePath.toFile().getName();
            try {
                IProject project = ProjectUtil.getProject(this.config);
                String appId = ProjectUtil.getAppId(project);
                pid = ApplicationUtil.getPid((IDevice)this.device, (String)appId, (String)name);
            }
            catch (Exception e) {
                this.logger.error("cannot get pid", (Throwable)e);
                return -1;
            }
        }
        return pid;
    }
}

