/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameterScope;

public class CPPASTTemplatedTypeTemplateParameter
extends ASTNode
implements ICPPASTTemplatedTypeTemplateParameter,
IASTAmbiguityParent {
    private ICPPASTTemplateParameter[] fNestedParameters = null;
    private boolean fIsParameterPack;
    private IASTName fName;
    private IASTExpression fDefaultValue;
    private CPPTemplateTemplateParameterScope fScope;

    public CPPASTTemplatedTypeTemplateParameter() {
    }

    public CPPASTTemplatedTypeTemplateParameter(IASTName name, IASTExpression defaultValue) {
        this.setName(name);
        this.setDefaultValue(defaultValue);
    }

    @Override
    public CPPASTTemplatedTypeTemplateParameter copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTemplatedTypeTemplateParameter copy(IASTNode.CopyStyle style) {
        CPPASTTemplatedTypeTemplateParameter copy = new CPPASTTemplatedTypeTemplateParameter();
        copy.setName(this.fName == null ? null : this.fName.copy(style));
        copy.setDefaultValue(this.fDefaultValue == null ? null : this.fDefaultValue.copy(style));
        copy.fIsParameterPack = this.fIsParameterPack;
        ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = this.getTemplateParameters();
        int n = iCPPASTTemplateParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
            copy.addTemplateParameter(param == null ? null : param.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public ICPPASTTemplateParameter[] getTemplateParameters() {
        if (this.fNestedParameters == null) {
            return ICPPASTTemplateParameter.EMPTY_TEMPLATEPARAMETER_ARRAY;
        }
        this.fNestedParameters = ArrayUtil.trim(ICPPASTTemplateParameter.class, this.fNestedParameters);
        return this.fNestedParameters;
    }

    @Override
    @Deprecated
    public void addTemplateParamter(ICPPASTTemplateParameter param) {
        this.addTemplateParameter(param);
    }

    @Override
    public void addTemplateParameter(ICPPASTTemplateParameter param) {
        this.assertNotFrozen();
        if (param != null) {
            this.fNestedParameters = ArrayUtil.append(ICPPASTTemplateParameter.class, this.fNestedParameters, param);
            param.setParent(this);
            param.setPropertyInParent(PARAMETER);
        }
    }

    @Override
    public void setIsParameterPack(boolean val) {
        this.assertNotFrozen();
        this.fIsParameterPack = val;
    }

    @Override
    public boolean isParameterPack() {
        return this.fIsParameterPack;
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(PARAMETER_NAME);
        }
    }

    @Override
    public IASTExpression getDefaultValue() {
        return this.fDefaultValue;
    }

    @Override
    public void setDefaultValue(IASTExpression expression) {
        this.assertNotFrozen();
        this.fDefaultValue = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(DEFAULT_VALUE);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTemplateParameters) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        ICPPASTTemplateParameter[] ps = this.getTemplateParameters();
        int i = 0;
        while (i < ps.length) {
            if (!ps[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (this.fDefaultValue != null && !this.fDefaultValue.accept(action)) {
            return false;
        }
        return !action.shouldVisitTemplateParameters || action.leave(this) != 2;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.fName) {
            return 0;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.fDefaultValue) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.fDefaultValue = (IASTExpression)other;
        }
    }

    @Override
    public ICPPScope asScope() {
        if (this.fScope == null) {
            this.fScope = new CPPTemplateTemplateParameterScope(this);
        }
        return this.fScope;
    }
}

