/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.CodanSettings;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativecommon.fastdeploy.NativeFastDeployListener;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.tizen.nativecommon";
    private static Activator plugin;
    public static final String TIDL_STUB_PREFERENCE = "org.tizen.nativecommon.tidl.stub";
    public static final String TIDL_PROXY_PREFERENCE = "org.tizen.nativecommon.tidl.proxy";
    public static final String TIDL_OUTPUT_PATH_PREFERENCE = "org.tizen.nativecommon.tidl.output";
    public static final String TIDL_LANGUAGE_PREFERENCE = "org.tizen.nativecommon.tidl.language";
    public static final String DEFAULT_OUTPUT_PATH = "tidlCode";
    public static final String DEFAULT_LANGUAGE = "C";
    public static final Boolean DEFAULT_STUB_CHOICE;
    public static final Boolean DEFAULT_PROXY_CHOICE;

    static {
        DEFAULT_STUB_CHOICE = true;
        DEFAULT_PROXY_CHOICE = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            CodanSettings.disableCodeAnalysisProblems(CodanSettings.getCodanProblemIds("org.eclipse.cdt.codan.core.categories.CompilerErrors"));
        }
        catch (Throwable t) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Failed to initialize Codan", t));
        }
        ProjectUtil.enableAutoBuild(false);
        if (!SBIModel.isInitialized()) {
            Job initJob = new Job("Initializing SBI"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Initializing SBI...", 100);
                    SBIModel.initialize(monitor, InstallPathConfig.getSDKPath());
                    return Status.OK_STATUS;
                }
            };
            initJob.schedule();
        }
        this.initFastDeploy();
        this.initializeDefaultPreferences(Activator.getDefault().getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    private void initFastDeploy() {
        NativeFastDeployListener fastDeployListener = new NativeFastDeployListener();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)fastDeployListener, 16);
    }

    public void initializeDefaultPreferences(IPreferenceStore store) {
        String languagePreference = this.getDefaultLanguagePreference();
        if (StringUtil.isEmpty((CharSequence)languagePreference)) {
            store.setDefault(TIDL_STUB_PREFERENCE, DEFAULT_STUB_CHOICE.booleanValue());
            store.setDefault(TIDL_PROXY_PREFERENCE, DEFAULT_PROXY_CHOICE.booleanValue());
            store.setDefault(TIDL_OUTPUT_PATH_PREFERENCE, DEFAULT_OUTPUT_PATH);
            store.setDefault(TIDL_LANGUAGE_PREFERENCE, DEFAULT_LANGUAGE);
        }
    }

    public String getDefaultLanguagePreference() {
        return this.getPreferenceStore().getDefaultString(TIDL_LANGUAGE_PREFERENCE);
    }

    public Boolean getDefaultStubPreference() {
        return this.getPreferenceStore().getDefaultBoolean(TIDL_STUB_PREFERENCE);
    }

    public Boolean getDefaultProxyPreference() {
        return this.getPreferenceStore().getDefaultBoolean(TIDL_PROXY_PREFERENCE);
    }

    public String getDefaultOutputPathPreference() {
        return this.getPreferenceStore().getDefaultString(TIDL_OUTPUT_PATH_PREFERENCE);
    }

    public String getLanguagePreference() {
        return this.getPreferenceStore().getString(TIDL_LANGUAGE_PREFERENCE);
    }

    public Boolean getStubPreference() {
        return this.getPreferenceStore().getBoolean(TIDL_STUB_PREFERENCE);
    }

    public Boolean getProxyPreference() {
        return this.getPreferenceStore().getBoolean(TIDL_PROXY_PREFERENCE);
    }

    public String getOutputPathPreference() {
        return this.getPreferenceStore().getString(TIDL_OUTPUT_PATH_PREFERENCE);
    }

    public void setTIDLPreferences(String language, String outputPath, Boolean stub, Boolean proxy) {
        this.getPreferenceStore().setValue(TIDL_LANGUAGE_PREFERENCE, language);
        this.getPreferenceStore().setValue(TIDL_STUB_PREFERENCE, stub.booleanValue());
        this.getPreferenceStore().setValue(TIDL_PROXY_PREFERENCE, proxy.booleanValue());
        this.getPreferenceStore().setValue(TIDL_OUTPUT_PATH_PREFERENCE, outputPath);
    }
}

