/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameterOwner;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMTemplateParameterArray;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPTemplateTemplateParameter
extends PDOMCPPBinding
implements ICPPTemplateTemplateParameter,
ICPPUnknownBinding,
ICPPUnknownType,
IIndexType,
IPDOMCPPTemplateParameter,
IPDOMCPPTemplateParameterOwner {
    private static final int PACK_BIT = Integer.MIN_VALUE;
    private static final int DEFAULT_TYPE = 32;
    private static final int MEMBERLIST = 38;
    private static final int PARAMETERID = 42;
    private static final int PARAMETERS = 46;
    protected static final int RECORD_SIZE = 50;
    private PDOMCPPUnknownScope fUnknownScope;
    private int fCachedParamID = -1;
    private volatile IPDOMCPPTemplateParameter[] params;

    public PDOMCPPTemplateTemplateParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateTemplateParameter param) throws CoreException, DOMException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        int id = param.getParameterID();
        if (param.isParameterPack()) {
            id |= Integer.MIN_VALUE;
        }
        db.putInt(this.record + 42L, id);
        ICPPTemplateParameter[] origParams = param.getTemplateParameters();
        IPDOMCPPTemplateParameter[] params = PDOMTemplateParameterArray.createPDOMTemplateParameters(linkage, this, origParams);
        long rec = PDOMTemplateParameterArray.putArray(db, params);
        this.getDB().putRecPtr(this.record + 46L, rec);
    }

    public PDOMCPPTemplateTemplateParameter(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 50;
    }

    @Override
    public int getNodeType() {
        return 51;
    }

    @Override
    public short getParameterPosition() {
        return (short)this.getParameterID();
    }

    @Override
    public short getTemplateNestingLevel() {
        this.readParamID();
        return (short)(this.getParameterID() >> 16);
    }

    @Override
    public boolean isParameterPack() {
        this.readParamID();
        return (this.fCachedParamID & Integer.MIN_VALUE) != 0;
    }

    @Override
    public int getParameterID() {
        this.readParamID();
        return this.fCachedParamID & Integer.MAX_VALUE;
    }

    private void readParamID() {
        if (this.fCachedParamID == -1) {
            try {
                Database db = this.getDB();
                this.fCachedParamID = db.getInt(this.record + 42L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fCachedParamID = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public void addChild(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 38L);
        list.addMember(member);
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 38L);
        list.accept(visitor);
    }

    @Override
    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTemplateParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    @Override
    public IType getDefault() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 32L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public ICPPTemplateArgument getDefaultValue() {
        IType d = this.getDefault();
        if (d == null) {
            return null;
        }
        return new CPPTemplateTypeArgument(d);
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPScope asScope() {
        if (this.fUnknownScope == null) {
            this.fUnknownScope = new PDOMCPPUnknownScope(this, (IASTName)new CPPASTName(this.getNameCharArray()));
        }
        return this.fUnknownScope;
    }

    @Override
    public void configure(ICPPTemplateParameter param) {
        try {
            IType dflt;
            ICPPTemplateArgument val = param.getDefaultValue();
            if (val != null && (dflt = val.getTypeValue()) != null) {
                ((PDOMLinkage)this.getLinkage()).storeType(this.record + 32L, dflt);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding, IASTNode point) throws CoreException {
        if (newBinding instanceof ICPPTemplateTemplateParameter) {
            Database db = this.getDB();
            ICPPTemplateTemplateParameter ttp = (ICPPTemplateTemplateParameter)newBinding;
            this.updateName(newBinding.getNameCharArray());
            IType newDefault = null;
            try {
                newDefault = ttp.getDefault();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
            if (newDefault != null) {
                linkage.storeType(this.record + 32L, newDefault);
            }
            long oldRec = db.getRecPtr(this.record + 46L);
            IPDOMCPPTemplateParameter[] oldParams = this.getTemplateParameters();
            try {
                this.params = PDOMTemplateParameterArray.createPDOMTemplateParameters((PDOMLinkage)this.getLinkage(), this, ttp.getTemplateParameters());
                long newRec = PDOMTemplateParameterArray.putArray(db, this.params);
                db.putRecPtr(this.record + 46L, newRec);
                if (oldRec != 0L) {
                    db.free(oldRec);
                }
                IPDOMCPPTemplateParameter[] iPDOMCPPTemplateParameterArray = oldParams;
                int n = oldParams.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDOMCPPTemplateParameter opar = iPDOMCPPTemplateParameterArray[n2];
                    opar.forceDelete(linkage);
                    ++n2;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    @Override
    public void forceDelete(PDOMLinkage linkage) throws CoreException {
        this.getDBName().delete();
        linkage.storeType(this.record + 32L, null);
        Database db = this.getDB();
        long oldRec = db.getRecPtr(this.record + 46L);
        IPDOMCPPTemplateParameter[] oldParams = this.getTemplateParameters();
        if (oldRec != 0L) {
            db.free(oldRec);
        }
        IPDOMCPPTemplateParameter[] iPDOMCPPTemplateParameterArray = oldParams;
        int n = oldParams.length;
        int n2 = 0;
        while (n2 < n) {
            IPDOMCPPTemplateParameter opar = iPDOMCPPTemplateParameterArray[n2];
            opar.forceDelete(linkage);
            ++n2;
        }
    }

    public IPDOMCPPTemplateParameter[] getTemplateParameters() {
        if (this.params == null) {
            try {
                long rec = this.getDB().getRecPtr(this.record + 46L);
                this.params = rec == 0L ? IPDOMCPPTemplateParameter.EMPTY_ARRAY : PDOMTemplateParameterArray.getArray(this, rec);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.params = IPDOMCPPTemplateParameter.EMPTY_ARRAY;
            }
        }
        return this.params;
    }

    @Override
    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        return ICPPClassTemplatePartialSpecialization.EMPTY_ARRAY;
    }

    @Override
    public IField findField(String name) {
        return null;
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public IField[] getFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    @Override
    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public ICPPMethod[] getMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public ICPPUsingDeclaration[] getUsingDeclarations() {
        return ICPPUsingDeclaration.EMPTY_USING_DECL_ARRAY;
    }

    @Override
    public IScope getCompositeScope() {
        return this.asScope();
    }

    @Override
    public int getKey() {
        return 0;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @Override
    public ICPPTemplateParameter adaptTemplateParameter(ICPPTemplateParameter param) {
        short pos = param.getParameterPosition();
        IPDOMCPPTemplateParameter[] pars = this.getTemplateParameters();
        if (pars == null || pos >= pars.length) {
            return null;
        }
        IPDOMCPPTemplateParameter result = pars[pos];
        if (param instanceof ICPPTemplateTypeParameter ? result instanceof ICPPTemplateTypeParameter : (param instanceof ICPPTemplateNonTypeParameter ? result instanceof ICPPTemplateNonTypeParameter : param instanceof ICPPTemplateTemplateParameter && result instanceof ICPPTemplateTemplateParameter)) {
            return result;
        }
        return null;
    }

    @Override
    public ICPPDeferredClassInstance asDeferredInstance() {
        return null;
    }

    @Override
    public int getVisibility(IBinding member) {
        throw new IllegalArgumentException(String.valueOf(member.getName()) + " is not a member of " + this.getName());
    }
}

