/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.rpklib;

import java.io.OutputStream;
import org.tizen.rpklib.core.RPKSystem;
import org.tizen.rpklib.core.sign.ISigner;
import org.tizen.rpklib.exception.RPKException;
import org.tizen.tpklib.constants.SDKConstants;
import org.tizen.tpklib.lib.ArgumentValidation;
import org.tizen.tpklib.lib.Log;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.lib.file.FileUtil;

public class RPK {
    public static Log log = RPK.createLog();
    public static String INVALID_ARGUMENT_ERROR = "Invalid argument(%s)";
    public static String CANNOT_FIND_BUILD_DIRECTORY = "Cannot find Package directory(%s)";
    public static String CANNOT_FIND_BINARY_FILE = "Cannot find binary file(%s)";
    private OutputStream outStream = null;
    private OutputStream errorStream = null;

    public static Log createLog() {
        String logPath = PathUtil.addPath((String[])new String[]{SDKConstants.getSDKDataPath(), ".rpk", "rpk.log"});
        return Log.createLog((String)logPath);
    }

    public void packaging(String parentPath, String packageDir, String pkgId, String appVersion, boolean isSign, ISigner signer, String profilePath, String profileName) throws RPKException {
        this.packaging(parentPath, packageDir, pkgId, appVersion, isSign, signer, profilePath, profileName, this.outStream, this.errorStream);
    }

    public void packaging(String parentPath, String packageDir, String pkgId, String appVersion, boolean isSign, ISigner signer, String profilePath, String profileName, OutputStream outStream, OutputStream errStream) throws RPKException {
        RPKSystem rSystem = new RPKSystem();
        if (outStream != null) {
            rSystem.setOutputStream(outStream);
        }
        if (errStream != null) {
            rSystem.setErrorStream(errStream);
        }
        rSystem.install(parentPath, packageDir);
        this.validateMandatoryArgument(packageDir, pkgId, appVersion);
        rSystem.initializeRPK(packageDir);
        rSystem.signing(isSign, profilePath, profileName, signer);
        rSystem.packaging(packageDir, pkgId, appVersion);
        rSystem.cleanTemporaryRPKFiles(packageDir);
    }

    private void validateMandatoryArgument(String packageDir, String pkgId, String appVersion) throws RPKException {
        if (!ArgumentValidation.validateStringArgument((String[])new String[]{packageDir, pkgId, appVersion})) {
            throw new RPKException(String.format(INVALID_ARGUMENT_ERROR, ArgumentValidation.getArguments((String[])new String[]{packageDir, pkgId, appVersion})));
        }
        if (!FileUtil.existsPath((String)packageDir)) {
            throw new RPKException(String.format(CANNOT_FIND_BUILD_DIRECTORY, packageDir));
        }
    }

    public void setOutputStream(OutputStream stream) {
        this.outStream = stream;
    }

    public void setErrorStream(OutputStream stream) {
        this.errorStream = stream;
    }

    public static RPK getInstance() {
        return new RPK();
    }
}

