/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTNodeFactoryFactory;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.rewrite.DeclarationGeneratorImpl;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.ui.CUIPlugin;

public class ToggleNodeHelper
extends NodeHelper {
    private static final String EMPTY_STRING = "";
    private static final ICPPNodeFactory factory = ASTNodeFactoryFactory.getDefaultCPPNodeFactory();

    private static void removeParameterInitializations(IASTFunctionDeclarator funcDecl) {
        IASTNode[] iASTNodeArray = funcDecl.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof IASTParameterDeclaration) {
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)child;
                parameter.getDeclarator().setInitializer(null);
            }
            ++n2;
        }
    }

    private static List<ICPPASTConstructorChainInitializer> getInitializerList(IASTFunctionDefinition definition) {
        ArrayList<ICPPASTConstructorChainInitializer> initalizers = new ArrayList<ICPPASTConstructorChainInitializer>();
        IASTNode[] iASTNodeArray = definition.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            if (node instanceof ICPPASTConstructorChainInitializer) {
                initalizers.add(((ICPPASTConstructorChainInitializer)node).copy(IASTNode.CopyStyle.withLocations));
            }
            ++n2;
        }
        return initalizers;
    }

    static IASTSimpleDeclaration createDeclarationFromDefinition(IASTFunctionDefinition oldDefinition) {
        IASTFunctionDeclarator newDeclarator = oldDefinition.getDeclarator().copy(IASTNode.CopyStyle.withLocations);
        IASTDeclSpecifier newDeclSpec = oldDefinition.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        IASTSimpleDeclaration newDeclaration = factory.newSimpleDeclaration(newDeclSpec);
        newDeclaration.addDeclarator((IASTDeclarator)newDeclarator);
        return newDeclaration;
    }

    static ICPPASTFunctionDefinition createFunctionSignatureWithEmptyBody(IASTDeclSpecifier newDeclSpec, IASTFunctionDeclarator newFuncDecl, IASTFunctionDefinition oldDefinition) {
        Object newFunc = null;
        newFuncDecl = ToggleNodeHelper.adjustParamNames(newFuncDecl, oldDefinition);
        newFunc = oldDefinition instanceof ICPPASTFunctionWithTryBlock ? factory.newFunctionTryBlock(newDeclSpec, newFuncDecl, (IASTStatement)factory.newCompoundStatement()) : factory.newFunctionDefinition(newDeclSpec, newFuncDecl, (IASTStatement)factory.newCompoundStatement());
        ToggleNodeHelper.copyInitializerList((ICPPASTFunctionDefinition)newFunc, oldDefinition);
        return newFunc;
    }

    private static IASTFunctionDeclarator adjustParamNames(IASTFunctionDeclarator newFuncDecl, IASTFunctionDefinition oldDefinition) {
        if (oldDefinition.getDeclarator() instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator oldStdDec = (IASTStandardFunctionDeclarator)oldDefinition.getDeclarator();
            IASTParameterDeclaration[] definitionParams = oldStdDec.getParameters();
            IASTParameterDeclaration[] declarationParams = ((IASTStandardFunctionDeclarator)newFuncDecl).getParameters();
            int i = 0;
            while (i < declarationParams.length) {
                declarationParams[i].getDeclarator().setName(definitionParams[i].getDeclarator().getName().copy(IASTNode.CopyStyle.withLocations));
                ++i;
            }
        }
        return newFuncDecl;
    }

    private static void copyInitializerList(ICPPASTFunctionDefinition newFunc, IASTFunctionDefinition oldFunc) {
        for (ICPPASTConstructorChainInitializer initializer : ToggleNodeHelper.getInitializerList(oldFunc)) {
            initializer.setParent((IASTNode)newFunc);
            newFunc.addMemberInitializer(initializer);
        }
    }

    static IASTFunctionDefinition getQualifiedNameDefinition(IASTFunctionDefinition oldDefinition, IASTTranslationUnit definitionUnit, IASTNode nameSpace) {
        ICPPASTDeclSpecifier newDeclSpecifier = ToggleNodeHelper.createDeclSpecifier(oldDefinition);
        IASTFunctionDeclarator newDeclarator = oldDefinition.getDeclarator().copy(IASTNode.CopyStyle.withLocations);
        newDeclarator.setName((IASTName)ToggleNodeHelper.getQualifiedName(oldDefinition.getDeclarator(), nameSpace));
        ToggleNodeHelper.removeParameterInitializations(newDeclarator);
        ICPPASTFunctionDefinition newFunction = ToggleNodeHelper.createFunctionSignatureWithEmptyBody((IASTDeclSpecifier)newDeclSpecifier, newDeclarator, oldDefinition);
        return newFunction;
    }

    private static ICPPASTDeclSpecifier createDeclSpecifier(IASTFunctionDefinition oldDefinition) {
        IASTDeclSpecifier originalDeclSpecifier = oldDefinition.getDeclSpecifier();
        ICPPASTDeclSpecifier newDeclSpecifier = (ICPPASTDeclSpecifier)originalDeclSpecifier.copy(IASTNode.CopyStyle.withLocations);
        if (newDeclSpecifier instanceof ICPPASTNamedTypeSpecifier) {
            ICPPASTNamedTypeSpecifier newNamedTypeSpecifier = (ICPPASTNamedTypeSpecifier)newDeclSpecifier;
            IASTName typename = ((ICPPASTNamedTypeSpecifier)originalDeclSpecifier).getName();
            IBinding typenameBinding = typename.resolveBinding();
            ToggleNodeHelper.adaptTemplateQualifiers(newNamedTypeSpecifier, typenameBinding);
        }
        newDeclSpecifier.setVirtual(false);
        newDeclSpecifier.setInline(true);
        newDeclSpecifier.setStorageClass(0);
        return newDeclSpecifier;
    }

    private static void adaptTemplateQualifiers(ICPPASTNamedTypeSpecifier newDeclSpecifier, IBinding typenameBinding) {
        if (typenameBinding instanceof ICPPBinding) {
            try {
                String[] nameParts = ((ICPPBinding)typenameBinding).getQualifiedName();
                String qualifiedName = typenameBinding.getName();
                String[] nameQualifiers = Arrays.copyOf(nameParts, nameParts.length - 1);
                ICPPASTQualifiedName qualifiedTypeName = factory.newQualifiedName(nameQualifiers, qualifiedName);
                if (typenameBinding instanceof ICPPTemplateInstance) {
                    ICPPTemplateInstance templateInstance = (ICPPTemplateInstance)typenameBinding;
                    ICPPTemplateArgument[] templateArguments = templateInstance.getTemplateArguments();
                    IASTName lastName = qualifiedTypeName.getLastName();
                    ICPPASTTemplateId newTemplateId = ToggleNodeHelper.createTemplateIdForArguments(lastName, templateArguments);
                    qualifiedTypeName.setLastName((ICPPASTName)newTemplateId);
                }
                boolean setTypename = ToggleNodeHelper.adaptQualifiers(typenameBinding, qualifiedTypeName);
                newDeclSpecifier.setName((IASTName)qualifiedTypeName);
                newDeclSpecifier.setIsTypename(setTypename);
            }
            catch (DOMException e) {
                CUIPlugin.log(e);
            }
        }
    }

    private static boolean adaptQualifiers(IBinding typenameBinding, ICPPASTQualifiedName qualifiedTypeName) {
        boolean setTypename = false;
        IBinding owner = typenameBinding.getOwner();
        ICPPASTNameSpecifier[] qualifiers = qualifiedTypeName.getQualifier();
        if (qualifiers.length > 0) {
            int level = qualifiers.length - 1;
            while (owner != null && level >= 0) {
                IASTName qualifierName = (IASTName)qualifiers[level];
                ICPPASTTemplateId newTemplateId = ToggleNodeHelper.createTemplateIdForQualifier(qualifierName, owner);
                if (newTemplateId != null) {
                    qualifiers[level] = newTemplateId;
                    newTemplateId.setParent((IASTNode)qualifiedTypeName);
                    setTypename = true;
                }
                owner = owner.getOwner();
                --level;
            }
        }
        return setTypename;
    }

    private static ICPPASTTemplateId createTemplateIdForQualifier(IASTName qualifierName, IBinding templateBinding) {
        ICPPASTTemplateId newTemplateId = null;
        if (templateBinding instanceof ICPPClassTemplate) {
            ICPPClassTemplate classTemplateBinding = (ICPPClassTemplate)templateBinding;
            newTemplateId = ToggleNodeHelper.createTemplateId(qualifierName, classTemplateBinding);
        } else if (templateBinding instanceof ICPPTemplateInstance) {
            ICPPTemplateInstance instanceBinding = (ICPPTemplateInstance)templateBinding;
            ICPPTemplateArgument[] templateArguments = instanceBinding.getTemplateArguments();
            newTemplateId = ToggleNodeHelper.createTemplateIdForArguments(qualifierName, templateArguments);
        }
        return newTemplateId;
    }

    private static ICPPASTTemplateId createTemplateIdForArguments(IASTName qualifierName, ICPPTemplateArgument[] templateArguments) {
        ICPPASTTemplateId newTemplateId = factory.newTemplateId(qualifierName);
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = templateArguments;
        int n = templateArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument templateArgument = iCPPTemplateArgumentArray[n2];
            IType type = templateArgument.getOriginalTypeValue();
            DeclarationGeneratorImpl declarationGeneratorImpl = new DeclarationGeneratorImpl((INodeFactory)factory);
            IASTDeclarator abstractDeclarator = declarationGeneratorImpl.createDeclaratorFromType(type, EMPTY_STRING.toCharArray());
            IType ultimateType = SemanticUtil.getUltimateType((IType)type, (boolean)false);
            ICPPASTName templateParameterName = factory.newName(ASTTypeUtil.getType((IType)ultimateType, (boolean)false));
            ICPPASTNamedTypeSpecifier typeSpecifier = factory.newNamedTypeSpecifier((IASTName)templateParameterName);
            ICPPASTTypeId newTypeId = factory.newTypeId((IASTDeclSpecifier)typeSpecifier, abstractDeclarator);
            newTemplateId.addTemplateArgument((IASTTypeId)newTypeId);
            ++n2;
        }
        return newTemplateId;
    }

    private static ICPPASTTemplateId createTemplateId(IASTName qualifierName, ICPPClassTemplate ownerBinding) {
        ICPPASTTemplateId newTemplateId = factory.newTemplateId(qualifierName);
        ICPPTemplateParameter[] iCPPTemplateParameterArray = ownerBinding.getTemplateParameters();
        int n = iCPPTemplateParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateParameter templateParameter = iCPPTemplateParameterArray[n2];
            ICPPASTName abstractDeclaratorName = factory.newName();
            ICPPASTDeclarator abstractDeclarator = factory.newDeclarator((IASTName)abstractDeclaratorName);
            ICPPASTName templateParameterName = factory.newName(templateParameter.getNameCharArray());
            ICPPASTNamedTypeSpecifier typeSpecifier = factory.newNamedTypeSpecifier((IASTName)templateParameterName);
            ICPPASTTypeId newTypeId = factory.newTypeId((IASTDeclSpecifier)typeSpecifier, (IASTDeclarator)abstractDeclarator);
            newTemplateId.addTemplateArgument((IASTTypeId)newTypeId);
            ++n2;
        }
        return newTemplateId;
    }

    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTFunctionDefinition oldFunction, IASTFunctionDefinition newFunction) {
        ArrayList<ICPPASTTemplateDeclaration> templateDeclarations = ToggleNodeHelper.getAllTemplateDeclarations((IASTNode)oldFunction);
        return ToggleNodeHelper.addTemplateDeclarationsInOrder(templateDeclarations, newFunction);
    }

    private static ICPPASTTemplateDeclaration addTemplateDeclarationsInOrder(ArrayList<ICPPASTTemplateDeclaration> templDecs, IASTFunctionDefinition newFunction) {
        ICPPASTTemplateDeclaration child = null;
        for (ICPPASTTemplateDeclaration templateDeclaration : templDecs) {
            if (templateDeclaration.getTemplateParameters().length == 0) continue;
            if (child == null) {
                child = templateDeclaration;
                child.setDeclaration((IASTDeclaration)newFunction);
                continue;
            }
            templateDeclaration.setDeclaration((IASTDeclaration)child);
            child.setParent((IASTNode)templateDeclaration);
            child = templateDeclaration;
        }
        return child;
    }

    private static ArrayList<ICPPASTTemplateDeclaration> getAllTemplateDeclarations(IASTNode node) {
        ArrayList<ICPPASTTemplateDeclaration> templdecs = new ArrayList<ICPPASTTemplateDeclaration>();
        while (node.getParent() != null) {
            if (!((node = node.getParent()) instanceof ICPPASTTemplateDeclaration)) continue;
            templdecs.add((ICPPASTTemplateDeclaration)node.copy(IASTNode.CopyStyle.withLocations));
        }
        return templdecs;
    }

    static IASTFunctionDefinition createInClassDefinition(IASTFunctionDeclarator dec, IASTFunctionDefinition def, IASTTranslationUnit insertionAst) {
        IASTFunctionDeclarator declarator = dec.copy(IASTNode.CopyStyle.withLocations);
        IASTDeclSpecifier declSpec = def.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        declSpec.setInline(false);
        if (declSpec instanceof ICPPASTDeclSpecifier && ToggleNodeHelper.isVirtual(dec)) {
            ((ICPPASTDeclSpecifier)declSpec).setVirtual(true);
        }
        declSpec.setStorageClass(ToggleNodeHelper.getStorageClass(dec));
        return ToggleNodeHelper.createFunctionSignatureWithEmptyBody(declSpec, declarator, def);
    }

    static boolean isVirtual(IASTFunctionDeclarator fdec) {
        if (fdec.getParent() instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration dec = (IASTSimpleDeclaration)fdec.getParent();
            return ((ICPPASTDeclSpecifier)dec.getDeclSpecifier()).isVirtual();
        }
        return false;
    }

    static int getStorageClass(IASTFunctionDeclarator fdec) {
        if (fdec.getParent() instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration dec = (IASTSimpleDeclaration)fdec.getParent();
            return dec.getDeclSpecifier().getStorageClass();
        }
        return -1;
    }

    static IASTNode getParentRemovePoint(IASTFunctionDefinition definition) {
        IASTFunctionDefinition toremove = definition;
        while (toremove.getParent() != null && toremove.getParent() instanceof ICPPASTTemplateDeclaration) {
            toremove = toremove.getParent();
        }
        return toremove;
    }

    static ICPPASTQualifiedName getQualifiedName(IASTFunctionDeclarator declarator, IASTNode limiter) {
        Stack<IASTNode> nodes = ToggleNodeHelper.getQualifiedNames(declarator, limiter, (IASTNode)declarator);
        ICPPASTQualifiedName qName = ToggleNodeHelper.reAssembleQualifiedName(nodes);
        qName.addName(declarator.getName().copy(IASTNode.CopyStyle.withLocations));
        return qName;
    }

    private static ICPPASTQualifiedName reAssembleQualifiedName(Stack<IASTNode> nodes) {
        ICPPASTQualifiedName qName = factory.newQualifiedName(null);
        while (!nodes.isEmpty()) {
            IASTNode nnode = nodes.pop();
            if (nnode instanceof IASTCompositeTypeSpecifier) {
                qName.addName(((IASTCompositeTypeSpecifier)nnode).getName());
                continue;
            }
            if (nnode instanceof ICPPASTNamespaceDefinition) {
                qName.addName(((ICPPASTNamespaceDefinition)nnode).getName());
                continue;
            }
            if (!(nnode instanceof ICPPASTTemplateId)) continue;
            qName.addName((IASTName)((ICPPASTTemplateId)nnode));
        }
        return qName;
    }

    private static Stack<IASTNode> getQualifiedNames(IASTFunctionDeclarator declarator, IASTNode limiter, IASTNode node) {
        IASTName lastName = declarator.getName();
        Stack<IASTNode> nodes = new Stack<IASTNode>();
        while (node.getParent() != null && node.getParent() != limiter) {
            if ((node = node.getParent()) instanceof IASTCompositeTypeSpecifier) {
                nodes.push((IASTNode)((IASTCompositeTypeSpecifier)node).copy(IASTNode.CopyStyle.withLocations));
                lastName = ((IASTCompositeTypeSpecifier)node).getName();
                continue;
            }
            if (node instanceof ICPPASTNamespaceDefinition) {
                nodes.push((IASTNode)((ICPPASTNamespaceDefinition)node).copy(IASTNode.CopyStyle.withLocations));
                lastName = ((ICPPASTNamespaceDefinition)node).getName();
                continue;
            }
            if (lastName instanceof ICPPASTTemplateId || !ToggleNodeHelper.shouldAddTemplateBrackets(node)) continue;
            if (!nodes.isEmpty()) {
                nodes.pop();
            }
            ICPPASTTemplateId templateID = ToggleNodeHelper.getTemplateParameter(node, lastName);
            nodes.add((IASTNode)templateID);
        }
        return nodes;
    }

    private static boolean shouldAddTemplateBrackets(IASTNode node) {
        return node instanceof ICPPASTTemplateDeclaration && !(((ICPPASTTemplateDeclaration)node).getDeclaration() instanceof ICPPASTFunctionDefinition);
    }

    private static ICPPASTTemplateId getTemplateParameter(IASTNode node, IASTName name) {
        ICPPASTTemplateId templateID = factory.newTemplateId(name.copy(IASTNode.CopyStyle.withLocations));
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof ICPPASTSimpleTypeTemplateParameter) {
                ICPPASTSimpleTypeTemplateParameter tempChild = (ICPPASTSimpleTypeTemplateParameter)child;
                IASTName argumentName = tempChild.getName().copy(IASTNode.CopyStyle.withLocations);
                ICPPASTNamedTypeSpecifier namedTypeSpecifier = factory.newNamedTypeSpecifier(argumentName);
                ICPPASTTypeId id = factory.newTypeId((IASTDeclSpecifier)namedTypeSpecifier, null);
                templateID.addTemplateArgument((IASTTypeId)id);
            }
            ++n2;
        }
        return templateID;
    }

    public static String getFilenameWithoutExtension(String filename) {
        int indexP = filename.lastIndexOf(46);
        int indexS = filename.lastIndexOf(47);
        return filename.substring(++indexS, indexP);
    }

    public static ICPPASTFunctionDefinition getFunctionDefinition(IASTNode declaration) {
        IASTNode node = declaration;
        while (node != null) {
            if (node instanceof ICPPASTTemplateDeclaration) {
                ICPPASTTemplateDeclaration templdec = (ICPPASTTemplateDeclaration)node;
                node = templdec.getDeclaration();
                continue;
            }
            if (node instanceof ICPPASTFunctionDefinition) {
                return (ICPPASTFunctionDefinition)node;
            }
            return null;
        }
        return null;
    }

    public static String getBody(IASTFunctionDefinition oldDefinition, IASTTranslationUnit ast, ModificationCollector modifications) {
        return String.valueOf(ToggleNodeHelper.getBodyOnly(oldDefinition, ast, modifications)) + ToggleNodeHelper.getCatchHandlers(oldDefinition, ast, modifications);
    }

    private static String getBodyOnly(IASTFunctionDefinition oldDefinition, IASTTranslationUnit ast, ModificationCollector modifications) {
        String leadingComments = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getLeadingCommentsFromNode((IASTNode)oldDefinition.getBody(), ast, modifications));
        String trailingComments = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getTrailingComments((IASTNode)oldDefinition.getBody(), ast, modifications));
        return String.valueOf(leadingComments) + oldDefinition.getBody().getRawSignature() + trailingComments;
    }

    private static String getCatchHandlers(IASTFunctionDefinition oldDefinition, IASTTranslationUnit ast, ModificationCollector modifications) {
        if (oldDefinition instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTCatchHandler[] oldCatches = ((ICPPASTFunctionWithTryBlock)oldDefinition).getCatchHandlers();
            String allCatchHandlers = EMPTY_STRING;
            int i = 0;
            while (i < oldCatches.length) {
                String lead = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getLeadingCommentsFromNode((IASTNode)oldCatches[i], ast, modifications));
                String trail = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getTrailingComments((IASTNode)oldCatches[i], ast, modifications));
                allCatchHandlers = String.valueOf(allCatchHandlers) + lead + oldCatches[i].getRawSignature() + trail;
                ++i;
            }
            return allCatchHandlers;
        }
        return EMPTY_STRING;
    }

    private static List<IASTComment> getLeadingCommentsFromNode(IASTNode existingNode, IASTTranslationUnit ast, ModificationCollector modifications) {
        ASTRewrite rw = modifications.rewriterForTranslationUnit(ast);
        return rw.getComments(existingNode, ASTRewrite.CommentPosition.leading);
    }

    private static List<IASTComment> getTrailingComments(IASTNode existingNode, IASTTranslationUnit ast, ModificationCollector modifications) {
        ASTRewrite rw = modifications.rewriterForTranslationUnit(ast);
        return rw.getComments(existingNode, ASTRewrite.CommentPosition.trailing);
    }

    public static IASTNode getParentTemplateDeclaration(IASTNode def) {
        if (def == null) {
            return null;
        }
        IASTNode lastSeen = def;
        for (IASTNode node = def.getParent(); node != null; node = node.getParent()) {
            if (node instanceof ICPPASTTemplateDeclaration || node instanceof IASTSimpleDeclaration) {
                lastSeen = node;
                continue;
            }
            return lastSeen;
        }
        return lastSeen;
    }

    private static String getCommentsAsString(List<IASTComment> commentList) {
        String comments = EMPTY_STRING;
        for (IASTComment c : commentList) {
            comments = String.valueOf(comments) + c.getRawSignature() + System.getProperty("line.separator");
        }
        return comments;
    }

    public static List<ICPPASTNamespaceDefinition> findSurroundingNamespaces(IASTNode node) {
        ArrayList<ICPPASTNamespaceDefinition> namespaces = new ArrayList<ICPPASTNamespaceDefinition>();
        ICPPASTNamespaceDefinition currentNamespace = (ICPPASTNamespaceDefinition)ASTQueries.findAncestorWithType((IASTNode)node, ICPPASTNamespaceDefinition.class);
        while (currentNamespace != null) {
            namespaces.add(0, currentNamespace);
            currentNamespace = (ICPPASTNamespaceDefinition)ASTQueries.findAncestorWithType((IASTNode)currentNamespace.getParent(), ICPPASTNamespaceDefinition.class);
        }
        return namespaces;
    }
}

