/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.net.URI;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.dom.parser.ASTProblem;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.CSearchViewPage;
import org.eclipse.cdt.internal.ui.search.IPDOMSearchContentProvider;
import org.eclipse.cdt.internal.ui.search.LineSearchElement;
import org.eclipse.cdt.internal.ui.search.ProblemSearchElement;
import org.eclipse.cdt.internal.ui.search.TypeInfoSearchElement;
import org.eclipse.cdt.internal.ui.viewsupport.CUILabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.browser.typeinfo.TypeInfoLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CSearchLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    protected final CSearchViewPage fPage;
    private final TypeInfoLabelProvider fTypeInfoLabelProvider = new TypeInfoLabelProvider(20);
    private final CUILabelProvider fCElementLabelProvider = new CUILabelProvider(0L, 2);

    public CSearchLabelProvider(CSearchViewPage page) {
        this.fPage = page;
    }

    public Image getImage(Object element) {
        if (element instanceof LineSearchElement) {
            LineSearchElement lineSearchElement = (LineSearchElement)element;
            ICElement enclosingElement = lineSearchElement.getMatches()[0].getEnclosingElement();
            if (!this.fPage.isShowEnclosingDefinitions() || enclosingElement == null) {
                return CDTSharedImages.getImage("icons/obj16/searchm_obj.gif");
            }
            element = enclosingElement;
        }
        if (element instanceof TypeInfoSearchElement) {
            return this.fTypeInfoLabelProvider.getImage(((TypeInfoSearchElement)element).getTypeInfo());
        }
        if (element instanceof ProblemSearchElement) {
            return CDTSharedImages.getImage("icons/tobj16/warning_obj.png");
        }
        if (element instanceof IIndexFileLocation || element instanceof URI) {
            return CDTSharedImages.getImage("icons/tobj16/include_obj.png");
        }
        if (element == IPDOMSearchContentProvider.URI_CONTAINER) {
            return CDTSharedImages.getImage("icons/tobj16/includes_container.png");
        }
        if (element instanceof IPath) {
            return CDTSharedImages.getImage("icons/tobj16/hfolder_obj.png");
        }
        if (element instanceof IStatus) {
            IStatus status = (IStatus)element;
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            switch (status.getSeverity()) {
                case 2: {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                case 4: {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            return sharedImages.getImage("IMG_OBJS_INFO_TSK");
        }
        return this.fCElementLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        IPath path;
        if (element instanceof LineSearchElement) {
            return element.toString();
        }
        if (element instanceof TypeInfoSearchElement) {
            return this.fTypeInfoLabelProvider.getText(((TypeInfoSearchElement)element).getTypeInfo());
        }
        if (element instanceof ProblemSearchElement) {
            ProblemSearchElement pse = (ProblemSearchElement)element;
            return ASTProblem.getMessage((int)pse.getProblemID(), (String)pse.getDetail());
        }
        if (element instanceof IPath) {
            return ((IPath)element).toString();
        }
        if (element instanceof IIndexFileLocation && (path = IndexLocationFactory.getPath((IIndexFileLocation)((IIndexFileLocation)element))) != null) {
            return path.lastSegment();
        }
        if (element instanceof URI) {
            return ((URI)element).toString();
        }
        if (element instanceof IStatus) {
            return ((IStatus)element).getMessage();
        }
        return this.fCElementLabelProvider.getText(element);
    }

    protected int getMatchCount(Object element) {
        if (element instanceof TranslationUnit) {
            TranslationUnit translationUnit = (TranslationUnit)element;
            AbstractTextSearchResult searchResult = this.fPage.getInput();
            if (searchResult instanceof CSearchResult) {
                CSearchResult pdomSearchResult = (CSearchResult)searchResult;
                return pdomSearchResult.computeContainedMatches(searchResult, translationUnit.getFile()).length;
            }
        }
        return this.fPage.getInput().getMatchCount(element);
    }

    public StyledString getStyledText(Object element) {
        if (!(element instanceof LineSearchElement)) {
            return new StyledString(this.getText(element));
        }
        LineSearchElement lineElement = (LineSearchElement)element;
        int lineOffset = lineElement.getOffset();
        String lineContent = lineElement.getContent();
        StyledString styled = new StyledString(lineContent);
        LineSearchElement.Match[] matchArray = lineElement.getMatches();
        int n = matchArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineSearchElement.Match match = matchArray[n2];
            int offset = Math.max(0, match.getOffset() - lineOffset);
            int length = Math.min(match.getLength(), lineContent.length() - offset);
            StyledString.Styler style = match.isWriteAccess() ? ColoringLabelProvider.HIGHLIGHT_WRITE_STYLE : ColoringLabelProvider.HIGHLIGHT_STYLE;
            styled.setStyle(offset, length, style);
            ++n2;
        }
        return styled;
    }
}

