/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.editor.FeatureManager;
import org.tizen.nativecore.misc.editor.FeatureSelectionListner;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;

public class FeaturesPage
extends TizenFormPage
implements SelectionListener {
    private TableViewer fViewer;
    private String imagePath;
    private Button fBtnAdd;
    private Button feBtnEdit;
    private Button fBtnRemove;
    FeatureManager featureManager;
    private FormToolkit toolkit;
    private String fBtnAddEnabled;
    private String fBtnEditEnabled;
    private String fBtnRemoveEnabled;

    public FeaturesPage(FormEditor editor) {
        super(editor, "Features", Messages.FeaturesPage_label);
        IProject project = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            project = file.getProject();
        }
        this.featureManager = new FeatureManager(project);
    }

    private void disableAllButtons() {
        this.fBtnRemove.setEnabled(false);
        this.feBtnEdit.setEnabled(false);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit tk;
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setExpandVertical(true);
        scrolledForm.setExpandHorizontal(true);
        this.toolkit = tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_features.png").getFile();
        Composite client = SectionHelper.createHeaderSection(tk, body, Messages.FeaturesPage_label, this.imagePath, Messages.FeaturesPage_title, Messages.FeatureBaseDetailsPage_sdesc);
        GridData buttonGridData = new GridData();
        buttonGridData.horizontalAlignment = 3;
        buttonGridData.grabExcessHorizontalSpace = true;
        Composite buttonsComposite = tk.createComposite(client);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        buttonsComposite.setLayoutData((Object)buttonGridData);
        this.fBtnAdd = new Button(buttonsComposite, 0x2000000);
        this.fBtnAddEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_add_over.png").getFile();
        this.fBtnAdd.setBackgroundImage(new Image(null, new ImageData(this.fBtnAddEnabled)));
        this.fBtnAdd.addSelectionListener((SelectionListener)this);
        this.feBtnEdit = new Button(buttonsComposite, 0x2000000);
        this.fBtnEditEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_edit_over.png").getFile();
        this.feBtnEdit.setBackgroundImage(new Image(null, new ImageData(this.fBtnEditEnabled)));
        this.feBtnEdit.addSelectionListener((SelectionListener)this);
        this.feBtnEdit.setEnabled(false);
        this.fBtnRemove = new Button(buttonsComposite, 0x2000000);
        this.fBtnRemoveEnabled = IdePlugin.getDefault().getResourceLocationURL("icons/editor/btn_delete_over.png").getFile();
        this.fBtnRemove.setBackgroundImage(new Image(null, new ImageData(this.fBtnRemoveEnabled)));
        this.fBtnRemove.addSelectionListener((SelectionListener)this);
        this.fBtnRemove.setEnabled(false);
        Table table = new Table(client, 67586);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        table.setLayoutData((Object)gd);
        this.fViewer = new TableViewer(table);
        TableViewerColumn nameColumn = new TableViewerColumn(this.fViewer, 0);
        nameColumn.getColumn().setText("Name");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.fViewer.getTable().setLayout((Layout)tableLayout);
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Manifest) {
                    Manifest model = (Manifest)inputElement;
                    return model.getPrivilege_map().keySet().toArray();
                }
                return null;
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Manifest) {
                    Manifest model = (Manifest)inputElement;
                    ArrayList<String> filtered = new ArrayList<String>();
                    for (String key : model.getFeature_map().keySet()) {
                        if (FeaturesPage.this.featureManager.getFeature(key).isHidden()) continue;
                        filtered.add(key);
                    }
                    return filtered.toArray();
                }
                return null;
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        });
        this.fViewer.setSorter((ViewerSorter)new SimpleSorter());
        this.fViewer.setInput((Object)this.getEditor().getCoreManifest());
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Feature feature = null;
                if (sel != null) {
                    IStructuredSelection ssel = sel;
                    if (ssel.size() == 1) {
                        String key = (String)ssel.getFirstElement();
                        feature = FeaturesPage.this.featureManager.getFeature(key);
                    } else {
                        feature = null;
                    }
                    if (feature == null) {
                        FeaturesPage.this.disableAllButtons();
                    } else {
                        FeaturesPage.this.fBtnRemove.setEnabled(true);
                        FeaturesPage.this.feBtnEdit.setEnabled(true);
                    }
                    FeaturesPage.this.setDirty(true);
                } else {
                    FeaturesPage.this.disableAllButtons();
                }
            }
        });
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    public void update(Manifest model) {
        if (this.fViewer != null) {
            this.fViewer.setInput((Object)model);
        }
    }

    private void updateFeature(boolean isEditFeature) {
        AddCustomFeatureDialog dialog = new AddCustomFeatureDialog(this.toolkit, this);
        if (dialog.open() == 0) {
            Feature f;
            if (isEditFeature) {
                this.removeFeature();
            }
            if ((f = dialog.getSelectedFeature()) != null) {
                MessageDialog mdlg;
                int result;
                if (f.getKey().equals("http://tizen.org/feature/screen.size.all") && (result = (mdlg = new MessageDialog(this.getSite().getShell(), "Warning", null, Messages.FeatureDialogMessage_SSIZE_ALL, 3, new String[]{"Yes", "No"}, 0)).open()) == 1) {
                    return;
                }
                if (f.getKey().equals("http://tizen.org/feature/screen.size.normal") && (result = (mdlg = new MessageDialog(this.getSite().getShell(), "Warning", null, Messages.FeatureDialogMessage_SSIZE_NORMAL, 3, new String[]{"Yes", "No"}, 0)).open()) == 1) {
                    return;
                }
                this.getEditor().getCoreManifest().addFeature(f.getKey(), f.getUserValue());
                this.fViewer.add((Object)f.getKey());
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)f.getKey()), true);
                this.setDirty(true);
            }
        }
    }

    private void removeFeature() {
        IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
        String key = (String)sel.getFirstElement();
        if (key != null) {
            this.getEditor().getCoreManifest().removeFeature(key);
            this.fViewer.remove((Object)key);
            this.fBtnRemove.setEnabled(false);
            this.feBtnEdit.setEnabled(false);
            this.setDirty(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.fBtnAdd) {
            this.updateFeature(false);
        }
        if (e.widget == this.feBtnEdit) {
            this.updateFeature(true);
        }
        if (e.widget == this.fBtnRemove) {
            this.removeFeature();
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public class AddCustomFeatureDialog
    extends SelectionStatusDialog {
        protected FormToolkit toolkit;
        protected TizenFormPage fpage;
        protected Feature selectedFeature;
        private Text filterText;
        private List featureList;
        private Feature[] filteredFeatures;
        private String[] availableFeatures;
        private int width;
        private int height;
        private Text descriptionText;
        private Combo fOptionCombo;
        private Label fOptionComboLabel;
        private Label fErrorMessage;

        public AddCustomFeatureDialog(FormToolkit tk, TizenFormPage page) {
            super(Display.getDefault().getActiveShell());
            this.width = 50;
            this.height = 15;
            this.toolkit = tk;
            this.fpage = page;
            this.setTitle("Add features");
        }

        public Feature getSelectedFeature() {
            return this.selectedFeature;
        }

        public void setSelectedFeature(Feature selectedFeature) {
            this.selectedFeature = selectedFeature;
        }

        public Font getFont(int size, Control widget) {
            FontData[] fD = widget.getFont().getFontData();
            fD[0].setHeight(size);
            return new Font(null, fD[0]);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginTop = 20;
            layout.marginBottom = 9;
            layout.marginLeft = 20;
            layout.marginRight = 20;
            layout.verticalSpacing = 10;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 510;
            composite.setLayoutData((Object)gd);
            this.filterText = new Text(composite, 2048);
            this.filterText.setMessage("Search");
            this.filterText.setLayoutData((Object)new GridData(256));
            this.filterText.setFont(this.getFont(10, (Control)this.filterText));
            this.fErrorMessage = new Label(composite, 64);
            GridData layoutData = new GridData(768);
            layoutData.horizontalIndent = 10;
            this.fErrorMessage.setLayoutData((Object)layoutData);
            this.fErrorMessage.setText("Please enter valid text");
            this.fErrorMessage.setForeground(new Color(null, 255, 1, 1));
            this.fErrorMessage.setFont(this.getFont(8, (Control)this.fErrorMessage));
            this.fErrorMessage.setVisible(true);
            this.featureList = new List(composite, 2562);
            GridData data = new GridData();
            data.widthHint = this.convertWidthInCharsToPixels(this.width);
            data.heightHint = this.convertHeightInCharsToPixels(this.height);
            data.grabExcessVerticalSpace = true;
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            this.featureList.setLayoutData((Object)data);
            this.featureList.setFont(this.getFont(10, (Control)this.featureList));
            Label DesLabel = new Label(composite, 16448);
            DesLabel.setText("Description");
            DesLabel.setFont(this.getFont(10, (Control)DesLabel));
            GridData TextLayout = new GridData();
            TextLayout.widthHint = 470;
            TextLayout.heightHint = 55;
            TextLayout.grabExcessVerticalSpace = true;
            TextLayout.grabExcessHorizontalSpace = true;
            TextLayout.horizontalAlignment = 4;
            TextLayout.verticalAlignment = 4;
            this.descriptionText = new Text(composite, 2634);
            this.descriptionText.setBackground(new Color(null, 255, 255, 255));
            this.descriptionText.setLayoutData((Object)TextLayout);
            this.descriptionText.setFont(this.getFont(10, (Control)this.descriptionText));
            GridData labelGridData = new GridData();
            labelGridData.horizontalAlignment = 1;
            labelGridData.grabExcessHorizontalSpace = true;
            Composite labelComposite = new Composite(composite, 0);
            labelComposite.setLayout((Layout)new GridLayout(2, false));
            labelComposite.setLayoutData((Object)labelGridData);
            this.fOptionComboLabel = new Label(labelComposite, 0x2000000);
            this.fOptionComboLabel.setText("Select Option:");
            this.fOptionComboLabel.setFont(this.getFont(10, (Control)this.fOptionComboLabel));
            this.fOptionComboLabel.setVisible(false);
            this.fOptionCombo = new Combo(labelComposite, 0x2000008);
            this.fOptionCombo.setBackground(new Color(null, 255, 255, 255));
            this.fOptionCombo.setVisible(false);
            this.fOptionCombo.setFont(this.getFont(10, (Control)this.fOptionComboLabel));
            this.filterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddCustomFeatureDialog.this.featureList.removeAll();
                    AddCustomFeatureDialog.this.descriptionText.setText("");
                    String strfilter = AddCustomFeatureDialog.this.filterText.getText().trim();
                    if (strfilter.isEmpty()) {
                        AddCustomFeatureDialog.this.featureList.setItems(AddCustomFeatureDialog.this.availableFeatures);
                        AddCustomFeatureDialog.this.fErrorMessage.setVisible(true);
                        return;
                    }
                    AddCustomFeatureDialog.this.fErrorMessage.setVisible(false);
                    String[] stringArray = AddCustomFeatureDialog.this.availableFeatures;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String featureName = stringArray[n2];
                        if (featureName.contains(strfilter)) {
                            AddCustomFeatureDialog.this.featureList.add(featureName);
                        }
                        ++n2;
                    }
                }
            });
            this.filteredFeatures = FeaturesPage.this.featureManager.getUnusedFeatures(FeaturesPage.this.getEditor().getCoreManifest());
            ArrayList<String> filtered = new ArrayList<String>(this.filteredFeatures.length);
            int i = 0;
            while (i < this.filteredFeatures.length) {
                filtered.add(this.filteredFeatures[i].getKey());
                ++i;
            }
            if (!filtered.isEmpty()) {
                this.availableFeatures = filtered.toArray(new String[filtered.size()]);
                Arrays.sort(this.availableFeatures, 0, this.availableFeatures.length, String.CASE_INSENSITIVE_ORDER);
                this.featureList.setItems(this.availableFeatures);
            }
            this.featureList.addSelectionListener((SelectionListener)new FeatureSelectionListner(this.descriptionText, this.filteredFeatures, this.fOptionComboLabel, this.fOptionCombo));
            return composite;
        }

        protected void computeResult() {
            int i = 0;
            while (i < this.filteredFeatures.length) {
                if (this.filteredFeatures[i].getKey().equals(this.featureList.getItem(this.featureList.getSelectionIndex()))) {
                    this.selectedFeature = this.filteredFeatures[i];
                }
                ++i;
            }
        }
    }

    private static class SimpleSorter
    extends ViewerSorter {
        private SimpleSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return e1.toString().compareTo(e2.toString());
        }
    }
}

