/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FrameComponent {
    private String id;
    private String launchMode;
    private String main;
    private String iconDisplay;
    private String taskManage;
    private Label defaultLabel;
    private Icon defaultIcon;
    private List<LocaledValue> labelList = new ArrayList<LocaledValue>();
    private List<LocaledValue> iconList = new ArrayList<LocaledValue>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLaunchMode() {
        return this.launchMode;
    }

    public void setLaunchMode(String launchMode) {
        this.launchMode = launchMode;
    }

    public String getMain() {
        return this.main;
    }

    public void setMain(String main) {
        this.main = main;
    }

    public String getIconDisplay() {
        return this.iconDisplay;
    }

    public void setIconDisplay(String iconDisplay) {
        this.iconDisplay = iconDisplay;
    }

    public String getTaskManage() {
        return this.taskManage;
    }

    public void setTaskManage(String taskManage) {
        this.taskManage = taskManage;
    }

    public void loadElement(Element element) {
        this.id = element.getAttribute("id");
        this.launchMode = element.getAttribute("launch_mode");
        this.main = element.getAttribute("main");
        this.iconDisplay = element.getAttribute("icon-display");
        this.taskManage = element.getAttribute("taskmanage");
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.labelList.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                Icon icon = new Icon();
                icon.loadElement((Element)node);
                if (icon.getLang() != null && icon.getLang().length() > 0 || icon.getDpi() != null && icon.getDpi().length() > 0) {
                    this.iconList.add(new LocaledValue(icon.getLang(), icon.getValue(), icon.getDpi()));
                } else {
                    this.defaultIcon = icon;
                }
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement("frame-component");
        if (this.id != null && this.id.length() > 0) {
            element.setAttribute("id", this.id);
        }
        if (this.main != null && this.main.length() > 0) {
            element.setAttribute("main", this.main);
        }
        if (this.iconDisplay != null && this.iconDisplay.length() > 0) {
            element.setAttribute("icon-display", this.iconDisplay);
        }
        if (this.taskManage != null && this.taskManage.length() > 0) {
            element.setAttribute("taskmanage", this.taskManage);
        }
        if (this.launchMode != null && this.launchMode.length() > 0) {
            element.setAttribute("launch_mode", this.launchMode);
        }
        this.generateLabels(dom, element);
        this.generateIcons(dom, element);
        parent.appendChild(element);
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.labelList;
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    private void generateIcons(Document dom, Element parent) {
        List<LocaledValue> icons = this.iconList;
        if (icons.isEmpty() && this.defaultIcon == null) {
            return;
        }
        if (this.defaultIcon != null) {
            Element eIcon = dom.createElement("icon");
            eIcon.setTextContent(this.defaultIcon.getValue());
            parent.appendChild(eIcon);
        }
        for (LocaledValue lv : icons) {
            Element eIcon = dom.createElement("icon");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eIcon.setAttribute("xml:lang", lv.getLocale());
            }
            if (lv.getDpi() != null && lv.getDpi().length() > 0) {
                eIcon.setAttribute("dpi", lv.getDpi());
            }
            eIcon.setTextContent(lv.getValue());
            parent.appendChild(eIcon);
        }
    }
}

