/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativecommon.Activator;
import org.tizen.nativecommon.ui.preferences.Messages;

public class TIDLPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String CPP = "C++";
    private static final String C = "C";
    private String language;
    private static Button cppButton;
    private static Button cButton;
    private static Button stubCheckBox;
    private static Button proxyCheckBox;
    private static Text outputFilePath;
    private static GridData gridData;
    private static final Activator plugin;

    static {
        plugin = Activator.getDefault();
    }

    public TIDLPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription(Messages.TIDL_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        SWTUtil.setGridLayout((Composite)parent, (int)1, (boolean)false, (int)-1, (int)-1, (int)-1, (int)-1, (int)1808);
        Group serverGroup = SWTUtil.createGroup((Composite)parent, (String)Messages.TIDL_GROUP_INFO, (int)1);
        SWTUtil.setGridLayout((Composite)serverGroup, (int)2, (boolean)false, (int)-1, (int)-1, (int)-1, (int)-1, (int)768);
        Composite tidlGroupComp = new Composite((Composite)serverGroup, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 50;
        tidlGroupComp.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        TIDLPreferencePage.gridData.horizontalSpan = 2;
        tidlGroupComp.setLayoutData((Object)gridData);
        TIDLPreferencePage.createLanguageButtonGroup((Composite)serverGroup);
        TIDLPreferencePage.createOptionsCheckBoxGroup(tidlGroupComp);
        TIDLPreferencePage.createOutputFilePathGroup(tidlGroupComp);
        Button browse = new Button(tidlGroupComp, 8);
        browse.setText("Browse");
        browse.setLayoutData((Object)new GridData(4, 4, true, false, 1, 0));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SWTUtil.getActiveShell(), 0);
                String path = dialog.open();
                if (path != null) {
                    outputFilePath.setText(String.valueOf(path) + File.separator + "tidlCode");
                }
            }
        });
    }

    private static void createLanguageButtonGroup(Composite parent) {
        Group languageGroup = SWTUtil.createGroup((Composite)parent, (String)Messages.TIDL_LANGUAGE_CHOICES, (int)2);
        SWTUtil.setGridLayout((Composite)parent, (int)2, (boolean)false, (int)-1, (int)-1, (int)-1, (int)-1, (int)768);
        cppButton = new Button((Composite)languageGroup, 16);
        cppButton.setText(CPP);
        cButton = new Button((Composite)languageGroup, 16);
        cButton.setText(C);
        if (plugin.getLanguagePreference().equals(CPP)) {
            cppButton.setSelection(true);
        } else {
            cButton.setSelection(true);
        }
    }

    private static void createOptionsCheckBoxGroup(Composite parent) {
        stubCheckBox = SWTUtil.createCheckbox((Composite)parent, (String)Messages.TIDL_STUB_CHECKBOX_LABEL, null, (boolean)true, (boolean)true);
        stubCheckBox.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        stubCheckBox.setSelection(plugin.getStubPreference().booleanValue());
        proxyCheckBox = SWTUtil.createCheckbox((Composite)parent, (String)Messages.TIDL_PROXY_CHECKBOX_LABEL, null, (boolean)false, (boolean)true);
        stubCheckBox.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        proxyCheckBox.setSelection(plugin.getProxyPreference().booleanValue());
    }

    private static void createOutputFilePathGroup(Composite parent) {
        Label outputFilePathLabel = new Label(parent, 0);
        outputFilePathLabel.setText(Messages.TIDL_OUTPUT_TEXTBOX_LABEL);
        outputFilePath = new Text(parent, 2048);
        outputFilePath.setText(plugin.getOutputPathPreference());
        SWTUtil.setGridLayoutData((Control)outputFilePath, (int)-1, (int)-1, (int)-1, (int)-1, (int)768);
    }

    protected void performDefaults() {
        if (plugin.getDefaultLanguagePreference().equals(CPP)) {
            cppButton.setSelection(true);
            cButton.setSelection(false);
        } else {
            cButton.setSelection(true);
            cppButton.setSelection(false);
        }
        outputFilePath.setText(plugin.getDefaultOutputPathPreference());
        stubCheckBox.setSelection(plugin.getDefaultStubPreference().booleanValue());
        proxyCheckBox.setSelection(plugin.getDefaultProxyPreference().booleanValue());
        super.performDefaults();
    }

    protected void performApply() {
        this.language = cButton.isEnabled() ? cButton.getText() : cppButton.getText();
        Activator.getDefault().setTIDLPreferences(this.language, outputFilePath.getText(), stubCheckBox.getSelection(), proxyCheckBox.getSelection());
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }
}

