/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.DataControl;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Image;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Metadata;
import org.tizen.nativecore.ext.manifest.Permission;
import org.tizen.nativecore.ext.manifest.TizenSplashScreen;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.tizen.nativecore.misc.utils.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UiApplication
implements IApplication {
    public static final String ELEMENT = "ui-application";
    public static final String ATTR_APPID = "appid";
    public static final String ATTR_EXEC = "exec";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_NODISPLAY = "nodisplay";
    public static final String ATTR_TASKMANAGE = "taskmanage";
    public static final String ATTR_ENABLED = "enabled";
    public static final String ATTR_SPLASH_SCREEN_DISPLAY = "splash-screen-display";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_CATEGORIES = "categories";
    public static final String ATTR_EXTRAID = "extraid";
    public static final String ATTR_HW_ACCELERATION = "hw-acceleration";
    public static final String ATTR_SCREEN_READER = "screen-reader";
    public static final String ATTR_RECENTIMAGE = "recentimage";
    public static final String ATTR_MAINAPP = "mainapp";
    public static final String ATTR_INDICATORDISPLAY = "indicatordisplay";
    public static final String ATTR_PORTRAIT_EFFECTIMAGE = "portrait-effectimage";
    public static final String ATTR_LANDSCAPE_EFFECTIMAGE = "landscape-effectimage";
    public static final String ATTR_EFFECTIMAGE_TYPE = "effectimage-type";
    public static final String ATTR_GUESTMODE_VISIBILITY = "guestmode-visibility";
    public static final String ATTR_LAUNCHCONDITION = "launchcondition";
    public static final String ATTR_PERMISSION_TYPE = "permission-type";
    public static final String ATTR_COMPONENT_TYPE = "component-type";
    public static final String ATTR_SUBMODE = "submode";
    public static final String ATTR_SUBMODE_MAINID = "submode-mainid";
    public static final String ATTR_PROCESS_POOL = "process-pool";
    public static final String ATTR_AUTO_RESTART = "auto-restart";
    public static final String ATTR_ON_BOOT = "on-boot";
    public static final String ATTR_MULTI_INSTANCE = "multi-instance";
    public static final String ATTR_MULTI_INSTANCE_MAINID = "multi-instance-mainid";
    public static final String ATTR_UIGADGET = "ui-gadget";
    public static final String ATTR_LAUNCH_MODE = "launch_mode";
    private String appid;
    private String exec;
    private String multiple;
    private String nodisplay;
    private String taskmanage;
    private String enabled;
    private String type;
    private String categories;
    private String auto_restart;
    private String on_boot;
    private String extraid;
    private String hw_acceleration;
    private String screen_reader;
    private String recentimage;
    private String mainapp;
    private String indicatordisplay;
    private String portrait_effectimage;
    private String landscape_effectimage;
    private String effectimage_type;
    private String guestmode_visibility;
    private String launchcondition;
    private String permission_type;
    private String component_type;
    private String submode;
    private String submode_mainid;
    private String process_pool;
    private String multi_instance;
    private String multi_instance_mainid;
    private String ui_gadget;
    private String launch_mode;
    private String splashScreenDisplay;
    private String apiVersion;
    private Label defaultLabel;
    private List<LocaledValue> label_list = new ArrayList<LocaledValue>();
    private List<LocaledValue> icon_list = new ArrayList<LocaledValue>();
    private Icon defaultIcon;
    private Image image;
    private List<AppControl> appServiceList;
    private Map<String, Category> category_map = new HashMap<String, Category>();
    private List<Metadata> metadataList;
    private Permission permission;
    private List<DataControl> datacontrolList;
    private List<BackgroundCategory> bgCategoryList;
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private List<TizenSplashScreen> splash_list = new ArrayList<TizenSplashScreen>();
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";

    @Override
    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setApiVersion(element.getAttribute("api-version"));
        this.setAppid(element.getAttribute(ATTR_APPID));
        this.setExec(element.getAttribute(ATTR_EXEC));
        if (element.getAttribute(ATTR_MULTIPLE).equals(STRING_TRUE) || element.getAttribute(ATTR_MULTIPLE).equals(STRING_FALSE)) {
            this.setMultiple(element.getAttribute(ATTR_MULTIPLE));
        } else {
            this.setMultiple(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        if (element.getAttribute(ATTR_NODISPLAY).equals(STRING_TRUE) || element.getAttribute(ATTR_NODISPLAY).equals(STRING_FALSE)) {
            this.setNodisplay(element.getAttribute(ATTR_NODISPLAY));
        } else {
            this.setNodisplay(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        if (element.getAttribute(ATTR_TASKMANAGE).equals(STRING_TRUE) || element.getAttribute(ATTR_TASKMANAGE).equals(STRING_FALSE)) {
            this.setTaskmanage(element.getAttribute(ATTR_TASKMANAGE));
        } else {
            this.setTaskmanage(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        if (element.getAttribute(ATTR_HW_ACCELERATION).equals(Constants.HW_ACCELERATION_VALUES[1]) || element.getAttribute(ATTR_HW_ACCELERATION).equals(Constants.HW_ACCELERATION_VALUES[2])) {
            this.setHw_acceleration(element.getAttribute(ATTR_HW_ACCELERATION));
        } else {
            this.setHw_acceleration(Constants.HW_ACCELERATION_VALUES[0]);
        }
        if (element.getAttribute(ATTR_SPLASH_SCREEN_DISPLAY).equals(STRING_TRUE) || element.getAttribute(ATTR_SPLASH_SCREEN_DISPLAY).equals(STRING_FALSE)) {
            this.setSplashScreenDisplay(element.getAttribute(ATTR_SPLASH_SCREEN_DISPLAY));
        }
        this.setType(element.getAttribute(ATTR_TYPE));
        this.enabled = element.getAttribute(ATTR_ENABLED);
        this.categories = element.getAttribute(ATTR_CATEGORIES);
        this.extraid = element.getAttribute(ATTR_EXTRAID);
        this.screen_reader = element.getAttribute(ATTR_SCREEN_READER);
        this.recentimage = element.getAttribute(ATTR_RECENTIMAGE);
        this.mainapp = element.getAttribute(ATTR_MAINAPP);
        this.indicatordisplay = element.getAttribute(ATTR_INDICATORDISPLAY);
        this.portrait_effectimage = element.getAttribute(ATTR_PORTRAIT_EFFECTIMAGE);
        this.landscape_effectimage = element.getAttribute(ATTR_LANDSCAPE_EFFECTIMAGE);
        this.effectimage_type = element.getAttribute(ATTR_EFFECTIMAGE_TYPE);
        this.guestmode_visibility = element.getAttribute(ATTR_GUESTMODE_VISIBILITY);
        this.launchcondition = element.getAttribute(ATTR_LAUNCHCONDITION);
        this.permission_type = element.getAttribute(ATTR_PERMISSION_TYPE);
        this.component_type = element.getAttribute(ATTR_COMPONENT_TYPE);
        this.submode = element.getAttribute(ATTR_SUBMODE);
        this.submode_mainid = element.getAttribute(ATTR_SUBMODE_MAINID);
        this.process_pool = element.getAttribute(ATTR_PROCESS_POOL);
        if (element.getAttribute(ATTR_LAUNCH_MODE).equals(Constants.LAUNCH_MODE_VALUES[1]) || element.getAttribute(ATTR_LAUNCH_MODE).equals(Constants.LAUNCH_MODE_VALUES[2]) || element.getAttribute(ATTR_LAUNCH_MODE).equals(Constants.LAUNCH_MODE_VALUES[3])) {
            this.setLaunch_mode(element.getAttribute(ATTR_LAUNCH_MODE));
        } else {
            this.setLaunch_mode(Constants.LAUNCH_MODE_VALUES[0]);
        }
        if (element.getAttribute(ATTR_AUTO_RESTART).equals(STRING_TRUE) || element.getAttribute(ATTR_AUTO_RESTART).equals(STRING_FALSE)) {
            this.setAuto_restart(element.getAttribute(ATTR_AUTO_RESTART));
        } else {
            this.setAuto_restart(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        if (element.getAttribute(ATTR_ON_BOOT).equals(STRING_TRUE) || element.getAttribute(ATTR_ON_BOOT).equals(STRING_FALSE)) {
            this.setOn_boot(element.getAttribute(ATTR_ON_BOOT));
        } else {
            this.setOn_boot(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        this.multi_instance = element.getAttribute(ATTR_MULTI_INSTANCE);
        this.multi_instance_mainid = element.getAttribute(ATTR_MULTI_INSTANCE_MAINID);
        if (element.getAttribute(ATTR_UIGADGET).equals(STRING_TRUE) || element.getAttribute(ATTR_UIGADGET).equals(STRING_FALSE)) {
            this.setUiGadget(element.getAttribute(ATTR_UIGADGET));
        } else {
            this.setUiGadget(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.label_list.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                Icon icon = new Icon();
                icon.loadElement((Element)node);
                if (icon.getLang() != null && icon.getLang().length() > 0 || icon.getDpi() != null && icon.getDpi().length() > 0) {
                    this.icon_list.add(new LocaledValue(icon.getLang(), icon.getValue(), icon.getDpi()));
                } else {
                    this.defaultIcon = icon;
                }
            } else if (nodeName.equals("app-control")) {
                AppControl application_service = new AppControl();
                application_service.loadElement((Element)node);
                this.getAppServiceList().add(application_service);
            } else if (nodeName.equals("category")) {
                Category category = new Category();
                category.loadElement((Element)node);
                this.getCategory_map().put(category.getName(), category);
            } else if (nodeName.equals("metadata")) {
                Metadata metadata = new Metadata();
                metadata.loadElement((Element)node);
                this.getMetadataList().add(metadata);
            } else if (nodeName.equals("datacontrol")) {
                DataControl datacontrol = new DataControl();
                datacontrol.loadElement((Element)node);
                this.getDataControlList().add(datacontrol);
            } else if (nodeName.equals("permission")) {
                this.permission = new Permission();
                this.permission.loadElement((Element)node);
            } else if (nodeName.equals("background-category")) {
                BackgroundCategory bgCategory = new BackgroundCategory();
                bgCategory.loadElement((Element)node);
                this.getBgCategoryList().add(bgCategory);
            } else if (nodeName.equals("splash-screens")) {
                if (node.getFirstChild() == null) {
                    node.getParentNode().removeChild(node);
                }
                Node childNode = node.getFirstChild();
                while (childNode != null) {
                    String childNodeName = childNode.getNodeName();
                    if (childNodeName.equalsIgnoreCase("splash-screen")) {
                        TizenSplashScreen splashScreen = new TizenSplashScreen();
                        splashScreen.loadElement((Element)childNode);
                        this.getSplashScreenList().add(splashScreen);
                    }
                    childNode = childNode.getNextSibling();
                }
            } else if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.apiVersion != null && CheckerUtil.isApplicationAPIVersionSupported(this.apiVersion)) {
            element.setAttribute("api-version", this.apiVersion);
        }
        if (this.getAppid() != null && this.getAppid().length() > 0) {
            element.setAttribute(ATTR_APPID, this.getAppid());
        } else {
            element.setAttribute(ATTR_APPID, "");
        }
        if (this.exec != null && this.exec.length() > 0) {
            element.setAttribute(ATTR_EXEC, this.exec);
        } else {
            element.setAttribute(ATTR_EXEC, "");
        }
        if (this.getMultiple() != null && this.getMultiple().length() > 0 && !this.getMultiple().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_MULTIPLE, this.getMultiple());
        }
        if (this.getNodisplay() != null && this.getNodisplay().length() > 0 && !this.getNodisplay().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_NODISPLAY, this.getNodisplay());
        }
        if (this.getTaskmanage() != null && this.getTaskmanage().length() > 0 && !this.getTaskmanage().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_TASKMANAGE, this.getTaskmanage());
        }
        if (this.enabled != null && this.enabled.length() > 0) {
            element.setAttribute(ATTR_ENABLED, this.enabled);
        }
        if (this.type != null && this.type.length() > 0) {
            element.setAttribute(ATTR_TYPE, this.type);
        } else {
            element.setAttribute(ATTR_TYPE, "");
        }
        if (this.categories != null && this.categories.length() > 0) {
            element.setAttribute(ATTR_CATEGORIES, this.categories);
        }
        if (this.extraid != null && this.extraid.length() > 0) {
            element.setAttribute(ATTR_EXTRAID, this.extraid);
        }
        if (this.hw_acceleration != null && this.hw_acceleration.length() > 0 && !this.hw_acceleration.equals(Constants.HW_ACCELERATION_VALUES[0])) {
            element.setAttribute(ATTR_HW_ACCELERATION, this.hw_acceleration);
        }
        if (this.screen_reader != null && this.screen_reader.length() > 0) {
            element.setAttribute(ATTR_SCREEN_READER, this.screen_reader);
        }
        if (this.recentimage != null && this.recentimage.length() > 0) {
            element.setAttribute(ATTR_RECENTIMAGE, this.recentimage);
        }
        if (this.mainapp != null && this.mainapp.length() > 0) {
            element.setAttribute(ATTR_MAINAPP, this.mainapp);
        }
        if (this.indicatordisplay != null && this.indicatordisplay.length() > 0) {
            element.setAttribute(ATTR_INDICATORDISPLAY, this.indicatordisplay);
        }
        if (this.portrait_effectimage != null && this.portrait_effectimage.length() > 0) {
            element.setAttribute(ATTR_PORTRAIT_EFFECTIMAGE, this.portrait_effectimage);
        }
        if (this.landscape_effectimage != null && this.landscape_effectimage.length() > 0) {
            element.setAttribute(ATTR_LANDSCAPE_EFFECTIMAGE, this.landscape_effectimage);
        }
        if (this.effectimage_type != null && this.effectimage_type.length() > 0) {
            element.setAttribute(ATTR_EFFECTIMAGE_TYPE, this.effectimage_type);
        }
        if (this.guestmode_visibility != null && this.guestmode_visibility.length() > 0) {
            element.setAttribute(ATTR_GUESTMODE_VISIBILITY, this.guestmode_visibility);
        }
        if (this.launchcondition != null && this.launchcondition.length() > 0) {
            element.setAttribute(ATTR_LAUNCHCONDITION, this.launchcondition);
        }
        if (this.permission_type != null && this.permission_type.length() > 0) {
            element.setAttribute(ATTR_PERMISSION_TYPE, this.permission_type);
        }
        if (this.component_type != null && this.component_type.length() > 0) {
            element.setAttribute(ATTR_COMPONENT_TYPE, this.component_type);
        }
        if (this.submode != null && this.submode.length() > 0) {
            element.setAttribute(ATTR_SUBMODE, this.submode);
        }
        if (this.submode_mainid != null && this.submode_mainid.length() > 0) {
            element.setAttribute(ATTR_SUBMODE_MAINID, this.submode_mainid);
        }
        if (this.process_pool != null && this.process_pool.length() > 0) {
            element.setAttribute(ATTR_PROCESS_POOL, this.process_pool);
        }
        if (this.getAuto_restart() != null && this.getAuto_restart().length() > 0 && !this.getAuto_restart().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_AUTO_RESTART, this.getAuto_restart());
        }
        if (this.getOn_boot() != null && this.getOn_boot().length() > 0 && !this.getOn_boot().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_ON_BOOT, this.getOn_boot());
        }
        if (this.multi_instance != null && this.multi_instance.length() > 0) {
            element.setAttribute(ATTR_MULTI_INSTANCE, this.multi_instance);
        }
        if (this.multi_instance_mainid != null && this.multi_instance_mainid.length() > 0) {
            element.setAttribute(ATTR_MULTI_INSTANCE_MAINID, this.multi_instance_mainid);
        }
        if (this.getUiGadget() != null && this.getUiGadget().length() > 0 && !this.getUiGadget().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_UIGADGET, this.getUiGadget());
        }
        if (this.launch_mode != null && this.launch_mode.length() > 0 && !this.launch_mode.equals(Constants.LAUNCH_MODE_VALUES[0])) {
            element.setAttribute(ATTR_LAUNCH_MODE, this.launch_mode);
        }
        if (this.getSplashScreenDisplay() != null) {
            element.setAttribute(ATTR_SPLASH_SCREEN_DISPLAY, this.getSplashScreenDisplay());
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        this.generateLabels(dom, element);
        this.generateIcons(dom, element);
        if (this.image != null) {
            this.image.generateElement(dom, element);
        }
        if (this.appServiceList != null) {
            for (AppControl appControl : this.appServiceList) {
                appControl.generateElement(dom, element);
            }
        }
        if (this.getCategory_map().size() > 0) {
            Collection<Category> collection = this.getCategory_map().values();
            Iterator<Object> Ir_values = collection.iterator();
            while (Ir_values.hasNext()) {
                ((Category)Ir_values.next()).generateElement(dom, element);
            }
        }
        for (Metadata metadata : this.getMetadataList()) {
            if (metadata == null) continue;
            metadata.generateElement(dom, element);
        }
        if (this.permission != null) {
            this.permission.generateElement(dom, element);
        }
        for (DataControl dataControl : this.getDataControlList()) {
            if (dataControl == null) continue;
            dataControl.generateElement(dom, element);
        }
        for (BackgroundCategory backgroundCategory : this.getBgCategoryList()) {
            if (backgroundCategory == null) continue;
            backgroundCategory.generateElement(dom, element);
        }
        if (this.splash_list != null && this.splash_list.size() > 0) {
            Element element2 = dom.createElement("splash-screens");
            element.appendChild(element2);
            int i = 0;
            while (i < this.splash_list.size()) {
                this.splash_list.get(i).generateElement(dom, element2);
                ++i;
            }
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    @Override
    public String getExec() {
        return this.exec;
    }

    @Override
    public void setExec(String exec) {
        this.exec = exec;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public List<AppControl> getAppServiceList() {
        if (this.appServiceList == null) {
            this.appServiceList = new ArrayList<AppControl>();
        }
        return this.appServiceList;
    }

    @Override
    public void setAppServiceList(List<AppControl> application_service) {
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    public String getMultiple() {
        return this.multiple;
    }

    public String getNodisplay() {
        return this.nodisplay;
    }

    public String getTaskmanage() {
        return this.taskmanage;
    }

    public String getAuto_restart() {
        return this.auto_restart;
    }

    public String getOn_boot() {
        return this.on_boot;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public Map<String, Category> getCategory_map() {
        return this.category_map;
    }

    public void setCategory_map(Map<String, Category> category_map) {
        this.category_map = category_map;
    }

    public void setMultiple(String multiple) {
        this.multiple = multiple;
    }

    public void setNodisplay(String nodisplay) {
        this.nodisplay = nodisplay;
    }

    public void setTaskmanage(String taskmanage) {
        this.taskmanage = taskmanage;
    }

    public void setAuto_restart(String auto_restart) {
        this.auto_restart = auto_restart;
    }

    public void setOn_boot(String on_boot) {
        this.on_boot = on_boot;
    }

    public String getMulti_instance() {
        return this.multi_instance;
    }

    public void setMulti_instance(String multi_instance) {
        this.multi_instance = multi_instance;
    }

    public String getUiGadget() {
        return this.ui_gadget;
    }

    public void setUiGadget(String ui_gadget) {
        this.ui_gadget = ui_gadget;
    }

    @Override
    public List<Metadata> getMetadataList() {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList<Metadata>();
        }
        return this.metadataList;
    }

    public List<DataControl> getDataControlList() {
        if (this.datacontrolList == null) {
            this.datacontrolList = new ArrayList<DataControl>();
        }
        return this.datacontrolList;
    }

    @Override
    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public void setDefaultLabel(Label defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public List<LocaledValue> getLabels() {
        return this.label_list;
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.getLabels();
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    @Override
    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public List<LocaledValue> getIcons() {
        return this.icon_list;
    }

    private void generateIcons(Document dom, Element parent) {
        List<LocaledValue> icons = this.getIcons();
        if (icons.isEmpty() && this.defaultIcon == null) {
            return;
        }
        if (this.defaultIcon != null) {
            Element eIcon = dom.createElement("icon");
            eIcon.setTextContent(this.defaultIcon.getValue());
            parent.appendChild(eIcon);
        }
        for (LocaledValue lv : icons) {
            Element eIcon = dom.createElement("icon");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eIcon.setAttribute("xml:lang", lv.getLocale());
            }
            if (lv.getDpi() != null && lv.getDpi().length() > 0) {
                eIcon.setAttribute("dpi", lv.getDpi());
            }
            eIcon.setTextContent(lv.getValue());
            parent.appendChild(eIcon);
        }
    }

    public String getHw_acceleration() {
        return this.hw_acceleration;
    }

    public void setHw_acceleration(String hw_acceleration) {
        this.hw_acceleration = hw_acceleration;
    }

    @Override
    public List<BackgroundCategory> getBgCategoryList() {
        if (this.bgCategoryList == null) {
            this.bgCategoryList = new ArrayList<BackgroundCategory>();
        }
        return this.bgCategoryList;
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_APPID)) {
            return false;
        }
        if (attr.equals(ATTR_AUTO_RESTART)) {
            return false;
        }
        if (attr.equals(ATTR_CATEGORIES)) {
            return false;
        }
        if (attr.equals(ATTR_COMPONENT_TYPE)) {
            return false;
        }
        if (attr.equals(ATTR_EFFECTIMAGE_TYPE)) {
            return false;
        }
        if (attr.equals(ATTR_ENABLED)) {
            return false;
        }
        if (attr.equals(ATTR_EXEC)) {
            return false;
        }
        if (attr.equals(ATTR_EXTRAID)) {
            return false;
        }
        if (attr.equals(ATTR_GUESTMODE_VISIBILITY)) {
            return false;
        }
        if (attr.equals(ATTR_HW_ACCELERATION)) {
            return false;
        }
        if (attr.equals(ATTR_INDICATORDISPLAY)) {
            return false;
        }
        if (attr.equals(ATTR_LANDSCAPE_EFFECTIMAGE)) {
            return false;
        }
        if (attr.equals(ATTR_LAUNCHCONDITION)) {
            return false;
        }
        if (attr.equals(ATTR_LAUNCH_MODE)) {
            return false;
        }
        if (attr.equals(ATTR_MAINAPP)) {
            return false;
        }
        if (attr.equals(ATTR_MULTI_INSTANCE)) {
            return false;
        }
        if (attr.equals(ATTR_MULTI_INSTANCE_MAINID)) {
            return false;
        }
        if (attr.equals(ATTR_MULTIPLE)) {
            return false;
        }
        if (attr.equals(ATTR_NODISPLAY)) {
            return false;
        }
        if (attr.equals(ATTR_ON_BOOT)) {
            return false;
        }
        if (attr.equals(ATTR_PERMISSION_TYPE)) {
            return false;
        }
        if (attr.equals(ATTR_PORTRAIT_EFFECTIMAGE)) {
            return false;
        }
        if (attr.equals(ATTR_PROCESS_POOL)) {
            return false;
        }
        if (attr.equals(ATTR_RECENTIMAGE)) {
            return false;
        }
        if (attr.equals(ATTR_SCREEN_READER)) {
            return false;
        }
        if (attr.equals(ATTR_SUBMODE)) {
            return false;
        }
        if (attr.equals(ATTR_SUBMODE_MAINID)) {
            return false;
        }
        if (attr.equals(ATTR_TASKMANAGE)) {
            return false;
        }
        if (attr.equals(ATTR_TYPE)) {
            return false;
        }
        if (attr.equals(ATTR_UIGADGET)) {
            return false;
        }
        if (attr.equals(ATTR_SPLASH_SCREEN_DISPLAY)) {
            return false;
        }
        return !attr.equals("api-version");
    }

    public String getLaunch_mode() {
        return this.launch_mode;
    }

    public void setLaunch_mode(String launch_mode) {
        this.launch_mode = launch_mode;
    }

    public List<TizenSplashScreen> getSplashScreenList() {
        return this.splash_list;
    }

    public void setSplashScreenList(TizenSplashScreen sscreen) {
        this.splash_list.add(sscreen);
    }

    public String getSplashScreenDisplay() {
        return this.splashScreenDisplay;
    }

    public void setSplashScreenDisplay(String splashScreenDisplay) {
        this.splashScreenDisplay = splashScreenDisplay;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

