/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.util.ArrayList;
import java.util.List;

public class SSIRuleOp {
    public static int OP_NONE = 0;
    public static int OP_EQ = 1;
    public static int OP_NOTEQ = 2;
    public static int OP_LT = 3;
    public static int OP_LE = 4;
    public static int OP_GT = 5;
    public static int OP_GE = 6;
    public static int OP_AND = 7;
    public static int OP_OR = 8;
    public int baseOp = OP_NONE;
    public String lt;
    public int op;
    public String rt;

    public SSIRuleOp(int baseOp, String lt, String op, String rt) {
        this.baseOp = baseOp;
        this.setRule(lt, op, rt);
    }

    public SSIRuleOp(String lt, String op, String rt) {
        this.setRule(lt, op, rt);
    }

    public SSIRuleOp(String fullRuleStr) {
        this.setRule(fullRuleStr);
    }

    public SSIRuleOp(int baseOp, String fullRuleStr) {
        this.baseOp = baseOp;
        this.setRule(fullRuleStr);
    }

    private static String[] parseRule(String ruleStr) {
        if (ruleStr == null) {
            return null;
        }
        StringBuilder lt = new StringBuilder();
        StringBuilder op = new StringBuilder();
        StringBuilder rt = new StringBuilder();
        int mode = 0;
        int len = ruleStr.length();
        for (int i = 0; i < len; ++i) {
            char ch = ruleStr.charAt(i);
            if (mode == 0) {
                if (ch == '=' || ch == '!' || ch == '>' || ch == '<') {
                    op.append(ch);
                    mode = 1;
                    continue;
                }
                lt.append(ch);
                continue;
            }
            if (mode == 1) {
                if (ch == '=' || ch == '!' || ch == '>' || ch == '<') {
                    op.append(ch);
                    continue;
                }
                rt.append(ch);
                mode = 2;
                continue;
            }
            if (mode != 2) continue;
            rt.append(ch);
        }
        if (lt.length() == 0) {
            return null;
        }
        if (op.length() == 0) {
            return new String[]{lt.toString()};
        }
        if (rt.length() == 0) {
            return new String[]{lt.toString(), op.toString()};
        }
        return new String[]{lt.toString(), op.toString(), rt.toString()};
    }

    public void setRule(String fullRuleStr) {
        String rt;
        String op;
        String lt;
        String[] rules = SSIRuleOp.parseRule(fullRuleStr);
        if (rules != null) {
            int len = rules.length;
            lt = len > 0 ? rules[0] : null;
            op = len > 1 ? rules[1] : null;
            rt = len > 2 ? rules[2] : null;
        } else {
            rt = null;
            op = null;
            lt = null;
        }
        this.setRule(lt, op, rt);
    }

    public void setRule(String lt, String op, String rt) {
        int op2 = 0;
        if (op != null) {
            if (op.equals("=")) {
                op2 = OP_EQ;
            } else if (op.equals("!=")) {
                op2 = OP_NOTEQ;
            } else if (op.equals("<")) {
                op2 = OP_LT;
            } else if (op.equals("<=")) {
                op2 = OP_LE;
            } else if (op.equals(">")) {
                op2 = OP_GT;
            } else if (op.equals(">=")) {
                op2 = OP_GE;
            }
        }
        this.setRule(lt, op2, rt);
    }

    public void setRule(String lt, int op, String rt) {
        this.lt = lt;
        this.op = op;
        this.rt = rt;
    }

    public String getLt() {
        return this.lt;
    }

    public boolean isMatch(String rtValue) {
        if (this.rt == null || this.op == 0) {
            return true;
        }
        if (this.op == OP_EQ) {
            return this.rt.equals(rtValue);
        }
        if (this.op == OP_NOTEQ) {
            return !this.rt.equals(rtValue);
        }
        if (this.op == OP_LT) {
            return this.rt.compareTo(rtValue) < 0;
        }
        if (this.op == OP_LE) {
            return this.rt.compareTo(rtValue) <= 0;
        }
        if (this.op == OP_GT) {
            return this.rt.compareTo(rtValue) > 0;
        }
        if (this.op == OP_GE) {
            return this.rt.compareTo(rtValue) >= 0;
        }
        return false;
    }

    public boolean isMatch(String[] rtValues) {
        if (this.rt == null || this.op == 0) {
            return true;
        }
        if (this.op == OP_EQ) {
            for (String rtValue : rtValues) {
                if (!this.rt.equals(rtValue)) continue;
                return true;
            }
        } else if (this.op == OP_NOTEQ) {
            for (String rtValue : rtValues) {
                if (!this.rt.equals(rtValue)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<SSIRuleOp> parseFullRule(String fullRuleStr) {
        if (fullRuleStr == null) {
            return null;
        }
        String lt = "";
        int op = OP_NONE;
        ArrayList<SSIRuleOp> list = null;
        int len = fullRuleStr.length();
        for (int i = 0; i < len; ++i) {
            char ch = fullRuleStr.charAt(i);
            if (ch == '&' || ch == '|') {
                if (!lt.isEmpty()) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(new SSIRuleOp(op, lt));
                    lt = "";
                }
                if (ch == '&') {
                    op = OP_AND;
                    continue;
                }
                if (ch != '|') continue;
                op = OP_OR;
                continue;
            }
            lt = lt + ch;
        }
        if (!lt.isEmpty()) {
            if (list == null) {
                list = new ArrayList<SSIRuleOp>();
            }
            list.add(new SSIRuleOp(op, lt));
        }
        return list;
    }
}

