/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStarter;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameRefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class RenameSupport {
    public static final int NONE = 0;
    public static final int UPDATE_REFERENCES = 1;
    public static final int UPDATE_TEXTUAL_MATCHES = 64;
    public static final int UPDATE_GETTER_METHOD = 16;
    public static final int UPDATE_SETTER_METHOD = 32;
    private static final String ERROR_PAGE_NAME = "ErrorPage";
    private CRenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return this.fPreCheckStatus.getEntryMatchingSeverity(4).toStatus();
        }
        return Status.OK_STATUS;
    }

    public boolean openDialog(Shell shell) throws CoreException {
        return this.openDialog(shell, false);
    }

    public boolean openDialog(Shell shell, boolean showPreviewOnly) throws CoreException {
        DialogMode mode;
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            RenameSupport.showInformation(shell, this.fPreCheckStatus);
            return false;
        }
        DialogMode dialogMode = mode = showPreviewOnly ? DialogMode.PREVIEW_ONLY : DialogMode.ALL_PAGES;
        return RenameSupport.openDialog(shell, this.fRefactoring, mode) == DialogResult.OK;
    }

    public static void openDialog(Shell shell, CRenameRefactoring refactoring) {
        RenameSupport.openDialog(shell, refactoring, DialogMode.ALL_PAGES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static DialogResult openDialog(Shell shell, CRenameRefactoring refactoring, final DialogMode mode) {
        try {
            CRenameRefactoringWizard wizard;
            final boolean[] dialogSkipped = new boolean[1];
            if (mode == DialogMode.ALL_PAGES) {
                wizard = new CRenameRefactoringWizard(refactoring);
            } else {
                wizard = new CRenameRefactoringWizard(refactoring){

                    @Override
                    protected void addUserInputPages() {
                    }

                    public IWizardPage getStartingPage() {
                        IWizardPage startingPage = super.getStartingPage();
                        if (mode == DialogMode.CONDITIONAL_PREVIEW && !startingPage.getName().equals(RenameSupport.ERROR_PAGE_NAME)) {
                            dialogSkipped[0] = true;
                            return null;
                        }
                        return startingPage;
                    }
                };
                wizard.setForcePreviewReview(mode != DialogMode.ALL_PAGES);
            }
            RefactoringStarter starter = new RefactoringStarter();
            CRenameProcessor processor = refactoring.getProcessor();
            processor.lockIndex();
            try {
                RefactoringStatus status = processor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (status.hasFatalError()) {
                    RenameSupport.showInformation(shell, status);
                    DialogResult dialogResult = DialogResult.CANCELED;
                    return dialogResult;
                }
                if (starter.activate(wizard, shell, RenameMessages.CRefactory_title_rename, processor.getSaveMode())) {
                    DialogResult dialogResult = DialogResult.OK;
                    return dialogResult;
                }
                if (!dialogSkipped[0]) return DialogResult.CANCELED;
                wizard.getContainer().getShell().close();
                DialogResult dialogResult = DialogResult.SKIPPED;
                return dialogResult;
            }
            finally {
                processor.unlockIndex();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return DialogResult.CANCELED;
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        return DialogResult.CANCELED;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean perform(Shell parent, IWorkbenchWindow context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                RenameSupport.showInformation(parent, this.fPreCheckStatus);
                return false;
            }
            CRenameProcessor renameProcessor = this.fRefactoring.getProcessor();
            renameProcessor.lockIndex();
            try {
                this.fPreCheckStatus = renameProcessor.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
                if (this.fPreCheckStatus.hasFatalError()) {
                    RenameSupport.showInformation(parent, this.fPreCheckStatus);
                    return false;
                }
                DialogResult result = RenameSupport.openDialog(context.getShell(), this.fRefactoring, DialogMode.CONDITIONAL_PREVIEW);
                switch (result) {
                    case OK: {
                        return true;
                    }
                    case SKIPPED: {
                        RefactoringExecutionHelper helper = new RefactoringExecutionHelper((Refactoring)this.fRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), renameProcessor.getSaveMode(), parent, (IRunnableContext)context);
                        Change change = this.fRefactoring.getChange();
                        Assert.isNotNull((Object)change);
                        helper.performChange(change, true);
                        return true;
                    }
                }
                return false;
            }
            finally {
                renameProcessor.unlockIndex();
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RenameSupport(CRenameProcessor processor) {
        this.fRefactoring = new CRenameRefactoring(processor);
    }

    public static RenameSupport create(CRenameProcessor processor) throws CoreException {
        return new RenameSupport(processor);
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)RenameMessages.RenameSupport_not_available) : new RefactoringStatus();
        }
    }

    private static void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)RenameMessages.RenameSupport_dialog_title, (String)message);
    }

    private static enum DialogMode {
        ALL_PAGES,
        PREVIEW_ONLY,
        CONDITIONAL_PREVIEW;

    }

    private static enum DialogResult {
        OK,
        CANCELED,
        SKIPPED;

    }
}

