/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;

public class NativeCoreProjectDependentBuilder
extends CommonProjectDependentBuilder {
    private final Logger logger = LoggerFactory.getLogger(NativeCoreProjectDependentBuilder.class);
    private static NativeCoreProjectDependentBuilder instance = new NativeCoreProjectDependentBuilder();

    public static final CommonProjectDependentBuilder getInstance() {
        return instance;
    }

    public static final CommonProjectDependentBuilder getInstance(IProject project) {
        instance.setProject(project);
        return instance;
    }

    private NativeCoreProjectDependentBuilder() {
    }

    private NativeCoreProjectDependentBuilder(IProject project) {
        super(project);
    }

    protected String getElfInfoOption() {
        String workingDir = this.getWorkingDir();
        String projectName = this.getProject().getName();
        String binaryPath = String.valueOf(workingDir) + File.separatorChar + projectName;
        Path path = new Path(binaryPath);
        if (!path.toFile().exists()) {
            return "";
        }
        String options = String.format("-exec_path=\"%s\"", new Path(binaryPath).toPortableString());
        return options;
    }

    protected String getConfigureOption() {
        return "";
    }

    protected String getMakeOption() {
        return "";
    }

    protected String getCleanOption() {
        return "";
    }

    public String getTargetID() {
        IConfiguration config = this.getConfiguration();
        return NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    public String getTargetID(IConfiguration config) {
        return NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
    }

    public void setBuildTargetID(IConfiguration config, String targetId) {
        NativeCoreConfigurationManager.setBuildTargetName((IConfiguration)config, (String)targetId);
    }

    public void setToolCommand(IConfiguration config) {
        NativeCoreConfigurationManager.setToolCommand((IConfiguration)config);
    }

    public void changeToolchain(IConfiguration config, String targetId) {
        NativeCoreConfigurationManager.changeToolchain(config, targetId);
    }

    protected String getDebugOption(String[] arrOption) {
        String gdbOptions = "-gdb-options='";
        int i = 0;
        while (i < arrOption.length) {
            if (arrOption[i] != null) {
                gdbOptions = gdbOptions.concat(String.valueOf(arrOption[i]) + " ");
            }
            ++i;
        }
        gdbOptions = gdbOptions.concat("' ");
        String sysroot = "";
        String debugInfoOption = "";
        try {
            String sysrootPath = this.getSbi().getRootstrapPath(this.getTargetID());
            sysroot = String.format("-sysroot=%s", sysrootPath);
            debugInfoOption = String.format(" -debug-file-directory=%s", String.valueOf(sysrootPath) + DEBUG_INFO_PATH);
        }
        catch (SBIException e) {
            this.logger.error("Problem occurred while setting debug option", (Throwable)e);
        }
        return String.valueOf(gdbOptions) + sysroot + debugInfoOption;
    }
}

