/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.tizen.nativecommon.rm.model.TizenLocale;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.xmlstore.CoreXMLStore;
import org.tizen.nativecore.misc.core.PrivilegeLevel;
import org.tizen.nativecore.misc.core.PrivilegeManager;
import org.tizen.nativecore.misc.editor.CoreAdvancedPage;
import org.tizen.nativecore.misc.editor.CoreLocalizationPage;
import org.tizen.nativecore.misc.editor.CoreOverviewPage;
import org.tizen.nativecore.misc.editor.FeaturesPage;
import org.tizen.nativecore.misc.editor.ManifestSchemaValidator;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.POFile;
import org.tizen.nativecore.misc.editor.PrivilegePage;
import org.tizen.nativecore.misc.utils.Constants;
import org.tizen.nativecore.misc.utils.PositionalXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestEditor
extends FormEditor
implements IResourceChangeListener {
    public static final String MANIFEST_MARKER_ID = "org.tizen.nativecore.misc.manifestProblem";
    public static final String FOLDER_PATH = "/res/po";
    public static final String TRUST_ANCHOR_FOLDER_PATH = "/res/.trust-anchor";
    public static final int TRUNCATION_LENGTH = 3;
    private boolean lastDirtyState;
    private IFileBufferListener fFileBufferListener = null;
    private IFileBufferManager manager = null;
    private IPath fullPath = null;
    private String fOldAppVersion;
    private int fTextEditorPageIndex;
    private ModelStateListener fXmlStateListener;
    private Manifest coreManifest;
    private CoreXMLStore coreXmlManager;
    private CoreOverviewPage fCoreOverviewPage;
    private CoreAdvancedPage fCoreAdvancedPage;
    private PrivilegePage fCorePrivilegePage;
    private FeaturesPage fCoreFeaturesPage;
    private CoreLocalizationPage fCoreLocalizationPage;
    private StructuredTextEditor fTextEditor;

    public ManifestEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void createPages() {
        super.createPages();
        this.execute(new Runnable(){

            @Override
            public void run() {
                final IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    final IViewReference[] views = workbenchWindow.getActivePage().getViewReferences();
                    IWorkbenchPage page = views[0].getPage();
                    page.addSelectionListener(new ISelectionListener(){

                        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                            if (selection.toString().contains("tizen-manifest.xml")) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            if (System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0 || System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
                                                workbenchWindow.getActivePage().showView(views[0].getId());
                                            }
                                        }
                                        catch (PartInitException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        }, true);
    }

    public void dispose() {
        block10: {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            if (this.fXmlStateListener != null) {
                IStructuredModel smodel = null;
                try {
                    try {
                        smodel = this.getModelForRead();
                        if (smodel != null) {
                            smodel.removeModelStateListener((IModelStateListener)this.fXmlStateListener);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (smodel != null) {
                            smodel.releaseFromRead();
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (smodel != null) {
                        smodel.releaseFromRead();
                    }
                    throw throwable;
                }
                if (smodel != null) {
                    smodel.releaseFromRead();
                }
            }
        }
        super.dispose();
    }

    protected void addPages() {
        IProject prj = this.getProject();
        if (!this.checkSanity(prj)) {
            return;
        }
        this.coreXmlManager = new CoreXMLStore(prj);
        this.coreXmlManager.loadXml();
        this.coreManifest = this.coreXmlManager.getCoreManifest();
        this.fOldAppVersion = this.coreManifest.getVersion();
        this.fCoreOverviewPage = new CoreOverviewPage(this);
        this.fCoreAdvancedPage = new CoreAdvancedPage(this);
        this.fCorePrivilegePage = new PrivilegePage(this);
        this.fCoreFeaturesPage = new FeaturesPage(this);
        this.fCoreLocalizationPage = new CoreLocalizationPage(this);
        try {
            this.addPage((IFormPage)this.fCoreOverviewPage);
            this.addPage((IFormPage)this.fCoreFeaturesPage);
            this.addPage((IFormPage)this.fCorePrivilegePage);
            this.addPage((IFormPage)this.fCoreLocalizationPage);
            this.addPage((IFormPage)this.fCoreAdvancedPage);
            this.createTextEditor();
            this.validateSchema();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private boolean checkSanity(IProject prj) {
        if (prj == null) {
            return false;
        }
        String projPath = prj.getLocation().toString();
        String manifestPath = String.valueOf(projPath) + File.separator + "tizen-manifest.xml";
        File manifest = new File(manifestPath);
        if (!manifest.exists()) {
            this.close(false);
            return false;
        }
        return true;
    }

    private void createTextEditor() {
        try {
            this.fTextEditor = new StructuredTextEditor();
            this.fTextEditorPageIndex = this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
            this.setPageText(this.fTextEditorPageIndex, "Source");
            IStructuredModel smodel = null;
            try {
                try {
                    smodel = this.getModelForRead();
                    this.fXmlStateListener = new ModelStateListener();
                    smodel.addModelStateListener((IModelStateListener)this.fXmlStateListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (smodel != null) {
                        smodel.releaseFromRead();
                    }
                }
            }
            finally {
                if (smodel != null) {
                    smodel.releaseFromRead();
                }
            }
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Tizen Manifest Editor error", null, (IStatus)e.getStatus());
        }
    }

    public void xmlModelChanged(Document doc) {
        try {
            this.runChecker();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateModel();
    }

    private void updateModel() {
        this.fCoreOverviewPage.setDirty(true);
        this.updateUIFromXml();
        this.fCoreOverviewPage.setDirty(false);
    }

    private IStructuredModel getModelForRead() throws IOException, CoreException {
        IModelManager mm = StructuredModelManager.getModelManager();
        return mm.getModelForRead(((FileEditorInput)this.getEditorInput()).getFile());
    }

    public IStructuredDocument getStructuredDocument() {
        if (this.fTextEditor != null && this.fTextEditor.getTextViewer() != null) {
            return (IStructuredDocument)this.fTextEditor.getTextViewer().getDocument();
        }
        return null;
    }

    public Document getXmlDocument(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        if (model instanceof IDOMModel) {
            IDOMModel dom = (IDOMModel)model;
            return dom.getDocument();
        }
        return null;
    }

    protected void setActivePage(int index) {
        super.setActivePage(index);
    }

    protected void pageChange(int newPageIndex) {
        int page = this.getCurrentPage();
        if (page == this.fTextEditorPageIndex) {
            this.updateUIFromXml();
        }
        if (newPageIndex == this.fTextEditorPageIndex) {
            this.updateXmlFromUI();
        }
        super.pageChange(newPageIndex);
    }

    public Manifest getCoreManifest() {
        return this.coreManifest;
    }

    public void setCoreManifest(Manifest coreManifest) {
        this.coreManifest = coreManifest;
    }

    public void doSave(IProgressMonitor monitor) {
        String newAppVersion;
        File dir;
        int page = this.getCurrentPage();
        if (!(this.fCoreOverviewPage == null || this.fCoreOverviewPage.IsValidAPIVersion && this.fCoreOverviewPage.IsValidAppId && this.fCoreOverviewPage.IsValidExe && this.fCoreOverviewPage.IsValidPackage && this.fCoreOverviewPage.IsValidVersion)) {
            String msg = "Overview Tab contains Error.Try after Fixing the same!";
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Save Error", (String)msg);
            return;
        }
        if (this.coreManifest.getTrustAnchor() != null && this.coreManifest.getTrust_anchor_path() != null && this.coreManifest.getTrust_anchor_path().isEmpty() && !(dir = new File(this.getProject().getLocation().append(TRUST_ANCHOR_FOLDER_PATH).toString())).exists()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Save Error", (String)Messages.AdvancedPage_save_error);
            return;
        }
        if (page != this.fTextEditorPageIndex) {
            IFormPage activePage = this.getActivePageInstance();
            if (activePage != null) {
                String m = activePage.getManagedForm().getForm().getMessage();
                if (m != null) {
                    String msg = "This tab contains error(s). after fixing them, try again!";
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Save Error", (String)msg);
                    return;
                }
                this.updateXmlFromUI();
            }
        } else {
            this.updateUIFromXml();
        }
        this.fTextEditor.doSave(monitor);
        try {
            this.runChecker();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        IApplication app = this.coreManifest.getDefaultApp();
        if (app == null) {
            return;
        }
        String entry = app.getExec();
        if (entry == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
        String entryCDT = configuration.getArtifactName();
        if (!entry.equals(entryCDT)) {
            configuration.setArtifactName(entry);
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        }
        if (!this.fOldAppVersion.equals(newAppVersion = this.coreManifest.getVersion())) {
            IFile res;
            IFolder f = project.getFolder("setting");
            if (f != null && f.exists() && (res = f.getFile("setting." + this.fOldAppVersion + ".xml")).exists()) {
                try {
                    String newPath = "setting." + newAppVersion + ".xml";
                    res.move((IPath)new Path(newPath), true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.fOldAppVersion = newAppVersion;
        }
        if (this.fCoreFeaturesPage != null) {
            this.fCoreFeaturesPage.setDirty(false);
        }
        if (this.fCorePrivilegePage != null) {
            this.fCorePrivilegePage.setDirty(false);
        }
        if (this.fCoreOverviewPage != null) {
            this.fCoreOverviewPage.setDirty(false);
        }
        if (this.fCoreAdvancedPage != null) {
            this.fCoreAdvancedPage.setDirty(false);
        }
        if (this.fCoreLocalizationPage != null) {
            this.fCoreLocalizationPage.setDirty(false);
        }
        this.copyUserCetificates();
    }

    private void runChecker() throws CoreException, ParserConfigurationException, SAXException, IOException {
        IProject prj = this.getProject();
        if (prj == null) {
            return;
        }
        IFile res = prj.getFile("tizen-manifest.xml");
        assert (res.exists());
        res.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        PositionalXmlParser parser = new PositionalXmlParser();
        Document doc = null;
        doc = parser.parse(this.fTextEditor.getDocumentProvider().getDocument((Object)this.getEditorInput()).get());
        IFile configFile = null;
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            configFile = ((IFileEditorInput)input).getFile();
            ManifestSchemaValidator msv = new ManifestSchemaValidator();
            String schemaFile = "manifest_core.xsd";
            String apiVersion = this.coreManifest.getApiVersion();
            if (apiVersion.equalsIgnoreCase("5.0")) {
                schemaFile = "manifest_5.0.xsd";
            } else if (apiVersion.equalsIgnoreCase("4.0")) {
                schemaFile = "manifest_4.0.xsd";
            } else if (apiVersion.equalsIgnoreCase("3.0")) {
                schemaFile = "manifest_3.0.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.4")) {
                schemaFile = "manifest_2.4.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.3.2")) {
                schemaFile = "manifest_2.3.2.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.3.1")) {
                schemaFile = "manifest_2.3.1.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.3")) {
                schemaFile = "manifest_2.3.xsd";
            }
            msv.validateConfigurationDocument(configFile, new String[]{"xml.xsd", schemaFile});
        }
        NodeList nodes = doc.getElementsByTagName("privilege");
        int i = 0;
        while (i < nodes.getLength()) {
            PrivilegeManager privilegeManager;
            PrivilegeLevel level;
            Element e = (Element)nodes.item(i);
            if (this.fCorePrivilegePage != null && (level = (privilegeManager = this.fCorePrivilegePage.getPrivilegeManager()).getPrivilegeLevel(e.getTextContent())) != PrivilegeLevel.PUBLIC) {
                PositionalXmlParser.NodePosition pos = parser.getPosition(e);
                IMarker marker = res.createMarker(MANIFEST_MARKER_ID);
                marker.setAttribute("message", (Object)("This privilege requires " + level.getName().toLowerCase() + " level signing key."));
                marker.setAttribute("lineNumber", pos.getStartLine() + 1);
                marker.setAttribute("severity", 1);
                marker.setAttribute("charStart", pos.getStart());
                marker.setAttribute("charEnd", pos.getEnd());
            }
            ++i;
        }
        this.validatePackage(doc, (IResource)res, parser);
    }

    private void createErrorMarker(PositionalXmlParser parser, IResource res, Element e, String errorMessage) throws CoreException {
        PositionalXmlParser.NodePosition pos = parser.getPosition(e);
        IMarker marker = res.createMarker(MANIFEST_MARKER_ID);
        marker.setAttribute("message", (Object)errorMessage);
        marker.setAttribute("lineNumber", pos.getStartLine() + 1);
        marker.setAttribute("severity", 2);
        marker.setAttribute("charStart", pos.getStart());
    }

    private void validatePackage(Document doc, IResource res, PositionalXmlParser parser) throws CoreException {
        Element manifest = doc.getDocumentElement();
        String packName = manifest.getAttribute("package");
        if (packName.length() > Constants.MAX_PKGID_LENGTH || packName.length() < Constants.MIN_PKGID_LENGTH) {
            PositionalXmlParser.NodePosition pos = parser.getPosition(manifest);
            IMarker marker = res.createMarker(MANIFEST_MARKER_ID);
            marker.setAttribute("message", (Object)Constants.pkgIDErrorMsg);
            marker.setAttribute("lineNumber", pos.getStartLine() + 1);
            marker.setAttribute("severity", 2);
            marker.setAttribute("charStart", pos.getStart());
        }
        NodeList uiApps = manifest.getElementsByTagName("ui-application");
        int i = 0;
        while (i < uiApps.getLength()) {
            Element e = (Element)uiApps.item(i);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                this.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                this.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                this.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                this.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i;
        }
        NodeList serviceApps = manifest.getElementsByTagName("service-application");
        int i2 = 0;
        while (i2 < serviceApps.getLength()) {
            Element e = (Element)serviceApps.item(i2);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                this.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                this.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                this.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                this.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i2;
        }
        NodeList watchApps = manifest.getElementsByTagName("watch-application");
        int i3 = 0;
        while (i3 < watchApps.getLength()) {
            Element e = (Element)watchApps.item(i3);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                this.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                this.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                this.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                this.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i3;
        }
        NodeList widgetApps = manifest.getElementsByTagName("widget-application");
        int i4 = 0;
        while (i4 < widgetApps.getLength()) {
            Element e = (Element)widgetApps.item(i4);
            if (!e.getAttribute("appid").startsWith(String.valueOf(packName) + ".") && !e.getAttribute("appid").equals(packName)) {
                this.createErrorMarker(parser, res, e, "'appid' does not contain 'package' value");
            }
            if (e.getAttribute("appid").length() > Constants.MAX_APPID_LENGTH || e.getAttribute("appid").length() < Constants.MIN_APPID_LENGTH) {
                this.createErrorMarker(parser, res, e, Constants.appIDErrorMsg);
            }
            if (!e.getAttribute("appid").matches("^[a-zA-Z0-9\\.\\-_]{1,50}$")) {
                this.createErrorMarker(parser, res, e, "'appid' is not valid");
            }
            if (!e.getAttribute("exec").matches("[a-z0-9\\-_.]*")) {
                this.createErrorMarker(parser, res, e, "'exec' cannot contain uppercase letters");
            }
            ++i4;
        }
    }

    private void validateSchema() {
        IFile configFile;
        IProject prj = this.getProject();
        if (prj != null && (configFile = prj.getFile("tizen-manifest.xml")) != null) {
            ManifestSchemaValidator msv = new ManifestSchemaValidator();
            String schemaFile = "manifest_core.xsd";
            String apiVersion = this.coreManifest.getApiVersion();
            if (apiVersion.equalsIgnoreCase("5.0")) {
                schemaFile = "manifest_5.0.xsd";
            } else if (apiVersion.equalsIgnoreCase("4.0")) {
                schemaFile = "manifest_4.0.xsd";
            } else if (apiVersion.equalsIgnoreCase("3.0")) {
                schemaFile = "manifest_3.0.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.4")) {
                schemaFile = "manifest_2.4.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.3.2")) {
                schemaFile = "manifest_2.3.2.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.3.1")) {
                schemaFile = "manifest_2.3.1.xsd";
            } else if (apiVersion.equalsIgnoreCase("2.3")) {
                schemaFile = "manifest_2.3.xsd";
            }
            msv.validateConfigurationDocument(configFile, new String[]{"xml.xsd", schemaFile});
        }
    }

    public boolean isDirty() {
        this.lastDirtyState = this.computeDirtyState();
        return this.lastDirtyState;
    }

    public boolean getLastDirtyState() {
        return this.lastDirtyState;
    }

    public boolean computeDirtyState() {
        IFormPage page = this.getActivePageInstance();
        if (page != null && page.isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void updatePages() {
        if (!this.isDirty()) {
            return;
        }
        Manifest coreManifest = this.getCoreManifest();
        if (coreManifest != null && this.fCoreAdvancedPage != null) {
            this.fCoreAdvancedPage.update(coreManifest);
        }
    }

    public void updateUIFromXml() {
        if (!this.isDirty()) {
            return;
        }
        IDocument doc = this.fTextEditor.getDocumentProvider().getDocument((Object)this.getEditorInput());
        boolean loadModel = false;
        loadModel = this.coreXmlManager.getManifestHandler().parseXml(doc.get(), this.coreManifest);
        if (loadModel) {
            this.coreManifest = this.coreXmlManager.getCoreManifest();
            if (this.fCoreOverviewPage != null) {
                this.fCoreOverviewPage.update(this.coreManifest);
            }
            if (this.fCoreAdvancedPage != null) {
                this.fCoreAdvancedPage.update(this.coreManifest);
            }
            if (this.fCorePrivilegePage != null) {
                this.fCorePrivilegePage.update(this.coreManifest);
            }
            if (this.fCoreFeaturesPage != null) {
                this.fCoreFeaturesPage.update(this.coreManifest);
            }
            if (this.fCoreLocalizationPage != null) {
                this.fCoreLocalizationPage.update(this.coreManifest);
            }
        }
    }

    public void updateXmlFromUI() {
        if (!this.isDirty()) {
            return;
        }
        String str = null;
        if (this.coreXmlManager.getCoreManifest() != null && (str = this.coreXmlManager.getManifestHandler().getXml(this.coreManifest)) != null) {
            IDocument doc = this.fTextEditor.getDocumentProvider().getDocument((Object)this.getEditorInput());
            doc.set(str);
        }
    }

    public IProject getProject() {
        IEditorInput input = this.getEditorInput();
        if (input == null) {
            return null;
        }
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            return file.getProject();
        }
        return null;
    }

    public void close(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    public PrivilegePage getPrivilegePage() {
        return this.fCorePrivilegePage;
    }

    public CoreAdvancedPage getCoreAdvancedPage() {
        return this.fCoreAdvancedPage;
    }

    protected void initFileEvent() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            this.manager = FileBuffers.getTextFileBufferManager();
            if (this.manager != null) {
                this.fFileBufferListener = new FileBufferListener();
                this.manager.addFileBufferListener(this.fFileBufferListener);
                this.fullPath = ((FileEditorInput)input).getFile().getFullPath();
                try {
                    this.manager.connect(this.fullPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void elementContentReplaced() {
    }

    public void elementDeleted(IPath deletedElement) {
        IEditorInput editorInput;
        if (deletedElement != null && (editorInput = this.getEditorInput()) instanceof FileEditorInput && deletedElement.equals((Object)((FileEditorInput)editorInput).getFile().getFullPath())) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ManifestEditor.this.close(false);
                }
            };
            this.execute(r, false);
        }
    }

    private void execute(Runnable runnable, boolean postAsync) {
        if (postAsync || Display.getCurrent() == null) {
            Display fDisplay = this.getSite().getShell().getDisplay();
            fDisplay.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void doSaveAs() {
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2 || event.getType() == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = ManifestEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)ManifestEditor.this.fTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(ManifestEditor.this.fTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, false);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public List<String> getLabelListFromPOFile() {
        List<String> labels = new ArrayList<String>();
        IProject project = this.getProject();
        if (project != null) {
            IPath poDirPath = project.getLocation().append(FOLDER_PATH);
            File poDir = poDirPath.toFile();
            if (!poDir.exists() || poDir.listFiles() == null) {
                return labels;
            }
            if (poDir.listFiles().length > 0) {
                File poFileName = poDir.listFiles()[0];
                POFile poFile = new POFile(poFileName);
                try {
                    labels = poFile.getLabelsFromPOFile();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return labels;
    }

    private String getCodeFromFileName(String name) {
        return name.substring(0, name.length() - 3);
    }

    public Map<String, String> getLanguageValueList(String label) {
        HashMap<String, String> map = new HashMap<String, String>();
        IProject project = this.getProject();
        if (project != null) {
            IPath poDirPath = project.getLocation().append(FOLDER_PATH);
            File poDir = poDirPath.toFile();
            if (!poDir.exists() || poDir.listFiles() == null) {
                return Collections.emptyMap();
            }
            File[] fileArray = poDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File localeFile = fileArray[n2];
                String poFileName = localeFile.getName();
                String languageCode = this.getCodeFromFileName(poFileName).replace('_', '-').toLowerCase();
                POFile poFile = new POFile(localeFile);
                try {
                    String value = null;
                    Iterator<Map.Entry<String, String>> iterator = poFile.getLabelAndValues().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> pair = iterator.next();
                        if (pair.getKey().toString().equals(label)) {
                            value = pair.getValue().toString();
                        }
                        iterator.remove();
                    }
                    map.put(languageCode, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return map;
    }

    public Map<String, File> getColumnMap() {
        HashMap<String, File> columnMap = new HashMap<String, File>();
        IProject project = this.getProject();
        if (project != null) {
            IPath poDirPath = project.getLocation().append(FOLDER_PATH);
            File poDir = poDirPath.toFile();
            if (!poDir.exists() || poDir.listFiles() == null) {
                return Collections.emptyMap();
            }
            File[] fileArray = poDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File localeFile = fileArray[n2];
                String poFileName = localeFile.getName();
                String languageCode = this.getCodeFromFileName(poFileName);
                String languageName = TizenLocale.valueOf((String)languageCode).getName();
                columnMap.put(languageName, localeFile);
                ++n2;
            }
        }
        return columnMap;
    }

    private void copyUserCetificates() {
        File dir = new File(this.getProject().getLocation().append(TRUST_ANCHOR_FOLDER_PATH).toString());
        if (this.coreManifest.getTrustAnchor() == null && dir.exists()) {
            try {
                FileUtils.deleteDirectory((File)dir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.coreManifest.getTrust_anchor_path() != null && !this.coreManifest.getTrust_anchor_path().isEmpty()) {
            try {
                FileUtils.deleteDirectory((File)dir);
                FileUtils.copyDirectory((File)new File(this.coreManifest.getTrust_anchor_path()), (File)dir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected class FileBufferListener
    implements IFileBufferListener {
        protected FileBufferListener() {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
            ManifestEditor.this.elementContentReplaced();
        }

        public void bufferCreated(IFileBuffer buffer) {
        }

        public void bufferDisposed(IFileBuffer buffer) {
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
            ManifestEditor.this.elementDeleted(buffer.getLocation());
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }
    }

    private class ModelStateListener
    implements IModelStateListener {
        private ModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel arg0) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel arg0) {
        }

        public void modelChanged(IStructuredModel arg0) {
            ManifestEditor.this.xmlModelChanged(ManifestEditor.this.getXmlDocument(arg0));
        }

        public void modelDirtyStateChanged(IStructuredModel arg0, boolean arg1) {
        }

        public void modelReinitialized(IStructuredModel arg0) {
        }

        public void modelResourceDeleted(IStructuredModel arg0) {
        }

        public void modelResourceMoved(IStructuredModel arg0, IStructuredModel arg1) {
        }
    }
}

