/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.apihover;

import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTryBlockStatement;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.tizen.nativecommon.apihover.VariablesVisitor;

class PathTracerVisitor
extends ASTVisitor {
    private int fTargetOffset;
    LinkedList<IASTNode> fPath = new LinkedList();
    public static boolean m_fInFunction;

    public PathTracerVisitor(ICEditorContentAssistInvocationContext aInvocationContext) {
        super(true);
        this.fTargetOffset = aInvocationContext.getInvocationOffset();
    }

    public LinkedList<String> GetScopeTypeNames() {
        LinkedList<String> aRet = new LinkedList<String>();
        m_fInFunction = false;
        int i = 0;
        while (i < this.fPath.size()) {
            IASTNode Node2 = this.fPath.get(i);
            if (Node2 instanceof IASTFunctionDefinition) {
                m_fInFunction = true;
                PathTracerVisitor.AddScopeTypeNamesFromFunction(aRet, (IASTFunctionDefinition)Node2);
            } else if (Node2 instanceof IASTTranslationUnit) {
                PathTracerVisitor.AddScopeTypeNamesFromTranslationUnit(aRet, (IASTTranslationUnit)Node2);
            }
            ++i;
        }
        return aRet;
    }

    private static void AddScopeTypeNamesFromFunction(LinkedList<String> listRet, IASTFunctionDefinition Node2) {
        IASTDeclSpecifier ds = Node2.getDeclSpecifier();
        IASTFunctionDeclarator fd = Node2.getDeclarator();
        PathTracerVisitor.AddScopeTypeNamesFromDeclSpecifier(listRet, ds);
        if (fd instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator sfd = (IASTStandardFunctionDeclarator)fd;
            IASTParameterDeclaration[] params = sfd.getParameters();
            int i = 0;
            while (i < params.length) {
                PathTracerVisitor.AddScopeTypeNamesFromDeclSpecifier(listRet, params[i].getDeclSpecifier());
                ++i;
            }
        }
        PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, Node2.getBody(), false);
    }

    private static void AddScopeTypeNamesFromStatement(LinkedList<String> listRet, IASTStatement stm, boolean fDeclOnly) {
        if (stm instanceof IASTDeclarationStatement) {
            IASTDeclaration decl = ((IASTDeclarationStatement)stm).getDeclaration();
            PathTracerVisitor.AddScopeTypeNamesFromDeclaration(listRet, decl);
            return;
        }
        if (fDeclOnly) {
            return;
        }
        if (stm instanceof IASTCompoundStatement) {
            IASTStatement[] stmnts = ((IASTCompoundStatement)stm).getStatements();
            int i = 0;
            while (i < stmnts.length) {
                PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, stmnts[i], i != stmnts.length - 1);
                ++i;
            }
            return;
        }
        if (stm instanceof IASTIfStatement) {
            IASTIfStatement is = (IASTIfStatement)stm;
            if (is.getElseClause() != null) {
                PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, is.getElseClause(), false);
            } else {
                PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, is.getThenClause(), false);
            }
            return;
        }
        if (stm instanceof IASTForStatement) {
            IASTForStatement fs = (IASTForStatement)stm;
            PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, fs.getInitializerStatement(), true);
            PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, fs.getBody(), false);
            return;
        }
        if (stm instanceof IASTWhileStatement) {
            IASTWhileStatement ws = (IASTWhileStatement)stm;
            PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, ws.getBody(), false);
            return;
        }
        if (stm instanceof IASTDoStatement) {
            IASTDoStatement ds = (IASTDoStatement)stm;
            PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, ds.getBody(), false);
            return;
        }
        if (stm instanceof IASTSwitchStatement) {
            IASTSwitchStatement ss = (IASTSwitchStatement)stm;
            PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, ss.getBody(), false);
            return;
        }
        if (stm instanceof CPPASTTryBlockStatement) {
            CPPASTTryBlockStatement tbs = (CPPASTTryBlockStatement)stm;
            IASTStatement stmBody = tbs.getTryBody();
            ICPPASTCatchHandler[] stmHandlers = tbs.getCatchHandlers();
            if (stmHandlers == null || stmHandlers.length == 0) {
                PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, stmBody, false);
            } else if (stmHandlers.length > 0) {
                PathTracerVisitor.AddScopeTypeNamesFromStatement(listRet, (IASTStatement)stmHandlers[stmHandlers.length - 1], false);
            }
            return;
        }
    }

    private static void AddScopeTypeNamesFromTranslationUnit(LinkedList<String> listRet, IASTTranslationUnit tu) {
        IASTDeclaration[] ad = tu.getDeclarations(true);
        int i = 0;
        while (i < ad.length) {
            PathTracerVisitor.AddScopeTypeNamesFromDeclaration(listRet, ad[i]);
            ++i;
        }
    }

    private static void AddScopeTypeNamesFromDeclaration(LinkedList<String> listRet, IASTDeclaration decl) {
        if (decl instanceof IASTSimpleDeclaration) {
            PathTracerVisitor.AddScopeTypeNamesFromDeclSpecifier(listRet, ((IASTSimpleDeclaration)decl).getDeclSpecifier());
        }
    }

    private static void AddScopeTypeNamesFromDeclSpecifier(LinkedList<String> listRet, IASTDeclSpecifier ds) {
        if (ds instanceof IASTElaboratedTypeSpecifier) {
            PathTracerVisitor.AddScopeTypeNamesFromElaboratedTypeSpecifier(listRet, (IASTElaboratedTypeSpecifier)ds);
        } else if (ds instanceof IASTNamedTypeSpecifier) {
            PathTracerVisitor.AddScopeTypeNamesFromNamedTypeSpecifier(listRet, (IASTNamedTypeSpecifier)ds);
        }
    }

    private static void AddScopeTypeNamesFromElaboratedTypeSpecifier(LinkedList<String> listRet, IASTElaboratedTypeSpecifier ts) {
        PathTracerVisitor.AddStringTypeName(listRet, ts.getName().toString());
    }

    private static void AddScopeTypeNamesFromNamedTypeSpecifier(LinkedList<String> listRet, IASTNamedTypeSpecifier ts) {
        PathTracerVisitor.AddStringTypeName(listRet, ts.getName().toString());
    }

    private static void AddStringTypeName(LinkedList<String> listRet, String sName) {
        if (sName.length() > 0 && !listRet.contains(sName)) {
            listRet.add(sName);
        }
    }

    public void checkResults(CContentAssistInvocationContext context) {
        try {
            if (context == null) {
                return;
            }
            if (context.getTranslationUnit() == null) {
                return;
            }
            if (context.getTranslationUnit().getSource() == null) {
                return;
            }
            StringBuffer source = new StringBuffer(context.getTranslationUnit().getSource());
            ListIterator li = this.fPath.listIterator();
            int index = 0;
            int openingExtension = 0;
            while (li.hasNext()) {
                IASTNode currentNode = (IASTNode)li.next();
                IASTFileLocation fl = currentNode.getFileLocation();
                if (fl == null) continue;
                String tmpStr = "\\* O " + index + " *\\";
                source.insert(fl.getNodeOffset() + openingExtension, tmpStr);
                openingExtension += tmpStr.length();
                tmpStr = "\\* C " + index + " *\\";
                source.insert(fl.getNodeOffset() + fl.getNodeLength() + openingExtension, tmpStr);
                ++index;
            }
        }
        catch (CModelException e) {
            Object source = null;
            e.printStackTrace();
        }
    }

    private boolean isTargetInNode(IASTNode aNode) {
        IASTFileLocation fl;
        block3: {
            try {
                fl = aNode.getFileLocation();
                if (fl != null) break block3;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        int nodeOffset = fl.getNodeOffset();
        int nodeLength = fl.getNodeLength();
        return this.fTargetOffset - nodeOffset >= 0 && nodeOffset + nodeLength - this.fTargetOffset >= 0;
    }

    public void printList() {
        Bundle bundle = Platform.getBundle((String)"org.linuxplatform.help.apihover");
        ILog log = Platform.getLog((Bundle)bundle);
        ListIterator it = this.fPath.listIterator();
        IASTNode currentNode = null;
        while (it.hasNext()) {
            String rawSig;
            currentNode = (IASTNode)it.next();
            log.log((IStatus)new Status(1, "toString : ", currentNode.toString()));
            if (currentNode.getChildren().length == 0) break;
            try {
                IToken syntax_tok = currentNode.getSyntax();
                if (syntax_tok != null) {
                    String syntax = syntax_tok.toString();
                    log.log((IStatus)new Status(1, "syntax : ", syntax));
                }
            }
            catch (ExpansionOverlapsBoundaryException e) {
                e.printStackTrace();
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            try {
                IToken lsyntax_tok = currentNode.getLeadingSyntax();
                if (lsyntax_tok != null) {
                    String lsyntax = lsyntax_tok.toString();
                    log.log((IStatus)new Status(1, "leading syntax :", lsyntax));
                }
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            catch (ExpansionOverlapsBoundaryException e) {
                e.printStackTrace();
            }
            try {
                IToken tsyntax_tok = currentNode.getTrailingSyntax();
                if (tsyntax_tok != null) {
                    String tsyntax = tsyntax_tok.toString();
                    log.log((IStatus)new Status(1, "trailing syntax :", tsyntax));
                }
            }
            catch (UnsupportedOperationException e) {
                e.printStackTrace();
            }
            catch (ExpansionOverlapsBoundaryException e) {
                e.printStackTrace();
            }
            if ((rawSig = currentNode.getRawSignature()) != null) {
                log.log((IStatus)new Status(1, "raw signature :", rawSig));
            }
            log.log((IStatus)new Status(1, "---------------------------------------------------------------------------------------------", ""));
        }
    }

    public int visitCommon(IASTNode aNode) {
        if (this.isTargetInNode(aNode)) {
            this.fPath.add(aNode);
            if (aNode.getChildren().length > 0) {
                return 3;
            }
            return 2;
        }
        return 1;
    }

    public int visit(IASTTranslationUnit tu) {
        tu.accept((ASTVisitor)new VariablesVisitor());
        return this.visitCommon((IASTNode)tu);
    }

    public int visit(IASTName name) {
        return this.visitCommon((IASTNode)name);
    }

    public int visit(IASTDeclaration declaration) {
        return this.visitCommon((IASTNode)declaration);
    }

    public int visit(IASTInitializer initializer) {
        return this.visitCommon((IASTNode)initializer);
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        return this.visitCommon((IASTNode)parameterDeclaration);
    }

    public int visit(IASTDeclarator declarator) {
        return this.visitCommon((IASTNode)declarator);
    }

    public int visit(IASTDeclSpecifier declSpec) {
        return this.visitCommon((IASTNode)declSpec);
    }

    public int visit(IASTArrayModifier arrayModifier) {
        return this.visitCommon((IASTNode)arrayModifier);
    }

    public int visit(IASTPointerOperator ptrOperator) {
        return this.visitCommon((IASTNode)ptrOperator);
    }

    public int visit(IASTExpression expression) {
        return this.visitCommon((IASTNode)expression);
    }

    public int visit(IASTStatement statement) {
        return this.visitCommon((IASTNode)statement);
    }

    public int visit(IASTTypeId typeId) {
        return this.visitCommon((IASTNode)typeId);
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        return this.visitCommon((IASTNode)enumerator);
    }

    public int visit(IASTProblem problem) {
        return this.visitCommon((IASTNode)problem);
    }
}

