/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.tizen.ssilib.SSIRule;
import org.tizen.ssilib.SSIRuleOp;

public class SSIProc {
    public String type;
    private String src;
    private String[] des;
    private String transScript;
    private String echoText;
    private String require;
    private List<SSIRule> targetRules = new ArrayList<SSIRule>();
    private List<SSIRule> filesetRules = new ArrayList<SSIRule>();
    private String content;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void addTargetRule(String ruleStr) {
        this.targetRules.add(new SSIRule(ruleStr));
    }

    public void addTargetRule(String[] rules) {
        for (String fs : rules) {
            this.addTargetRule(fs);
        }
    }

    public List<SSIRule> getTargetRule() {
        return this.targetRules;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public String getSrc() {
        return this.src;
    }

    public void setDes(String[] des) {
        this.des = des;
    }

    public String[] getDes() {
        return this.des;
    }

    public void setTransScript(String transScript) {
        this.transScript = transScript;
    }

    public String getTransScript() {
        return this.transScript;
    }

    public boolean matchTarget(String target, String type, int order) {
        SSIRule rule;
        String targetTarget;
        if (this.targetRules == null || this.targetRules.isEmpty()) {
            return true;
        }
        boolean match = false;
        Iterator<SSIRule> iterator = this.targetRules.iterator();
        block0: while (iterator.hasNext() && ((targetTarget = (rule = iterator.next()).getTarget()) == null || (match = targetTarget.equals(target)))) {
            List<SSIRuleOp> ruleOps = rule.getTargetRule();
            if (ruleOps == null) continue;
            for (SSIRuleOp ruleOp : ruleOps) {
                String lt = ruleOp.getLt();
                boolean m = false;
                if (lt.equals("type")) {
                    m = ruleOp.isMatch(type);
                } else if (lt.equals("order")) {
                    m = ruleOp.isMatch(String.valueOf(order));
                }
                if (ruleOp.baseOp == SSIRuleOp.OP_NONE) {
                    match = m;
                    continue;
                }
                if (ruleOp.baseOp == SSIRuleOp.OP_AND && !m) {
                    match = m;
                    break block0;
                }
                if (ruleOp.baseOp != SSIRuleOp.OP_OR || !m) continue;
                match = m;
            }
        }
        return match;
    }

    public void addFileSetRule(String rule) {
        this.filesetRules.add(new SSIRule(rule));
    }

    public void addFileSetRule(String[] rules) {
        for (String fs : rules) {
            this.addFileSetRule(fs);
        }
    }

    public List<SSIRule> getFileSetRules() {
        return this.filesetRules;
    }

    public void setEcho(String echoText) {
        this.echoText = echoText;
    }

    public String getEcho() {
        return this.echoText;
    }

    public void setRequire(String require) {
        this.require = require;
    }

    public String getRequire() {
        return this.require;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }
}

