/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.ui;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.ResourceUtil;
import org.tizen.web.zimlaunch.ui.Messages;

public abstract class AbstractLaunchShortcut
implements ILaunchShortcut2 {
    protected String errorMessage;

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile inputFile = ((IFileEditorInput)input).getFile();
            IProject proj = inputFile.getProject();
            this.launch(proj, mode);
        } else {
            this.openLaunchErrorDialog(this.getEditorEmptyMessage());
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object res = sel.getFirstElement();
            if (res instanceof IResource) {
                IProject proj = ((IResource)res).getProject();
                this.launch(proj, mode);
            }
        } else {
            this.openLaunchErrorDialog(this.getSelectionEmptyMessage());
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        IResource resource = this.getLaunchableResource(selection);
        return this.getLaunchConfigurations(resource);
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorPart) {
        IResource resource = this.getLaunchableResource(editorPart);
        if (resource != null) {
            return this.getLaunchConfigurations((IResource)resource.getProject());
        }
        return null;
    }

    private ILaunchConfiguration[] getLaunchConfigurations(IResource resource) {
        if (resource == null) {
            return null;
        }
        List<ILaunchConfiguration> lc = null;
        lc = this.getCandidateConfigs(resource.getProject(), this.getConfigurationType());
        return lc != null ? lc.toArray(new ILaunchConfiguration[lc.size()]) : null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorPart) {
        return ResourceUtil.getResource((IEditorInput)editorPart.getEditorInput());
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(AbstractLaunchShortcut.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getConfigSelectionTitle());
        dialog.setMessage(Messages.LaunchShortcut_ChooseDialogMessage);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(IProject var1) throws CoreException;

    protected ILaunchConfiguration findLaunchConfiguration(IProject project, ILaunchConfigurationType configType) throws CoreException {
        List<ILaunchConfiguration> candidateConfigs = this.getCandidateConfigs(project, configType);
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(project);
        }
        if (candidateCount == 1) {
            return candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected abstract List<ILaunchConfiguration> getCandidateConfigs(IProject var1, ILaunchConfigurationType var2);

    protected abstract ILaunchConfigurationType getConfigurationType();

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void launch(IProject project, String mode) {
        if (project == null) {
            this.openLaunchErrorDialog(this.getIncompatibleProjectMessage());
            return;
        }
        if (!this.projectValidationCheck(project)) {
            this.openLaunchErrorDialog(this.errorMessage);
            return;
        }
        try {
            ILaunchConfiguration config;
            if (project.isNatureEnabled("org.tizen.web.project.builder.WebNature") && (config = this.findLaunchConfiguration(project, this.getConfigurationType())) != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
        catch (CoreException coreException) {
            this.openLaunchErrorDialog(Messages.PROJECT_NOT_USABLE);
        }
    }

    protected boolean projectValidationCheck(IProject project) {
        return true;
    }

    private void openLaunchErrorDialog(String msg) {
        MessageDialog.openError((Shell)AbstractLaunchShortcut.getShell(), (String)Messages.LAUNCH_ERROR, (String)msg);
    }

    protected String getEditorEmptyMessage() {
        return Messages.LaunchShortcut_EditableNotLaunchable;
    }

    protected String getSelectionEmptyMessage() {
        return Messages.LaunchShortcut_SelectionNotLaunchable;
    }

    protected String getConfigSelectionTitle() {
        return Messages.LaunchShortcut_ChooseDialogTitle;
    }

    protected String getIncompatibleProjectMessage() {
        return Messages.LaunchShortcut_IncompatibleProject;
    }
}

