/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.IApplicationConfiguration;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.ITizenNativeXMLStore;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.AdapterUtil;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.PluginUtil;
import org.tizen.web.common.IDEPathUtil;
import org.tizen.web.common.WebCommonActivator;

public class ProjectUtil
extends org.tizen.common.util.ProjectUtil {
    public static final Logger logger = LoggerFactory.getLogger(ProjectUtil.class);

    public static boolean isCheckedUsingTargetLibrary(IProject project) {
        String usedTargetLibrary;
        block4: {
            if (project == null) {
                return false;
            }
            try {
                usedTargetLibrary = project.getPersistentProperty(WebCommonActivator.usedTargetLibraryQName);
                if (usedTargetLibrary != null) break block4;
                return false;
            }
            catch (CoreException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return Boolean.parseBoolean(usedTargetLibrary);
    }

    public static ITizenNativeXMLStore getTizenNativeXmlStore(IProject project, String loadClassId) {
        ITizenNativeXMLStore xmlManager = null;
        try {
            xmlManager = (ITizenNativeXMLStore)PluginUtil.loadClass((String)"org.tizen.nativecommon.store", (String)loadClassId);
            if (xmlManager == null) {
                throw new IllegalArgumentException("There is no plug-in extending org.tizen.nativecommon.store");
            }
            xmlManager.setProject(project);
            xmlManager.loadXml();
        }
        catch (CoreException coreException) {}
        return xmlManager;
    }

    public static ITizenNativeXMLStore getTizenNativeXmlStore(IProject project) throws CoreException {
        Assert.notNull((Object)project);
        ITizenNativeXMLStore store = null;
        ITizenNativeProject tnProject = (ITizenNativeProject)ProjectUtil.getTizenProject((IProject)project, ITizenNativeProject.class);
        if (tnProject == null) {
            return null;
        }
        store = tnProject.getXmlStore();
        if (store == null) {
            return null;
        }
        store.setProject(project.getLocation().toOSString());
        store.loadXml();
        return store;
    }

    public static IProject[] getReferencedNativeProjects(IProject project) {
        List projects = ProjectUtil.getReferencedProjects((IProject)project);
        Iterator itor = projects.iterator();
        while (itor.hasNext()) {
            IProject refProject = (IProject)itor.next();
            if (ProjectUtil.isTizenNativeProject((IProject)refProject)) continue;
            itor.remove();
        }
        return projects.toArray(new IProject[0]);
    }

    public static boolean isHybridApp(IProject targetProject) throws CoreException {
        return !ArrayUtil.isEmpty((Object[])ProjectUtil.getReferencedNativeProjects(targetProject));
    }

    public static boolean isCompanionApp(IProject targetProject) {
        return ProjectUtil.getCompanionWebProject(targetProject) != null;
    }

    public static IProject[] getReferenceWebWidgetProject(IProject project) {
        ArrayList<IProject> webWidgetProjects = new ArrayList<IProject>();
        TizenProjectDescription tpd = ProjectUtil.getTizenProjectDescription((IProject)project);
        List subProjects = tpd.getSubProjectList();
        for (TizenProjectDescription.RefTizenProject subProject : subProjects) {
            IProject webWidgetProject = ProjectUtil.getProject((String)subProject.getName());
            if (!ProjectUtil.isWebWidgetProject(webWidgetProject)) continue;
            webWidgetProjects.add(webWidgetProject);
        }
        return webWidgetProjects.toArray(new IProject[0]);
    }

    public static IProject[] getReferencedWearableWebprojects(IProject project) {
        ArrayList<IProject> referencedWebProjects = new ArrayList<IProject>();
        TizenProjectDescription tpd = ProjectUtil.getTizenProjectDescription((IProject)project);
        List subProjects = tpd.getSubProjectList();
        for (TizenProjectDescription.RefTizenProject subProject : subProjects) {
            IProject referencedProject = ProjectUtil.getProject((String)subProject.getName());
            if (!ProjectUtil.isWebProject(referencedProject)) continue;
            referencedWebProjects.add(referencedProject);
        }
        return referencedWebProjects.toArray(new IProject[0]);
    }

    public static IProject getCompanionWebProject(IProject project) {
        TizenProjectDescription tpd = ProjectUtil.getTizenProjectDescription((IProject)project);
        List subProjects = tpd.getSubProjectList();
        for (TizenProjectDescription.RefTizenProject subProject : subProjects) {
            IProject companionProject;
            if (!"companion".equals(subProject.getStyle()) || ProjectUtil.isWebWidgetProject(companionProject = ProjectUtil.getProject((String)subProject.getName())) || !ProjectUtil.isWebProject(companionProject)) continue;
            return companionProject;
        }
        return null;
    }

    public static String getNativeBinaryName(IProject refProject) {
        IApplicationConfiguration appConfig = (IApplicationConfiguration)AdapterUtil.getAdapter((IAdaptable)refProject, IApplicationConfiguration.class);
        return appConfig == null ? null : appConfig.getBinaryName();
    }

    public static String getNativeBuildDirName(IProject refProject) {
        ITizenNativeProject refTProject = (ITizenNativeProject)org.tizen.common.util.ProjectUtil.getTizenProject((IProject)refProject, ITizenNativeProject.class);
        return refTProject == null ? null : refTProject.getDefaultBuildConfiguration();
    }

    public static String getPackageName(IProject project) {
        return project.getName();
    }

    public static boolean isTizenWebUIFWProject(IProject project) {
        return "WebUIFramework".equals(ProjectUtil.getProjectLibraryType(project));
    }

    public static boolean isTizenCowhideProject(IProject project) {
        return "CowhideFramework".equals(ProjectUtil.getProjectLibraryType(project));
    }

    private static String getProjectLibraryType(IProject project) {
        Map buildCommandArgs = ProjectUtil.getBuildCommandArgument((IProject)project, (String)"org.tizen.web.project.builder.WebBuilder");
        if (buildCommandArgs == null || buildCommandArgs.isEmpty()) {
            return null;
        }
        return (String)buildCommandArgs.get("usedLibraryType");
    }

    public static boolean isWebProject(IProject project) {
        try {
            return project != null && project.isOpen() && project.isNatureEnabled("org.tizen.web.project.builder.WebNature") && !project.isNatureEnabled("org.tizen.web.project.builder.WebWidgetNature");
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isWebWidgetProject(IProject project) {
        try {
            return !ProjectUtil.isWebProject(project) && project.isNatureEnabled("org.tizen.web.project.builder.WebWidgetNature");
        }
        catch (CoreException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isInstallWebWidgetFeature(ProfileInfo profile, String version) {
        String codeAssistDir = IDEPathUtil.getWebWidgetCodeAssistDir(profile, version);
        return new File(codeAssistDir).exists();
    }

    public static boolean hasError(IResource resource) {
        int severity = ProjectUtil.getMaxProblemSeverity((IResource)resource, (boolean)false);
        return severity >= 2;
    }

    public static boolean isCheckedUsingTargetLibraryMinVersion(IProject project) {
        String usedMinVersion;
        block4: {
            if (project == null) {
                return false;
            }
            try {
                usedMinVersion = project.getPersistentProperty(WebCommonActivator.useMinUifwQName);
                if (usedMinVersion != null) break block4;
                return true;
            }
            catch (CoreException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return true;
            }
        }
        return Boolean.parseBoolean(usedMinVersion);
    }

    public static String getDefaultExcludeOptimizeList(IProject project) {
        ArrayList<String> excludes = new ArrayList<String>();
        StringBuffer excludeOptimize = new StringBuffer();
        if (ProjectUtil.isTizenCowhideProject(project)) {
            excludes.add("cowhide/*");
        } else if (ProjectUtil.isTizenWebUIFWProject(project)) {
            excludes.add("tizen-web-ui-fw/*");
        }
        if (project.findMember("lib/tau") != null) {
            excludes.add("lib/tau/*");
        }
        for (String exclude : excludes) {
            if (excludeOptimize.length() != 0) {
                excludeOptimize.append(", ");
            }
            excludeOptimize.append(exclude);
        }
        return excludeOptimize.toString();
    }

    public static String[] getExcludingOptimizeOptions(IProject project) throws CoreException {
        String text = project.getPersistentProperty(WebCommonActivator.excludingOptimizeResourcesQName);
        if (text == null) {
            text = ProjectUtil.getDefaultExcludeOptimizeList(project);
        }
        text = text.replace("\\", "/");
        return text.split("\\s*(,)\\s*");
    }

    public static IProject[] getReferencedNativeCoreProjects(IProject project) throws CoreException {
        LinkedHashSet<Object> refNativeProjects = new LinkedHashSet<Object>();
        Object[] refProjects = ProjectUtil.getReferencedNativeProjects(project);
        if (ArrayUtil.isEmpty((Object[])refProjects)) {
            return refProjects;
        }
        Object[] objectArray = refProjects;
        int n = refProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object refProject = objectArray[n2];
            if (ProjectUtil.isTizenNativeCoreProject((IProject)refProject)) {
                refNativeProjects.add(refProject);
            }
            ++n2;
        }
        return refNativeProjects.toArray(new IProject[0]);
    }

    public static boolean isTizenNativeCoreProject(IProject project) {
        TizenProjectType tProjectType = org.tizen.common.util.ProjectUtil.getTizenProjectType((IProject)project);
        if (tProjectType == null) {
            return false;
        }
        return tProjectType.isCoreProject();
    }

    public static String getReferencedNativeRootProjectName(IProject targetProject) {
        TizenProjectDescription tpd = ProjectUtil.getTizenProjectDescription((IProject)targetProject);
        List subProjects = tpd.getSubProjectList();
        for (TizenProjectDescription.RefTizenProject subProject : subProjects) {
            if (!"native main".equals(subProject.getStyle())) continue;
            return subProject.getName();
        }
        return null;
    }
}

