/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.step;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Resource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.launch.context.ILaunchContext;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.web.common.util.PackageUtil;
import org.tizen.web.packager.core.PackageProcessType;
import org.tizen.web.packager.ui.WebPackager;
import org.tizen.web.zimlaunch.core.CompositeStep;
import org.tizen.web.zimlaunch.core.IStep;
import org.tizen.web.zimlaunch.resource.ZimLaunchResource;
import org.tizen.web.zimlaunch.util.LaunchUtil;

public class PackageStep
extends CompositeStep {
    public PackageStep() {
        super(new IStep[0]);
    }

    @Override
    public void executeStep(ILaunchContext ctx) throws Exception {
        UserLogger.start((String)"web.launch", (String)".packaging");
        IProject project = this.getProject(ctx);
        Assert.notNull((Object)project);
        WebPackager packMan = new WebPackager();
        ZimLaunchResource launchResource = (ZimLaunchResource)ctx.getValue((Object)"resource");
        packMan.setDevice(launchResource.getDeviceinfo().getDevice());
        ByteArrayOutputStream os = null;
        boolean isSuccess = false;
        try {
            Resource resource = null;
            String mode = (String)ctx.getValue((Object)"mode");
            String packPath = PackageUtil.getPackagePath((IProject)project);
            ILaunchConfiguration launchConfig = (ILaunchConfiguration)ctx.getValue((Object)"config");
            packMan.removePackage(project);
            if (LaunchUtil.isLiveEditingMode(launchConfig) && !"debug".equals(mode)) {
                os = new ByteArrayOutputStream();
                isSuccess = packMan.createLiveEditingPackage(project, (OutputStream)os);
                if (isSuccess) {
                    resource = new Resource((FileHandler)new VirtualFileHandler(), packPath);
                    resource.setContents(os.toByteArray());
                }
            } else if ("debug".equals(mode)) {
                isSuccess = packMan.createDebugPackage(project);
                if (isSuccess) {
                    project.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    resource = new Resource((FileHandler)new StandardFileHandler(), packPath);
                }
            } else {
                isSuccess = packMan.createPackage(project, PackageProcessType.RUN);
                if (isSuccess) {
                    project.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    resource = new Resource((FileHandler)new StandardFileHandler(), packPath);
                }
            }
            if (isSuccess) {
                ctx.setValue((Object)"package", resource);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{os});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{os});
        UserLogger.end((String)"web.launch", (String)".packaging");
    }

    protected IProject getProject(ILaunchContext ctx) throws CoreException {
        ILaunchConfiguration config = (ILaunchConfiguration)ctx.getValue((Object)"config");
        return LaunchUtil.getProject((ILaunchConfiguration)config);
    }
}

