/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.account.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.ui.dialog.LocaleDialog;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.core.WebProjectUtil;
import org.tizen.web.config.schema.model.Account;
import org.tizen.web.config.schema.model.Capability;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.DisplayName;
import org.tizen.web.config.schema.model.TizenAccountIcon;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.tizen.account.support.CapabilityContentProvider;
import org.tizen.web.editor.configuration.tizen.account.support.CapabilityEditingSupport;
import org.tizen.web.editor.configuration.tizen.account.support.CapabilityLabelProvider;
import org.tizen.web.editor.configuration.tizen.account.support.DisplayNameContentProvider;
import org.tizen.web.editor.configuration.tizen.account.support.DisplayNameEditingSupport;
import org.tizen.web.editor.configuration.tizen.account.support.DisplayNameLabelProvider;

public class AddAccountPage
extends WizardPage {
    public static final String ICON_SECTION = "Account";
    public static final String SMALLICON_SECTION = "AccountSmall";
    public static final String EMPTY_STRING = "";
    private ITizenConfigurator configurator;
    private Account account;
    private Boolean bEditMode;
    private GridData tableViewGroupGridData;
    private Combo multipleAccountSupportCombo;
    private SelectionListener selectionListener;
    private Group iconGroup;
    private Text accountIconText;
    private Text accountSmallIconText;
    private ModifyListener modifyListener;
    private ArrayList<DisplayName> internalDisplayNames;
    private Group displayNameGroup;
    private TableViewer displayNameViewer;
    private DisplayNameEditingSupport accountDisplayNameLangEditingSupport;
    private DisplayNameEditingSupport accountDisplayNameNameEditingSupport;
    private Button displayNameAddBtn;
    private Button displayNameRemoveBtn;
    private SelectionListener displayNameAddBtnSelectionListener;
    private SelectionListener displayNameRemoveBtnSelectionListener;
    private IDoubleClickListener displayNameDoubleClickListener;
    private ISelectionChangedListener displayNameViewerSelectionChangedListener;
    private ArrayList<Capability> internalCapabilities;
    private Group capabilityGroup;
    private TableViewer capabilityViewer;
    private CapabilityEditingSupport capabilityEditingSupport;
    private Button capabilityAddBtn;
    private Button capabilityRemoveBtn;
    private SelectionListener capabilityAddBtnSelectionListener;
    private SelectionListener capabilityRemoveBtnSelectionListener;
    private ISelectionChangedListener capabilityViewerSelectionChangedListener;

    protected AddAccountPage(String pageName, ITizenConfigurator configurator) {
        super(pageName);
        this.setPageComplete(false);
        this.configurator = configurator;
        this.bEditMode = false;
    }

    public AddAccountPage(String pageName, ITizenConfigurator configurator, Account account) {
        super(pageName);
        this.setPageComplete(true);
        this.configurator = configurator;
        this.account = account;
        this.bEditMode = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledComposite scrolledRootComposite = new ScrolledComposite(parent, 768);
        scrolledRootComposite.setExpandHorizontal(true);
        scrolledRootComposite.setExpandVertical(true);
        this.tableViewGroupGridData = new GridData(1808);
        this.tableViewGroupGridData.heightHint = 120;
        this.internalDisplayNames = new ArrayList();
        this.internalCapabilities = new ArrayList();
        Composite innerComposite = new Composite((Composite)scrolledRootComposite, 0);
        innerComposite.setLayout((Layout)new GridLayout(1, false));
        innerComposite.setLayoutData((Object)new GridData(768));
        this.createAccountAttributeControl(innerComposite);
        this.createIconControl(innerComposite);
        this.createDisplayNameControl(innerComposite);
        this.createCapabilityControl(innerComposite);
        if (this.bEditMode.booleanValue()) {
            this.loadAccountData();
            this.validatePage();
        }
        this.addListener();
        scrolledRootComposite.setContent((Control)innerComposite);
        scrolledRootComposite.setMinSize(innerComposite.computeSize(-1, -1));
        Dialog.applyDialogFont((Control)scrolledRootComposite);
        this.setControl((Control)scrolledRootComposite);
    }

    private void createAccountAttributeControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        this.multipleAccountSupportCombo = SWTUtil.createEnumCombo((Composite)container, (String)Messages.TizenPage_Account_MultipleAccountSupportColumnLabel, (String)Messages.TizenPage_Account_MultipleAccountSupportColumnTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.FALSE.ordinal());
        this.multipleAccountSupportCombo.setLayoutData((Object)new GridData(4, 2, false, false, 1, 0));
    }

    private void createIconControl(Composite parent) {
        this.iconGroup = new Group(parent, 0);
        this.iconGroup.setText(Messages.TizenPage_Account_IconColumnLabel);
        this.iconGroup.setToolTipText(Messages.TizenPage_Account_IconColumnTooltip);
        this.iconGroup.setLayout((Layout)new GridLayout(3, false));
        this.iconGroup.setLayoutData((Object)new GridData(1808));
        this.accountIconText = SWTUtil.createText((Composite)this.iconGroup, (String)Messages.TizenPage_Account_IconColumnLabel, (String)Messages.TizenPage_Account_IconColumnTooltip, (int)1, (int)0);
        SWTUtil.createFileBrowserButton((Composite)this.iconGroup, (Text)this.accountIconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
        this.accountSmallIconText = SWTUtil.createText((Composite)this.iconGroup, (String)Messages.TizenPage_Account_SmallIconColumnLabel, (String)Messages.TizenPage_Account_SmallIconColumnTooltip, (int)1, (int)0);
        SWTUtil.createFileBrowserButton((Composite)this.iconGroup, (Text)this.accountSmallIconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
    }

    private void createDisplayNameControl(Composite parent) {
        this.displayNameGroup = new Group(parent, 0);
        this.displayNameGroup.setText(Messages.TizenPage_Account_DisplayNameColumnLabel);
        this.displayNameGroup.setToolTipText(Messages.TizenPage_Account_DisplayNameColumnTooltip);
        this.displayNameGroup.setLayout((Layout)new GridLayout(2, false));
        this.displayNameGroup.setLayoutData((Object)this.tableViewGroupGridData);
        DisplayNameContentProvider displayNameContentProvider = new DisplayNameContentProvider();
        DisplayNameLabelProvider displayNameTableLabelProvider = new DisplayNameLabelProvider();
        Composite displayNameTableComposite = new Composite((Composite)this.displayNameGroup, 0);
        displayNameTableComposite.setLayout((Layout)new GridLayout(1, false));
        displayNameTableComposite.setLayoutData((Object)new GridData(1808));
        this.displayNameViewer = new TableViewer(displayNameTableComposite, 68354);
        Table displayNameTable = this.displayNameViewer.getTable();
        displayNameTable.setHeaderVisible(true);
        displayNameTable.setLinesVisible(true);
        displayNameTable.setLayoutData((Object)new GridData(1808));
        TableViewerColumn langColumn = new TableViewerColumn(this.displayNameViewer, 0);
        langColumn.getColumn().setText(Messages.AddAccountPage_DisplayName_LangLabel);
        langColumn.getColumn().setToolTipText(Messages.AddAccountPage_DisplayName_LangTooltip);
        this.accountDisplayNameLangEditingSupport = new DisplayNameEditingSupport((ColumnViewer)this.displayNameViewer, 0);
        langColumn.setEditingSupport((EditingSupport)this.accountDisplayNameLangEditingSupport);
        TableViewerColumn nameColumn = new TableViewerColumn(this.displayNameViewer, 0);
        nameColumn.getColumn().setText(Messages.AddAccountPage_DisplayName_NameLabel);
        nameColumn.getColumn().setToolTipText(Messages.AddAccountPage_DisplayName_NameTooltip);
        this.accountDisplayNameNameEditingSupport = new DisplayNameEditingSupport((ColumnViewer)this.displayNameViewer, 1);
        nameColumn.setEditingSupport((EditingSupport)this.accountDisplayNameNameEditingSupport);
        TableLayout displayNameTableLayout = new TableLayout();
        displayNameTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        displayNameTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        this.displayNameViewer.getTable().setLayout((Layout)displayNameTableLayout);
        this.displayNameViewer.setContentProvider((IContentProvider)displayNameContentProvider);
        this.displayNameViewer.setLabelProvider((IBaseLabelProvider)displayNameTableLabelProvider);
        Composite buttons = new Composite((Composite)this.displayNameGroup, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(2));
        this.displayNameAddBtn = SWTUtil.createButton((Composite)buttons, (String)Messages.AddButtonLabel, (String)Messages.AddButtonLabel);
        this.displayNameRemoveBtn = SWTUtil.createButton((Composite)buttons, (String)Messages.RemoveButtonLabel, (String)Messages.AddButtonLabel);
        this.displayNameRemoveBtn.setEnabled(false);
    }

    private void createCapabilityControl(Composite parent) {
        this.capabilityGroup = new Group(parent, 0);
        this.capabilityGroup.setText(Messages.AddAccountPage_Capability_Label);
        this.capabilityGroup.setToolTipText(Messages.AddAccountPage_Capability_Tooltip);
        this.capabilityGroup.setLayout((Layout)new GridLayout(2, false));
        this.capabilityGroup.setLayoutData((Object)this.tableViewGroupGridData);
        CapabilityContentProvider capabilityContentProvider = new CapabilityContentProvider();
        CapabilityLabelProvider capabilityTableLabelProvider = new CapabilityLabelProvider();
        Composite capabilityTableComposite = new Composite((Composite)this.capabilityGroup, 0);
        capabilityTableComposite.setLayout((Layout)new GridLayout(1, false));
        capabilityTableComposite.setLayoutData((Object)new GridData(1808));
        this.capabilityViewer = new TableViewer(capabilityTableComposite, 68354);
        Table capabilityTable = this.capabilityViewer.getTable();
        capabilityTable.setHeaderVisible(true);
        capabilityTable.setLinesVisible(true);
        capabilityTable.setLayoutData((Object)new GridData(1808));
        TableViewerColumn capabilityColumn = new TableViewerColumn(this.capabilityViewer, 0);
        capabilityColumn.getColumn().setText(Messages.AddAccountPage_Capability_ContentLabel);
        capabilityColumn.getColumn().setToolTipText(Messages.AddAccountPage_Capability_ContentTooltip);
        this.capabilityEditingSupport = new CapabilityEditingSupport((ColumnViewer)this.capabilityViewer, 0);
        capabilityColumn.setEditingSupport((EditingSupport)this.capabilityEditingSupport);
        TableLayout capabilityTableLayout = new TableLayout();
        capabilityTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.capabilityViewer.getTable().setLayout((Layout)capabilityTableLayout);
        this.capabilityViewer.setContentProvider((IContentProvider)capabilityContentProvider);
        this.capabilityViewer.setLabelProvider((IBaseLabelProvider)capabilityTableLabelProvider);
        Composite buttons = new Composite((Composite)this.capabilityGroup, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(2));
        this.capabilityAddBtn = SWTUtil.createButton((Composite)buttons, (String)Messages.AddButtonLabel, (String)Messages.AddButtonLabel);
        this.capabilityRemoveBtn = SWTUtil.createButton((Composite)buttons, (String)Messages.RemoveButtonLabel, (String)Messages.RemoveButtonLabel);
        this.capabilityRemoveBtn.setEnabled(false);
    }

    private void loadAccountData() {
        if (this.account.getMultipleAccountSupport() == DataBoolean.TRUE) {
            this.multipleAccountSupportCombo.select(0);
        } else {
            this.multipleAccountSupportCombo.select(1);
        }
        for (Object control : this.account.getIconOrDisplayNameOrCapability()) {
            if (control instanceof TizenAccountIcon) {
                String smallIcon;
                String section = ((TizenAccountIcon)control).getSection();
                if (section != null && section.equalsIgnoreCase(ICON_SECTION)) {
                    String icon = ((TizenAccountIcon)control).getContent();
                    if (StringUtil.isEmpty((CharSequence)icon)) continue;
                    this.accountIconText.setText(icon);
                    continue;
                }
                if (section == null || !section.equalsIgnoreCase(SMALLICON_SECTION) || StringUtil.isEmpty((CharSequence)(smallIcon = ((TizenAccountIcon)control).getContent()))) continue;
                this.accountSmallIconText.setText(smallIcon);
                continue;
            }
            if (control instanceof DisplayName) {
                this.internalDisplayNames.add((DisplayName)control);
                continue;
            }
            if (!(control instanceof Capability)) continue;
            this.internalCapabilities.add((Capability)control);
        }
        this.displayNameViewer.setInput(this.internalDisplayNames);
        this.displayNameViewer.refresh();
        this.displayNameViewer.getTable().setEnabled(true);
        this.capabilityViewer.setInput(this.internalCapabilities);
        this.capabilityViewer.refresh();
        this.capabilityViewer.getTable().setEnabled(true);
    }

    private void createListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddAccountPage.this.validatePage();
                }
            };
        }
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    AddAccountPage.this.validatePage();
                }
            };
        }
        if (this.displayNameAddBtnSelectionListener == null) {
            this.displayNameAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (DisplayName name : AddAccountPage.this.internalDisplayNames) {
                        locales.put(name.getLang(), name.getContent());
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), locales);
                    if (dlg.open() == 0) {
                        DisplayName displayName = new DisplayName();
                        displayName.setLang(dlg.getLang());
                        displayName.setContent(dlg.getContent());
                        AddAccountPage.this.internalDisplayNames.add(displayName);
                        AddAccountPage.this.displayNameViewer.add((Object)displayName);
                        AddAccountPage.this.validatePage();
                    }
                }
            };
            this.displayNameAddBtn.addSelectionListener(this.displayNameAddBtnSelectionListener);
        }
        if (this.displayNameRemoveBtnSelectionListener == null) {
            this.displayNameRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddAccountPage.this.displayNameViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof DisplayName)) continue;
                            AddAccountPage.this.internalDisplayNames.remove(object);
                            AddAccountPage.this.displayNameViewer.remove(object);
                            AddAccountPage.this.validatePage();
                        }
                    }
                }
            };
            this.displayNameRemoveBtn.addSelectionListener(this.displayNameRemoveBtnSelectionListener);
        }
        if (this.displayNameDoubleClickListener == null) {
            this.displayNameDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)AddAccountPage.this.displayNameViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    DisplayName selectedDisplay = (DisplayName)selection.getFirstElement();
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (DisplayName name : AddAccountPage.this.internalDisplayNames) {
                        locales.put(name.getLang(), name.getContent());
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), locales);
                    dlg.editLang(selectedDisplay.getLang(), selectedDisplay.getContent());
                    if (dlg.open() == 0) {
                        selectedDisplay.setLang(dlg.getLang());
                        selectedDisplay.setContent(dlg.getContent());
                        AddAccountPage.this.displayNameViewer.update((Object)selectedDisplay, null);
                        AddAccountPage.this.validatePage();
                    }
                }
            };
        }
        if (this.displayNameViewerSelectionChangedListener == null) {
            this.displayNameViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddAccountPage.this.displayNameRemoveBtn.setEnabled(true);
                    } else {
                        AddAccountPage.this.displayNameRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.capabilityAddBtnSelectionListener == null) {
            this.capabilityAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Capability capability = new Capability();
                    capability.setContent(AddAccountPage.EMPTY_STRING);
                    AddAccountPage.this.internalCapabilities.add(capability);
                    AddAccountPage.this.capabilityViewer.add((Object)capability);
                    AddAccountPage.this.validatePage();
                }
            };
            this.capabilityAddBtn.addSelectionListener(this.capabilityAddBtnSelectionListener);
        }
        if (this.capabilityRemoveBtnSelectionListener == null) {
            this.capabilityRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddAccountPage.this.capabilityViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof Capability)) continue;
                            AddAccountPage.this.internalCapabilities.remove(object);
                            AddAccountPage.this.capabilityViewer.remove(object);
                            AddAccountPage.this.validatePage();
                        }
                    }
                }
            };
            this.capabilityRemoveBtn.addSelectionListener(this.capabilityRemoveBtnSelectionListener);
        }
        if (this.capabilityViewerSelectionChangedListener == null) {
            this.capabilityViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddAccountPage.this.capabilityRemoveBtn.setEnabled(true);
                    } else {
                        AddAccountPage.this.capabilityRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
    }

    private void addListener() {
        this.createListener();
        if (this.modifyListener != null) {
            this.accountIconText.addModifyListener(this.modifyListener);
            this.accountSmallIconText.addModifyListener(this.modifyListener);
        }
        if (this.selectionListener != null) {
            this.multipleAccountSupportCombo.addSelectionListener(this.selectionListener);
        }
        if (this.displayNameDoubleClickListener != null) {
            this.displayNameViewer.addDoubleClickListener(this.displayNameDoubleClickListener);
        }
        if (this.displayNameViewerSelectionChangedListener != null) {
            this.displayNameViewer.addSelectionChangedListener(this.displayNameViewerSelectionChangedListener);
        }
        if (this.capabilityViewerSelectionChangedListener != null) {
            this.capabilityViewer.addSelectionChangedListener(this.capabilityViewerSelectionChangedListener);
        }
    }

    protected void validatePage() {
        boolean canFinish = false;
        String message = null;
        String icon = this.accountIconText.getText();
        String smallIcon = this.accountSmallIconText.getText();
        TableItem[] items = this.displayNameViewer.getTable().getItems();
        if (!ValidationUtil.checkForWidgetIconFileExtension((String)icon) || !WebProjectUtil.isFileInTheProject((IProject)this.configurator.getProject(), (String)icon)) {
            message = MessageFormat.format(Messages.IconErrorMessage, Messages.TizenPage_Account_IconColumnLabel);
        } else if (!ValidationUtil.checkForWidgetIconFileExtension((String)smallIcon) || !WebProjectUtil.isFileInTheProject((IProject)this.configurator.getProject(), (String)smallIcon)) {
            message = MessageFormat.format(Messages.IconErrorMessage, Messages.TizenPage_Account_SmallIconColumnLabel);
        } else if (items.length == 0) {
            message = Messages.AddAccountPage_DisplayNameElement_ErrorMessage;
        } else {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                DisplayName displayName = (DisplayName)item.getData();
                if (StringUtil.isEmpty((CharSequence)displayName.getLang())) {
                    message = Messages.AddAccountPage_DisplayLangValue_ErrorMessage;
                    break;
                }
                if (StringUtil.isEmpty((CharSequence)displayName.getContent())) {
                    message = Messages.AddAccountPage_DisplayNameValue_ErrorMessage;
                    break;
                }
                ++n2;
            }
        }
        if (message == null) {
            this.crateAccount();
            canFinish = true;
        }
        this.setErrorMessage(message);
        this.setPageComplete(canFinish);
    }

    protected void crateAccount() {
        if (this.account == null) {
            this.account = new Account();
        } else {
            this.account.getIconOrDisplayNameOrCapability().clear();
        }
        if (this.multipleAccountSupportCombo.getSelectionIndex() == 0) {
            this.account.setMultipleAccountSupport(DataBoolean.TRUE);
        } else {
            this.account.setMultipleAccountSupport(DataBoolean.FALSE);
        }
        TizenAccountIcon icon = new TizenAccountIcon();
        icon.setSection(ICON_SECTION);
        icon.setContent(this.accountIconText.getText());
        this.account.getIconOrDisplayNameOrCapability().add(icon);
        TizenAccountIcon smallIcon = new TizenAccountIcon();
        smallIcon.setSection(SMALLICON_SECTION);
        smallIcon.setContent(this.accountSmallIconText.getText());
        this.account.getIconOrDisplayNameOrCapability().add(smallIcon);
        this.account.getIconOrDisplayNameOrCapability().addAll(this.internalDisplayNames);
        this.account.getIconOrDisplayNameOrCapability().addAll(this.internalCapabilities);
    }

    public Account getAccount() {
        return this.account;
    }
}

