/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.appcontrol;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.common.WebConstant;
import org.tizen.web.config.schema.model.ActivationType;
import org.tizen.web.config.schema.model.AppControl;
import org.tizen.web.config.schema.model.Mime;
import org.tizen.web.config.schema.model.Operation;
import org.tizen.web.config.schema.model.Src;
import org.tizen.web.config.schema.model.Uri;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;
import org.tizen.web.editor.configuration.tizen.appcontrol.AppControlColumn;

public class AppControlEditingSupport
extends EditingSupport {
    private AppControlColumn column;
    private CellEditor editor;
    private AbstractChangeListener listener;
    private static final String EMPTY_STRING = "";
    private static final String NONE_STRING = "none";
    private String appcontrolOperation = "";
    private String appcontrolReload = "none";

    public AppControlEditingSupport(ColumnViewer viewer, AppControlColumn column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case SRC: 
            case URI: 
            case MIME: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case OPERATION: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), WebConstant.APPCONTROL_OPERATION_TYPES, 4){

                    protected Object doGetValue() {
                        String tempOperation = ((CCombo)this.getControl()).getText();
                        if (!tempOperation.isEmpty()) {
                            AppControlEditingSupport.this.appcontrolOperation = tempOperation;
                        }
                        return AppControlEditingSupport.this.appcontrolOperation;
                    }
                };
                break;
            }
            case RELOAD: {
                if (!(viewer instanceof TableViewer)) break;
                String[] reloadTypes = this.getReloadTypes();
                this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), reloadTypes, 4){

                    protected Object doGetValue() {
                        String tempReload = ((CCombo)this.getControl()).getText();
                        if (!tempReload.isEmpty()) {
                            AppControlEditingSupport.this.appcontrolReload = tempReload;
                        }
                        return AppControlEditingSupport.this.appcontrolReload;
                    }
                };
                break;
            }
        }
    }

    private String[] getReloadTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(NONE_STRING);
        ActivationType[] activationTypeArray = ActivationType.values();
        int n = activationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivationType at = activationTypeArray[n2];
            types.add(at.name().toLowerCase());
            ++n2;
        }
        return types.toArray(new String[0]);
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case SRC: 
            case OPERATION: 
            case URI: 
            case MIME: 
            case RELOAD: {
                return true;
            }
        }
        return false;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof AppControl)) {
            return null;
        }
        AppControl appControl = (AppControl)element;
        switch (this.column) {
            case SRC: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String src;
                    if (!(control instanceof Src) || (src = ((Src)control).getName()) == null) continue;
                    return src;
                }
                return EMPTY_STRING;
            }
            case URI: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String uri;
                    if (!(control instanceof Uri) || (uri = ((Uri)control).getName()) == null) continue;
                    return uri;
                }
                return EMPTY_STRING;
            }
            case MIME: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    String mime;
                    if (!(control instanceof Mime) || (mime = ((Mime)control).getName()) == null) continue;
                    return mime;
                }
                return EMPTY_STRING;
            }
            case OPERATION: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    if (!(control instanceof Operation)) continue;
                    String operation = ((Operation)control).getName();
                    int index = 0;
                    while (index < WebConstant.APPCONTROL_OPERATION_TYPES.length) {
                        if (operation.equals(WebConstant.APPCONTROL_OPERATION_TYPES[index])) {
                            return index;
                        }
                        ++index;
                    }
                    this.appcontrolOperation = operation;
                }
                return -1;
            }
            case RELOAD: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    ActivationType reload;
                    if (!(control instanceof Src) || (reload = ((Src)control).getReload()) == null) continue;
                    String[] types = this.getReloadTypes();
                    int i = 0;
                    while (i < types.length) {
                        if (reload.name().equalsIgnoreCase(types[i])) {
                            return i;
                        }
                        ++i;
                    }
                    this.appcontrolReload = reload.name().toLowerCase();
                }
                return 0;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof AppControl)) {
            return;
        }
        AppControl appControl = (AppControl)element;
        switch (this.column) {
            case SRC: {
                Src src = null;
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    if (!(control instanceof Src)) continue;
                    src = (Src)control;
                }
                if (src == null) {
                    src = new Src();
                    appControl.getSrcOrOperationOrUri().add(src);
                }
                src.setName((String)value);
                break;
            }
            case OPERATION: {
                Operation operation = null;
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    if (!(control instanceof Operation)) continue;
                    operation = (Operation)control;
                }
                if (operation == null) {
                    operation = new Operation();
                    appControl.getSrcOrOperationOrUri().add(operation);
                }
                operation.setName((String)value);
                break;
            }
            case URI: {
                Uri uri = null;
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    if (!(control instanceof Uri)) continue;
                    uri = (Uri)control;
                }
                if (uri == null) {
                    uri = new Uri();
                    appControl.getSrcOrOperationOrUri().add(uri);
                }
                uri.setName((String)value);
                break;
            }
            case MIME: {
                Mime mime = null;
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    if (!(control instanceof Mime)) continue;
                    mime = (Mime)control;
                }
                if (mime == null) {
                    mime = new Mime();
                    appControl.getSrcOrOperationOrUri().add(mime);
                }
                mime.setName((String)value);
                break;
            }
            case RELOAD: {
                for (Object control : appControl.getSrcOrOperationOrUri()) {
                    if (!(control instanceof Src)) continue;
                    ActivationType reload = null;
                    try {
                        reload = ActivationType.fromValue((String)((String)value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    ((Src)control).setReload(reload);
                }
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

