/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.dynamicbox.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.dialog.LocaleDialog;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.core.WebProjectUtil;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.BoxContent;
import org.tizen.web.config.schema.model.BoxIcon;
import org.tizen.web.config.schema.model.BoxLabel;
import org.tizen.web.config.schema.model.BoxSize;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.Pd;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.tizen.dynamicbox.support.BoxLabelContentProvider;
import org.tizen.web.editor.configuration.tizen.dynamicbox.support.BoxLabelEditingSupport;
import org.tizen.web.editor.configuration.tizen.dynamicbox.support.BoxLabelLabelProvider;

public class AddDynamicBoxPage
extends WizardPage {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final int DEFAULT_UPDATE_PERIOD_MIN = 1800;
    public static final int DEFAULT_UPDATE_PERIOD_MAX = Integer.MAX_VALUE;
    public static final int DEFAULT_PD_WIDTH = 720;
    public static final int DEFAULT_PD_MIN = 1;
    public static final int DEFAULT_PD_MAX = 380;
    public static final String DOT = ".";
    public static final String STAR = "*";
    public static final String EMPTY = "";
    private ITizenConfigurator configurator;
    private AppWidget dynamicbox;
    private Boolean bEditMode;
    private Text appIdText;
    private Text appIdInputText;
    private List<BoxLabel> internalBoxlabels;
    private Group boxlabelGroup;
    private TableViewer boxlabelViewer;
    private BoxLabelEditingSupport boxlabelLangEditingSupport;
    private BoxLabelEditingSupport boxlabelContentEditingSupport;
    private Button boxlabelAddBtn;
    private Button boxlabelRemoveBtn;
    private SelectionListener boxlabelAddBtnSelectionListener;
    private SelectionListener boxlabelRemoveBtnSelectionListener;
    private ISelectionChangedListener boxlabelViewerSelectionChangedListener;
    private IDoubleClickListener boxlabelViewerDoubleClickListener;
    private Text boxIconText;
    private Text boxContentText;
    private Combo primaryCombo;
    private Combo autoLaunchCombo;
    private Button updatePeriodCheckBox;
    private Spinner updatePeriodSpinner;
    private Combo mouseEventCombo;
    private Combo touchEffectCombo;
    private Button _1x1Button;
    private Button _2x1Button;
    private Button _2x2Button;
    private Label _1x1UserDecorationLabel;
    private Label _2x1UserDecorationLabel;
    private Label _2x2UserDecorationLabel;
    private Combo _1x1UserDecorationCombo;
    private Combo _2x1UserDecorationCombo;
    private Combo _2x2UserDecorationCombo;
    private Text _1x1IconText;
    private Text _2x1IconText;
    private Text _2x2IconText;
    private Button _1x1BrowserButton;
    private Button _2x1BrowserButton;
    private Button _2x2BrowserButton;
    private Button pdCheckbox;
    private Group pdGroup;
    private Text pdSrcText;
    private Button pdSrcBrowserButton;
    private Text pdWidthText;
    private Spinner pdHeightSpinner;
    private ModifyListener modifyListener;
    private SelectionListener selectionListener;
    private SelectionListener updatePeriodSelectionListener;
    private SelectionListener boxSizeSelectionListener;
    private SelectionListener pdSelectionListener;

    protected AddDynamicBoxPage(String pageName, ITizenConfigurator configurator) {
        super(pageName);
        this.setPageComplete(false);
        this.configurator = configurator;
        this.bEditMode = false;
    }

    public AddDynamicBoxPage(String pageName, ITizenConfigurator configurator, AppWidget dynamicbox) {
        super(pageName);
        this.setPageComplete(true);
        this.configurator = configurator;
        this.dynamicbox = dynamicbox;
        this.bEditMode = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        ScrolledComposite scrolledRootComposite = new ScrolledComposite(parent, 768);
        scrolledRootComposite.setExpandHorizontal(true);
        scrolledRootComposite.setExpandVertical(true);
        Composite innerComposite = new Composite((Composite)scrolledRootComposite, 0);
        innerComposite.setLayout((Layout)new GridLayout(1, false));
        innerComposite.setLayoutData((Object)new GridData(768));
        this.createDynamicBoxControl(innerComposite);
        this.createDynamicBoxSizeControl(innerComposite);
        this.createDynamicBoxPdControl(innerComposite);
        if (this.bEditMode.booleanValue()) {
            this.loadDynamicBoxData();
            this.validatePage();
        }
        this.addListener();
        scrolledRootComposite.setContent((Control)innerComposite);
        scrolledRootComposite.setMinSize(innerComposite.computeSize(-1, -1));
        Dialog.applyDialogFont((Control)scrolledRootComposite);
        this.setControl((Control)scrolledRootComposite);
    }

    private void createDynamicBoxControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        this.appIdText = SWTUtil.createText((Composite)container, (String)(String.valueOf(Messages.TizenPage_DynamicBoxIdTextLabel) + STAR), (String)Messages.TizenPage_DynamicBoxIdTextTooltip, (int)1, (int)0);
        this.appIdText.setText(String.valueOf(this.configurator.getApplicationAppID()) + DOT);
        this.appIdText.setEnabled(false);
        this.appIdText.setLayoutData((Object)new GridData(4, 2, false, false));
        this.appIdInputText = new Text(container, 2048);
        this.appIdInputText.setLayoutData((Object)new GridData(4, 2, false, false));
        this.internalBoxlabels = new ArrayList<BoxLabel>();
        this.boxlabelGroup = new Group(container, 0);
        this.boxlabelGroup.setText(String.valueOf(Messages.TizenPage_DynamicBoxBoxLabelTextLabel) + STAR);
        this.boxlabelGroup.setToolTipText(Messages.TizenPage_DynamicBoxBoxLabelTextTooltip);
        this.boxlabelGroup.setLayout((Layout)new GridLayout(2, false));
        GridData tableViewGroupGridData = new GridData(1808);
        tableViewGroupGridData.heightHint = 120;
        tableViewGroupGridData.horizontalSpan = 3;
        this.boxlabelGroup.setLayoutData((Object)tableViewGroupGridData);
        Composite boxlabelTableComposite = new Composite((Composite)this.boxlabelGroup, 0);
        boxlabelTableComposite.setLayout((Layout)new GridLayout(1, false));
        boxlabelTableComposite.setLayoutData((Object)new GridData(1808));
        this.boxlabelViewer = new TableViewer(boxlabelTableComposite, 68354);
        Table boxlabelTable = this.boxlabelViewer.getTable();
        boxlabelTable.setHeaderVisible(true);
        boxlabelTable.setLinesVisible(true);
        boxlabelTable.setLayoutData((Object)new GridData(1808));
        TableViewerColumn langColumn = new TableViewerColumn(this.boxlabelViewer, 0);
        langColumn.getColumn().setText(Messages.AddAccountPage_DisplayName_LangLabel);
        langColumn.getColumn().setToolTipText(Messages.AddAccountPage_DisplayName_LangTooltip);
        this.boxlabelLangEditingSupport = new BoxLabelEditingSupport((ColumnViewer)this.boxlabelViewer, 0);
        langColumn.setEditingSupport((EditingSupport)this.boxlabelLangEditingSupport);
        TableViewerColumn nameColumn = new TableViewerColumn(this.boxlabelViewer, 0);
        nameColumn.getColumn().setText(Messages.AddAccountPage_DisplayName_NameLabel);
        nameColumn.getColumn().setToolTipText(Messages.AddAccountPage_DisplayName_NameTooltip);
        this.boxlabelContentEditingSupport = new BoxLabelEditingSupport((ColumnViewer)this.boxlabelViewer, 1);
        nameColumn.setEditingSupport((EditingSupport)this.boxlabelContentEditingSupport);
        TableLayout boxlabelTableLayout = new TableLayout();
        boxlabelTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        boxlabelTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2));
        this.boxlabelViewer.getTable().setLayout((Layout)boxlabelTableLayout);
        BoxLabelContentProvider boxlabeContentProvider = new BoxLabelContentProvider();
        BoxLabelLabelProvider boxlabeTableLabelProvider = new BoxLabelLabelProvider();
        this.boxlabelViewer.setContentProvider((IContentProvider)boxlabeContentProvider);
        this.boxlabelViewer.setLabelProvider((IBaseLabelProvider)boxlabeTableLabelProvider);
        Composite buttons = new Composite((Composite)this.boxlabelGroup, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(2));
        this.boxlabelAddBtn = SWTUtil.createButton((Composite)buttons, (String)Messages.AddButtonLabel, (String)Messages.AddButtonLabel);
        this.boxlabelRemoveBtn = SWTUtil.createButton((Composite)buttons, (String)Messages.RemoveButtonLabel, (String)Messages.RemoveButtonLabel);
        this.boxlabelRemoveBtn.setEnabled(false);
        this.boxIconText = SWTUtil.createText((Composite)container, (String)(String.valueOf(Messages.TizenPage_DynamicBoxIconTextLabel) + STAR), (String)Messages.TizenPage_DynamicBoxIconTextTooltip, (int)1, (int)0);
        SWTUtil.createFileBrowserButton((Composite)container, (Text)this.boxIconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
        this.boxContentText = SWTUtil.createText((Composite)container, (String)(String.valueOf(Messages.TizenPage_DynamicBoxContentTextLabel) + STAR), (String)Messages.TizenPage_DynamicBoxContentTextTooltip, (int)1, (int)0);
        SWTUtil.createFileBrowserButton((Composite)container, (Text)this.boxContentText, (String[])WebConstant.HTML_FILTER_EXTENSIONS);
        this.primaryCombo = SWTUtil.createEnumCombo((Composite)container, (String)(String.valueOf(Messages.TizenPage_DynamicBoxPrimaryTextLabel) + STAR), (String)Messages.TizenPage_DynamicBoxPrimaryTextTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.TRUE.ordinal());
        this.primaryCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 0));
        this.autoLaunchCombo = SWTUtil.createEnumCombo((Composite)container, (String)Messages.TizenPage_DynamicBoxLaunchTextLabel, (String)Messages.TizenPage_DynamicBoxLaunchTextTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.FALSE.ordinal());
        this.autoLaunchCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 0));
        this.updatePeriodCheckBox = SWTUtil.createCheckbox((Composite)container, (String)Messages.TizenPage_DynamicBoxPeriodTextLabel, (String)Messages.TizenPage_DynamicBoxPeriodTextTooltip, (boolean)false, (boolean)true);
        this.updatePeriodSpinner = new Spinner(container, 2048);
        this.updatePeriodSpinner.setMaximum(Integer.MAX_VALUE);
        this.updatePeriodSpinner.setMinimum(1800);
        this.updatePeriodSpinner.setLayoutData((Object)new GridData(4, 2, true, false, 2, 0));
        this.updatePeriodSpinner.setEnabled(false);
        this.mouseEventCombo = SWTUtil.createEnumCombo((Composite)container, (String)Messages.TizenPage_DynamicBoxMouseEventComboTextLabel, (String)Messages.TizenPage_DynamicBoxMouseEventComboTextTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.FALSE.ordinal());
        this.mouseEventCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 0));
        this.touchEffectCombo = SWTUtil.createEnumCombo((Composite)container, (String)Messages.TizenPage_DynamicBoxTouchEffectComboTextLabel, (String)Messages.TizenPage_DynamicBoxTouchEffectComboTextTooltip, (Enum[])DataBoolean.values(), (int)DataBoolean.TRUE.ordinal());
        this.touchEffectCombo.setLayoutData((Object)new GridData(4, 2, true, false, 2, 0));
    }

    private void createDynamicBoxSizeControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.TizenPage_DynamicBoxBoxSizeTextLabel);
        group.setToolTipText(Messages.TizenPage_DynamicBoxBoxSizeTextTooltip);
        group.setLayout((Layout)new GridLayout(5, false));
        group.setLayoutData((Object)new GridData(768));
        this._1x1Button = SWTUtil.createCheckbox((Composite)group, (String)Messages.TizenPage_DynamicBoxSize1x1CheckboxLabel, (String)Messages.TizenPage_DynamicBoxSize1x1CheckboxLabel, (boolean)true, (boolean)false);
        this._1x1IconText = new Text((Composite)group, 2048);
        this._1x1IconText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._1x1BrowserButton = SWTUtil.createFileBrowserButton((Composite)group, (Text)this._1x1IconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
        this._1x1UserDecorationLabel = SWTUtil.createLabel((Composite)group, (String)Messages.TizenPage_DynamicBoxBoxSizeUseDecorationTextLabel, (String)Messages.TizenPage_DynamicBoxBoxSizeUseDecorationTextTooltip);
        String[] contents = StringUtil.enumNameToStringArray((Enum[])DataBoolean.values());
        int i = 0;
        while (i < contents.length) {
            contents[i] = contents[i].toLowerCase();
            ++i;
        }
        this._1x1UserDecorationCombo = SWTUtil.createCombo((Composite)group, (String[])contents, (int)DataBoolean.TRUE.ordinal());
        this._1x1UserDecorationCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this._2x1Button = SWTUtil.createCheckbox((Composite)group, (String)Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel, (String)Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel, (boolean)false, (boolean)true);
        this._2x1IconText = new Text((Composite)group, 2048);
        this._2x1IconText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._2x1IconText.setEnabled(false);
        this._2x1BrowserButton = SWTUtil.createFileBrowserButton((Composite)group, (Text)this._2x1IconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
        this._2x1BrowserButton.setEnabled(false);
        this._2x1UserDecorationLabel = SWTUtil.createLabel((Composite)group, (String)Messages.TizenPage_DynamicBoxBoxSizeUseDecorationTextLabel, (String)Messages.TizenPage_DynamicBoxBoxSizeUseDecorationTextTooltip);
        this._2x1UserDecorationLabel.setEnabled(false);
        this._2x1UserDecorationCombo = SWTUtil.createCombo((Composite)group, (String[])contents, (int)DataBoolean.TRUE.ordinal());
        this._2x1UserDecorationCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this._2x1UserDecorationCombo.setEnabled(false);
        this._2x2Button = SWTUtil.createCheckbox((Composite)group, (String)Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel, (String)Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel, (boolean)false, (boolean)true);
        this._2x2IconText = new Text((Composite)group, 2048);
        this._2x2IconText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._2x2IconText.setEnabled(false);
        this._2x2BrowserButton = SWTUtil.createFileBrowserButton((Composite)group, (Text)this._2x2IconText, (String[])WebConstant.ICON_FILTER_EXTENSIONS);
        this._2x2BrowserButton.setEnabled(false);
        this._2x2UserDecorationLabel = SWTUtil.createLabel((Composite)group, (String)Messages.TizenPage_DynamicBoxBoxSizeUseDecorationTextLabel, (String)Messages.TizenPage_DynamicBoxBoxSizeUseDecorationTextTooltip);
        this._2x2UserDecorationLabel.setEnabled(false);
        this._2x2UserDecorationCombo = SWTUtil.createCombo((Composite)group, (String[])contents, (int)DataBoolean.TRUE.ordinal());
        this._2x2UserDecorationCombo.setLayoutData((Object)new GridData(4, 2, true, false));
        this._2x2UserDecorationCombo.setEnabled(false);
    }

    private void createDynamicBoxPdControl(Composite parent) {
        this.pdCheckbox = SWTUtil.createCheckbox((Composite)parent, (String)Messages.TizenPage_DynamicBoxPdTextLabel, (String)Messages.TizenPage_DynamicBoxPdTextLabel, (boolean)false, (boolean)true);
        this.pdGroup = new Group(parent, 32);
        this.pdGroup.setText(Messages.TizenPage_DynamicBoxPdTextLabel);
        this.pdGroup.setToolTipText(Messages.TizenPage_DynamicBoxPdTextTooltip);
        this.pdGroup.setLayout((Layout)new GridLayout(3, false));
        this.pdGroup.setLayoutData((Object)new GridData(768));
        this.pdSrcText = SWTUtil.createText((Composite)this.pdGroup, (String)Messages.TizenPage_DynamicBoxPdSrcTextLabel, (String)Messages.TizenPage_DynamicBoxPdSrcTextTooltip, (int)1, (int)0);
        this.pdSrcBrowserButton = SWTUtil.createFileBrowserButton((Composite)this.pdGroup, (Text)this.pdSrcText, (String[])WebConstant.HTML_FILTER_EXTENSIONS);
        this.pdWidthText = SWTUtil.createText((Composite)this.pdGroup, (String)Messages.TizenPage_DynamicBoxPdWidthTextLabel, (String)Messages.TizenPage_DynamicBoxPdWidthTextTooltip, (int)2, (int)0);
        this.pdWidthText.setText("fixed as device width");
        this.pdWidthText.setEnabled(false);
        this.pdHeightSpinner = SWTUtil.createSpinner((Composite)this.pdGroup, (String)Messages.TizenPage_DynamicBoxPdHeightTextLabel, (String)Messages.TizenPage_DynamicBoxPdHeightTextTooltip, (int)1, (int)380);
        this.pdHeightSpinner.setLayoutData((Object)new GridData(4, 2, true, false, 2, 0));
        this.setEnablePdControl(false);
    }

    private void setEnablePdControl(boolean enabled) {
        this.pdSrcText.setEnabled(enabled);
        this.pdSrcBrowserButton.setEnabled(enabled);
        this.pdHeightSpinner.setEnabled(enabled);
    }

    private void loadDynamicBoxData() {
        this.appIdInputText.setText(this.dynamicbox.getId().replace(String.valueOf(this.configurator.getApplicationAppID()) + DOT, EMPTY));
        if (this.dynamicbox.getPrimary() == DataBoolean.TRUE) {
            this.primaryCombo.select(0);
        } else {
            this.primaryCombo.select(1);
        }
        if (this.dynamicbox.getAutoLaunch() == DataBoolean.TRUE) {
            this.autoLaunchCombo.select(0);
        } else {
            this.autoLaunchCombo.select(1);
        }
        try {
            float updatePeriod = this.dynamicbox.getUpdatePeriod().floatValue();
            if (updatePeriod < 1800.0f) {
                this.updatePeriodSpinner.setSelection(1800);
                this.updatePeriodSpinner.setEnabled(false);
                this.updatePeriodCheckBox.setSelection(false);
            } else {
                this.updatePeriodCheckBox.setSelection(true);
                this.updatePeriodSpinner.setEnabled(true);
                this.updatePeriodSpinner.setSelection(Math.round(updatePeriod));
            }
        }
        catch (NullPointerException nullPointerException) {
            this.logger.trace("update-period value is null");
            this.updatePeriodSpinner.setSelection(1800);
            this.updatePeriodSpinner.setEnabled(false);
            this.updatePeriodCheckBox.setSelection(false);
        }
        for (Object obj : this.dynamicbox.getContent()) {
            String src;
            if (obj instanceof BoxLabel) {
                this.internalBoxlabels.add((BoxLabel)obj);
                continue;
            }
            if (obj instanceof BoxIcon) {
                BoxIcon boxicon = (BoxIcon)obj;
                src = boxicon.getSrc();
                if (StringUtil.isEmpty((CharSequence)src)) continue;
                this.boxIconText.setText(src);
                continue;
            }
            if (!(obj instanceof BoxContent)) continue;
            BoxContent boxContent = (BoxContent)obj;
            src = boxContent.getSrc();
            if (!StringUtil.isEmpty((CharSequence)src)) {
                this.boxContentText.setText(src);
            }
            if (boxContent.getMouseEvent() == DataBoolean.TRUE) {
                this.mouseEventCombo.select(0);
            } else {
                this.mouseEventCombo.select(1);
            }
            if (boxContent.getTouchEffect() == DataBoolean.TRUE) {
                this.touchEffectCombo.select(0);
            } else {
                this.touchEffectCombo.select(1);
            }
            for (Object content : boxContent.getContent()) {
                if (content instanceof BoxSize) {
                    BoxSize size = (BoxSize)content;
                    String label = size.getContent();
                    String preview = size.getPreview();
                    DataBoolean useDecoration = size.getUseDecoration();
                    if (useDecoration == null) {
                        useDecoration = DataBoolean.TRUE;
                    }
                    if (Messages.TizenPage_DynamicBoxSize1x1CheckboxLabel.equals(label)) {
                        if (!StringUtil.isEmpty((CharSequence)preview)) {
                            this._1x1IconText.setText(preview);
                        }
                        this._1x1UserDecorationLabel.setEnabled(true);
                        this._1x1UserDecorationCombo.setEnabled(true);
                        this._1x1UserDecorationCombo.select(useDecoration.ordinal());
                        continue;
                    }
                    if (Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel.equals(label)) {
                        this._2x1Button.setSelection(true);
                        this._2x1IconText.setEnabled(true);
                        this._2x1BrowserButton.setEnabled(true);
                        if (!StringUtil.isEmpty((CharSequence)preview)) {
                            this._2x1IconText.setText(preview);
                        }
                        this._2x1UserDecorationLabel.setEnabled(true);
                        this._2x1UserDecorationCombo.setEnabled(true);
                        this._2x1UserDecorationCombo.select(useDecoration.ordinal());
                        continue;
                    }
                    if (!Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel.equals(label)) continue;
                    this._2x2Button.setSelection(true);
                    this._2x2IconText.setEnabled(true);
                    this._2x2BrowserButton.setEnabled(true);
                    if (!StringUtil.isEmpty((CharSequence)preview)) {
                        this._2x2IconText.setText(preview);
                    }
                    this._2x2UserDecorationLabel.setEnabled(true);
                    this._2x2UserDecorationCombo.setEnabled(true);
                    this._2x2UserDecorationCombo.select(useDecoration.ordinal());
                    continue;
                }
                if (!(content instanceof Pd)) continue;
                this.pdCheckbox.setSelection(true);
                this.setEnablePdControl(true);
                Pd pd = (Pd)content;
                String pdSrc = pd.getSrc();
                int height = pd.getHeight();
                if (!StringUtil.isEmpty((CharSequence)pdSrc)) {
                    this.pdSrcText.setText(pdSrc);
                }
                this.pdHeightSpinner.setSelection(height);
            }
        }
        this.boxlabelViewer.setInput(this.internalBoxlabels);
        this.boxlabelViewer.refresh();
        this.boxlabelViewer.getTable().setEnabled(true);
    }

    private void createListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddDynamicBoxPage.this.validatePage();
                }
            };
        }
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AddDynamicBoxPage.this.validatePage();
                }
            };
        }
        if (this.boxlabelAddBtnSelectionListener == null) {
            this.boxlabelAddBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HashMap<String, String> boxlabels = new HashMap<String, String>();
                    for (BoxLabel boxlabel : AddDynamicBoxPage.this.internalBoxlabels) {
                        String lang = boxlabel.getLang();
                        if (StringUtil.isEmpty((CharSequence)lang)) {
                            lang = AddDynamicBoxPage.EMPTY;
                        }
                        String content = boxlabel.getContent();
                        boxlabels.put(lang, content);
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), boxlabels);
                    dlg.setCustomLang(AddDynamicBoxPage.EMPTY);
                    if (dlg.open() == 0) {
                        BoxLabel boxlabel = new BoxLabel();
                        boxlabel.setLang(dlg.getLang());
                        boxlabel.setContent(dlg.getContent());
                        AddDynamicBoxPage.this.internalBoxlabels.add(boxlabel);
                        AddDynamicBoxPage.this.boxlabelViewer.add((Object)boxlabel);
                        AddDynamicBoxPage.this.validatePage();
                    }
                }
            };
            this.boxlabelAddBtn.addSelectionListener(this.boxlabelAddBtnSelectionListener);
        }
        if (this.boxlabelRemoveBtnSelectionListener == null) {
            this.boxlabelRemoveBtnSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = AddDynamicBoxPage.this.boxlabelViewer.getSelection();
                    if (selection instanceof IStructuredSelection) {
                        for (Object object : (IStructuredSelection)selection) {
                            if (!(object instanceof BoxLabel)) continue;
                            AddDynamicBoxPage.this.internalBoxlabels.remove(object);
                            AddDynamicBoxPage.this.boxlabelViewer.remove(object);
                            AddDynamicBoxPage.this.validatePage();
                        }
                    }
                }
            };
            this.boxlabelRemoveBtn.addSelectionListener(this.boxlabelRemoveBtnSelectionListener);
        }
        if (this.boxlabelViewerSelectionChangedListener == null) {
            this.boxlabelViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty()) {
                        AddDynamicBoxPage.this.boxlabelRemoveBtn.setEnabled(true);
                    } else {
                        AddDynamicBoxPage.this.boxlabelRemoveBtn.setEnabled(false);
                    }
                }
            };
        }
        if (this.boxlabelViewerDoubleClickListener == null) {
            this.boxlabelViewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)AddDynamicBoxPage.this.boxlabelViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    BoxLabel selectedDisplay = (BoxLabel)selection.getFirstElement();
                    HashMap<String, String> locales = new HashMap<String, String>();
                    for (BoxLabel name : AddDynamicBoxPage.this.internalBoxlabels) {
                        String lang = name.getLang();
                        if (StringUtil.isEmpty((CharSequence)lang)) {
                            lang = AddDynamicBoxPage.EMPTY;
                        }
                        String content = name.getContent();
                        locales.put(lang, content);
                    }
                    LocaleDialog dlg = new LocaleDialog(SWTUtil.getActiveShell(), locales);
                    dlg.setCustomLang(AddDynamicBoxPage.EMPTY);
                    dlg.editLang(selectedDisplay.getLang(), selectedDisplay.getContent());
                    if (dlg.open() == 0) {
                        selectedDisplay.setLang(dlg.getLang());
                        selectedDisplay.setContent(dlg.getContent());
                        AddDynamicBoxPage.this.boxlabelViewer.update((Object)selectedDisplay, null);
                        AddDynamicBoxPage.this.validatePage();
                    }
                }
            };
        }
        if (this.updatePeriodSelectionListener == null) {
            this.updatePeriodSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkbox = (Button)e.widget;
                    if (checkbox.getSelection()) {
                        AddDynamicBoxPage.this.updatePeriodSpinner.setEnabled(true);
                    } else {
                        AddDynamicBoxPage.this.updatePeriodSpinner.setEnabled(false);
                    }
                    AddDynamicBoxPage.this.validatePage();
                }
            };
        }
        if (this.boxSizeSelectionListener == null) {
            this.boxSizeSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkbox = (Button)e.widget;
                    String label = checkbox.getText();
                    if (checkbox.getSelection()) {
                        if (Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel.equals(label)) {
                            AddDynamicBoxPage.this._2x1IconText.setEnabled(true);
                            AddDynamicBoxPage.this._2x1BrowserButton.setEnabled(true);
                            AddDynamicBoxPage.this._2x1UserDecorationLabel.setEnabled(true);
                            AddDynamicBoxPage.this._2x1UserDecorationCombo.setEnabled(true);
                        } else if (Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel.equals(label)) {
                            AddDynamicBoxPage.this._2x2IconText.setEnabled(true);
                            AddDynamicBoxPage.this._2x2BrowserButton.setEnabled(true);
                            AddDynamicBoxPage.this._2x2UserDecorationLabel.setEnabled(true);
                            AddDynamicBoxPage.this._2x2UserDecorationCombo.setEnabled(true);
                        }
                    } else if (Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel.equals(label)) {
                        AddDynamicBoxPage.this._2x1IconText.setText(AddDynamicBoxPage.EMPTY);
                        AddDynamicBoxPage.this._2x1IconText.setEnabled(false);
                        AddDynamicBoxPage.this._2x1BrowserButton.setEnabled(false);
                        AddDynamicBoxPage.this._2x1UserDecorationLabel.setEnabled(false);
                        AddDynamicBoxPage.this._2x1UserDecorationCombo.setEnabled(false);
                    } else if (Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel.equals(label)) {
                        AddDynamicBoxPage.this._2x2IconText.setText(AddDynamicBoxPage.EMPTY);
                        AddDynamicBoxPage.this._2x2IconText.setEnabled(false);
                        AddDynamicBoxPage.this._2x2BrowserButton.setEnabled(false);
                        AddDynamicBoxPage.this._2x2UserDecorationLabel.setEnabled(false);
                        AddDynamicBoxPage.this._2x2UserDecorationCombo.setEnabled(false);
                    }
                    AddDynamicBoxPage.this.validatePage();
                }
            };
        }
        if (this.pdSelectionListener == null) {
            this.pdSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkbox = (Button)e.widget;
                    if (checkbox.getSelection()) {
                        AddDynamicBoxPage.this.setEnablePdControl(true);
                    } else {
                        AddDynamicBoxPage.this.setEnablePdControl(false);
                    }
                    AddDynamicBoxPage.this.validatePage();
                }
            };
        }
    }

    private void addListener() {
        this.createListener();
        if (this.boxlabelViewerDoubleClickListener != null) {
            this.boxlabelViewer.addDoubleClickListener(this.boxlabelViewerDoubleClickListener);
        }
        if (this.modifyListener != null) {
            this.appIdInputText.addModifyListener(this.modifyListener);
            this.updatePeriodSpinner.addModifyListener(this.modifyListener);
            this.boxIconText.addModifyListener(this.modifyListener);
            this.boxContentText.addModifyListener(this.modifyListener);
            this._1x1IconText.addModifyListener(this.modifyListener);
            this._2x1IconText.addModifyListener(this.modifyListener);
            this._2x2IconText.addModifyListener(this.modifyListener);
            this.pdSrcText.addModifyListener(this.modifyListener);
            this.pdHeightSpinner.addModifyListener(this.modifyListener);
        }
        if (this.selectionListener != null) {
            this.primaryCombo.addSelectionListener(this.selectionListener);
            this.autoLaunchCombo.addSelectionListener(this.selectionListener);
            this.mouseEventCombo.addSelectionListener(this.selectionListener);
            this.touchEffectCombo.addSelectionListener(this.selectionListener);
            this._1x1UserDecorationCombo.addSelectionListener(this.selectionListener);
            this._2x1UserDecorationCombo.addSelectionListener(this.selectionListener);
            this._2x2UserDecorationCombo.addSelectionListener(this.selectionListener);
        }
        if (this.updatePeriodSelectionListener != null) {
            this.updatePeriodCheckBox.addSelectionListener(this.updatePeriodSelectionListener);
        }
        if (this.boxlabelViewerSelectionChangedListener != null) {
            this.boxlabelViewer.addSelectionChangedListener(this.boxlabelViewerSelectionChangedListener);
        }
        if (this.boxSizeSelectionListener != null) {
            this._2x1Button.addSelectionListener(this.boxSizeSelectionListener);
            this._2x2Button.addSelectionListener(this.boxSizeSelectionListener);
        }
        if (this.pdSelectionListener != null) {
            this.pdCheckbox.addSelectionListener(this.pdSelectionListener);
        }
    }

    private boolean isContainAppID(List<AppWidget> dynamicboxes, String appid) {
        for (AppWidget dynamicbox : dynamicboxes) {
            if (!appid.equals(dynamicbox.getId()) || this.bEditMode.booleanValue() && appid.equals(this.dynamicbox.getId())) continue;
            return true;
        }
        return false;
    }

    protected void validatePage() {
        boolean canFinish = false;
        String message = null;
        String box_id = this.appIdInputText.getText();
        String dynamicBoxID = String.valueOf(this.appIdText.getText()) + box_id;
        TableItem[] boxlabelItems = this.boxlabelViewer.getTable().getItems();
        String box_icon = this.boxIconText.getText();
        String box_content = this.boxContentText.getText();
        String _1x1SizePreview = this._1x1IconText.getText();
        String _2x1SizePreview = this._2x1IconText.getText();
        String _2x2SizePreview = this._2x2IconText.getText();
        if (StringUtil.isEmpty((CharSequence)box_id) || !ValidationUtil.checkForDynamicBoxId((String)dynamicBoxID)) {
            message = Messages.AddDynamicBoxPage_DynamicBoxIdErrorMessage;
        } else if (!StringUtil.isEmpty((CharSequence)box_id) && this.isContainAppID(((IMobileConfigurator)this.configurator).getDynamicBoxes(), String.valueOf(this.appIdText.getText()) + box_id)) {
            message = Messages.AddDynamicBoxPage_DynamicBoxIdDuplicationErrorMessage;
        } else if (!ValidationUtil.checkForWidgetIconFileExtension((String)box_icon) || !this.isFileInTheProject(box_icon)) {
            message = MessageFormat.format(Messages.IconErrorMessage, Messages.TizenPage_DynamicBoxIconTextLabel);
        } else if (!this.isFileInTheProject(box_content) && !ValidationUtil.checkForURL((String)box_content)) {
            message = Messages.AddDynamicBoxPage_DynamicBoxBoxContentErrorMessage;
        } else if (!(!this._1x1Button.getSelection() || StringUtil.isEmpty((CharSequence)_1x1SizePreview) || this.isFileInTheProject(_1x1SizePreview) && ValidationUtil.checkForWidgetIconFileExtension((String)_1x1SizePreview))) {
            message = MessageFormat.format(Messages.AddDynamicBoxPage_DynamicBoxBoxSizePreviewErrorMessage, Messages.TizenPage_DynamicBoxSize1x1CheckboxLabel);
        } else if (!(!this._2x1Button.getSelection() || StringUtil.isEmpty((CharSequence)_2x1SizePreview) || this.isFileInTheProject(_2x1SizePreview) && ValidationUtil.checkForWidgetIconFileExtension((String)_2x1SizePreview))) {
            message = MessageFormat.format(Messages.AddDynamicBoxPage_DynamicBoxBoxSizePreviewErrorMessage, Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel);
        } else if (!(!this._2x2Button.getSelection() || StringUtil.isEmpty((CharSequence)_2x2SizePreview) || this.isFileInTheProject(_2x2SizePreview) && ValidationUtil.checkForWidgetIconFileExtension((String)_2x2SizePreview))) {
            message = MessageFormat.format(Messages.AddDynamicBoxPage_DynamicBoxBoxSizePreviewErrorMessage, Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel);
        } else if (boxlabelItems.length == 0) {
            message = Messages.AddDynamicBoxPage_DynamicBoxBoxLabelErrorMessage;
        } else {
            TableItem[] tableItemArray = boxlabelItems;
            int n = boxlabelItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                BoxLabel boxlabel = (BoxLabel)item.getData();
                if (StringUtil.isEmpty((CharSequence)boxlabel.getContent())) {
                    message = Messages.AddAccountPage_DisplayNameValue_ErrorMessage;
                    break;
                }
                ++n2;
            }
            if (this.pdCheckbox.getSelection()) {
                String pdSrc = this.pdSrcText.getText();
                String pdHegiht = this.pdHeightSpinner.getText();
                if (!this.isFileInTheProject(pdSrc) && !ValidationUtil.checkForURL((String)pdSrc)) {
                    message = Messages.AddDynamicBoxPage_DynamicBoxPdSrcErrorMessage;
                } else if (StringUtil.isEmpty((CharSequence)pdHegiht)) {
                    message = Messages.AddDynamicBoxPage_DynamicBoxPdHeightErrorMessage;
                }
            }
        }
        if (message == null) {
            this.crateDynamicBox();
            canFinish = true;
        }
        this.setErrorMessage(message);
        this.setPageComplete(canFinish);
    }

    protected void crateDynamicBox() {
        if (this.dynamicbox == null) {
            this.dynamicbox = new AppWidget();
        } else {
            this.dynamicbox.getContent().clear();
        }
        this.dynamicbox.setId(String.valueOf(this.appIdText.getText()) + this.appIdInputText.getText());
        if (this.primaryCombo.getSelectionIndex() == 0) {
            this.dynamicbox.setPrimary(DataBoolean.TRUE);
        } else {
            this.dynamicbox.setPrimary(DataBoolean.FALSE);
        }
        if (this.autoLaunchCombo.getSelectionIndex() == 0) {
            this.dynamicbox.setAutoLaunch(DataBoolean.TRUE);
        } else {
            this.dynamicbox.setAutoLaunch(DataBoolean.FALSE);
        }
        if (this.updatePeriodCheckBox.getSelection()) {
            this.dynamicbox.setUpdatePeriod(Float.valueOf(Float.parseFloat(this.updatePeriodSpinner.getText())));
        } else {
            this.dynamicbox.setUpdatePeriod(null);
        }
        this.dynamicbox.getContent().addAll(this.internalBoxlabels);
        BoxIcon boxIcon = new BoxIcon();
        boxIcon.setSrc(this.boxIconText.getText());
        this.dynamicbox.getContent().add(boxIcon);
        BoxContent boxContent = new BoxContent();
        boxContent.setSrc(this.boxContentText.getText());
        if (this.mouseEventCombo.getSelectionIndex() == 0) {
            boxContent.setMouseEvent(DataBoolean.TRUE);
        } else {
            boxContent.setMouseEvent(DataBoolean.FALSE);
        }
        if (this.touchEffectCombo.getSelectionIndex() == 0) {
            boxContent.setTouchEffect(DataBoolean.TRUE);
        } else {
            boxContent.setTouchEffect(DataBoolean.FALSE);
        }
        BoxSize _1x1size = new BoxSize();
        _1x1size.setContent(Messages.TizenPage_DynamicBoxSize1x1CheckboxLabel);
        String _1x1Preview = this._1x1IconText.getText();
        if (!StringUtil.isEmpty((CharSequence)_1x1Preview)) {
            _1x1size.setPreview(_1x1Preview);
        }
        if (this._1x1UserDecorationCombo.getSelectionIndex() == 0) {
            _1x1size.setUseDecoration(DataBoolean.TRUE);
        } else {
            _1x1size.setUseDecoration(DataBoolean.FALSE);
        }
        boxContent.getContent().add(_1x1size);
        if (this._2x1Button.getSelection()) {
            BoxSize _2x1size = new BoxSize();
            _2x1size.setContent(Messages.TizenPage_DynamicBoxSize2x1CheckboxLabel);
            String _2x1Preview = this._2x1IconText.getText();
            if (!StringUtil.isEmpty((CharSequence)_2x1Preview)) {
                _2x1size.setPreview(_2x1Preview);
            }
            if (this._2x1UserDecorationCombo.getSelectionIndex() == 0) {
                _2x1size.setUseDecoration(DataBoolean.TRUE);
            } else {
                _2x1size.setUseDecoration(DataBoolean.FALSE);
            }
            boxContent.getContent().add(_2x1size);
        }
        if (this._2x2Button.getSelection()) {
            BoxSize _2x2size = new BoxSize();
            _2x2size.setContent(Messages.TizenPage_DynamicBoxSize2x2CheckboxLabel);
            String _2x2Preview = this._2x2IconText.getText();
            if (!StringUtil.isEmpty((CharSequence)_2x2Preview)) {
                _2x2size.setPreview(_2x2Preview);
            }
            if (this._2x2UserDecorationCombo.getSelectionIndex() == 0) {
                _2x2size.setUseDecoration(DataBoolean.TRUE);
            } else {
                _2x2size.setUseDecoration(DataBoolean.FALSE);
            }
            boxContent.getContent().add(_2x2size);
        }
        if (this.pdCheckbox.getSelection()) {
            Pd pd = new Pd();
            pd.setSrc(this.pdSrcText.getText());
            pd.setWidth(720);
            pd.setHeight(Integer.parseInt(this.pdHeightSpinner.getText()));
            boxContent.getContent().add(pd);
        }
        this.dynamicbox.getContent().add(boxContent);
    }

    public AppWidget getDynamicBox() {
        return this.dynamicbox;
    }

    private boolean isFileInTheProject(String filePath) {
        return WebProjectUtil.isFileInTheProject((IProject)this.configurator.getProject(), (String)filePath);
    }
}

