/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.tizen.webwidget.support;

import java.util.HashSet;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tizen.common.ui.widget.ImageButton;
import org.tizen.web.config.schema.model.AppWidget;
import org.tizen.web.config.schema.model.DataBoolean;
import org.tizen.web.config.schema.model.WidgetContent;
import org.tizen.web.config.schema.model.WidgetLabel;
import org.tizen.web.config.schema.model.WidgetMetadata;
import org.tizen.web.config.schema.model.WidgetSize;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.EditorFormToolkit;
import org.tizen.web.editor.configuration.tizen.webwidget.support.AddMetaDataDialog;
import org.tizen.web.editor.configuration.tizen.webwidget.support.MetaDataContentProvider;
import org.tizen.web.editor.configuration.tizen.webwidget.support.MetaDataLabelProvider;

public class EditWebWidgetDialog
extends Dialog {
    private AppWidget widget = null;
    private WidgetLabel widgetLabel = null;
    private WidgetContent widgetContent = null;
    private WidgetSize widgetSize = null;
    private Text txID = null;
    private Text txLabel = null;
    private Text txContent = null;
    private Text txPreview = null;
    private Combo cbPrimary = null;
    private Spinner spInstance = null;
    private TableViewer metaDataTableViewer = null;
    private EditorFormToolkit formToolkit = null;
    private IProject project = null;

    public EditWebWidgetDialog(Shell parentShell, AppWidget widget, IProject project) {
        super(parentShell);
        this.widget = widget;
        this.project = project;
        this.parseAppWidget();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TizenPage_WebWidgetEditTitle);
        this.formToolkit = new EditorFormToolkit(newShell.getDisplay());
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    public void create() {
        super.create();
        this.update();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        this.createIDControl(composite);
        this.createPrimaryControl(composite);
        this.createInstanceControl(composite);
        this.createLabelControl(composite);
        this.createContentControl(composite);
        this.createPreviewControl(composite);
        this.createMetaDataComposite(composite);
        return composite;
    }

    private void createIDControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetIdLabel);
        this.txID = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.txID.setLayoutData((Object)layoutData);
    }

    private void createPrimaryControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetPrimaryLabel);
        this.cbPrimary = new Combo(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.cbPrimary.setLayoutData((Object)layoutData);
    }

    private void createInstanceControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetMaxInstanceLabel);
        this.spInstance = new Spinner(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.spInstance.setLayoutData((Object)layoutData);
    }

    private void createLabelControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetLabelLabel);
        this.txLabel = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.txLabel.setLayoutData((Object)layoutData);
    }

    private void createContentControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetContentLabel);
        this.txContent = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        this.txContent.setLayoutData((Object)layoutData);
        Button btBrowse = new Button(parent, 0);
        btBrowse.setText(Messages.TizenPage_WebWidgetBrowseLabel);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(EditWebWidgetDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dlg.setInput((Object)EditWebWidgetDialog.this.project);
                dlg.setAllowMultiple(false);
                dlg.setMessage(Messages.TizenPage_WebWidgetContentBrowseDescription);
                dlg.setTitle(Messages.TizenPage_WebWidgetContentBrowseTitle);
                dlg.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 0) {
                            return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                        }
                        if (selection[0] instanceof File) {
                            return new Status(0, "org.tizen.common.ui", "");
                        }
                        return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                    }
                });
                if (dlg.open() == 0) {
                    IResource resource = (IResource)dlg.getFirstResult();
                    String path = resource.getProjectRelativePath().toPortableString();
                    EditWebWidgetDialog.this.txContent.setText(path);
                }
            }
        });
    }

    private void createPreviewControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TizenPage_WebWidgetPreviewLabel);
        this.txPreview = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        this.txPreview.setLayoutData((Object)layoutData);
        Button btBrowse = new Button(parent, 0);
        btBrowse.setText(Messages.TizenPage_WebWidgetBrowseLabel);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dlg = new ElementTreeSelectionDialog(EditWebWidgetDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dlg.setInput((Object)EditWebWidgetDialog.this.project);
                dlg.setAllowMultiple(false);
                dlg.setMessage(Messages.TizenPage_WebWidgetPreviewBrowseDescription);
                dlg.setTitle(Messages.TizenPage_WebWidgetPreviewBrowseTitle);
                dlg.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 0) {
                            return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                        }
                        if (selection[0] instanceof File) {
                            return new Status(0, "org.tizen.common.ui", "");
                        }
                        return new Status(4, "org.tizen.common.ui", Messages.TizenPage_WebWidgetBrowseError);
                    }
                });
                if (dlg.open() == 0) {
                    IResource resource = (IResource)dlg.getFirstResult();
                    String path = resource.getProjectRelativePath().toPortableString();
                    EditWebWidgetDialog.this.txPreview.setText(path);
                }
            }
        });
    }

    private void createMetaDataComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        layoutData.heightHint = 200;
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.TizenPage_MetadataLabel);
        this.createMetaDataButtons((Composite)group);
        this.createMetaDataTable((Composite)group);
    }

    private void createMetaDataButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData(128);
        layoutData.horizontalSpan = 3;
        composite.setLayoutData((Object)layoutData);
        ImageButton btAdd = this.formToolkit.createAddButton(composite);
        btAdd.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem[] items;
                HashSet<String> keySet = new HashSet<String>();
                TableItem[] tableItemArray = items = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    WidgetMetadata data = (WidgetMetadata)item.getData();
                    keySet.add(data.getKey());
                    ++n2;
                }
                AddMetaDataDialog dlg = new AddMetaDataDialog(EditWebWidgetDialog.this.getShell(), keySet, null);
                if (dlg.open() == 0) {
                    WidgetMetadata newMetadata = new WidgetMetadata();
                    newMetadata.setKey(dlg.getNewKey());
                    newMetadata.setValue(dlg.getNewValue());
                    EditWebWidgetDialog.this.widget.getContent().add(newMetadata);
                    EditWebWidgetDialog.this.metaDataTableViewer.refresh();
                }
            }
        });
        ImageButton btEdit = this.formToolkit.createEditButton(composite);
        btEdit.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem[] items;
                TableItem[] selection = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getSelection();
                if (selection.length <= 0) {
                    return;
                }
                WidgetMetadata metadata = (WidgetMetadata)selection[0].getData();
                HashSet<String> keySet = new HashSet<String>();
                TableItem[] tableItemArray = items = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    WidgetMetadata data = (WidgetMetadata)item.getData();
                    keySet.add(data.getKey());
                    ++n2;
                }
                AddMetaDataDialog dlg = new AddMetaDataDialog(EditWebWidgetDialog.this.getShell(), keySet, metadata);
                if (dlg.open() == 0) {
                    metadata.setKey(dlg.getNewKey());
                    metadata.setValue(dlg.getNewValue());
                    EditWebWidgetDialog.this.metaDataTableViewer.refresh();
                }
            }
        });
        ImageButton btRemove = this.formToolkit.createRemoveButton(composite);
        btRemove.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem[] selection = EditWebWidgetDialog.this.metaDataTableViewer.getTable().getSelection();
                if (selection.length <= 0) {
                    return;
                }
                WidgetMetadata metadata = (WidgetMetadata)selection[0].getData();
                EditWebWidgetDialog.this.widget.getContent().remove(metadata);
                EditWebWidgetDialog.this.metaDataTableViewer.refresh();
            }
        });
    }

    private void createMetaDataTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        composite.setLayoutData((Object)layoutData);
        this.metaDataTableViewer = new TableViewer(composite, 68356);
        Table table = this.metaDataTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableViewerColumn keyColumn = new TableViewerColumn(this.metaDataTableViewer, 0);
        keyColumn.getColumn().setText(Messages.TizenPage_Metadata_KeyLabel);
        keyColumn.getColumn().setWidth(250);
        TableViewerColumn valueColumn = new TableViewerColumn(this.metaDataTableViewer, 0);
        valueColumn.getColumn().setText(Messages.TizenPage_Metadata_ValueLabel);
        valueColumn.getColumn().setWidth(250);
        this.metaDataTableViewer.setContentProvider((IContentProvider)new MetaDataContentProvider());
        this.metaDataTableViewer.setLabelProvider((IBaseLabelProvider)new MetaDataLabelProvider());
    }

    private void parseAppWidget() {
        for (Object obj : this.widget.getContent()) {
            if (obj instanceof WidgetLabel) {
                this.widgetLabel = (WidgetLabel)obj;
            }
            if (!(obj instanceof WidgetContent)) continue;
            this.widgetContent = (WidgetContent)obj;
        }
        if (this.widgetContent != null) {
            for (Object obj : this.widgetContent.getContent()) {
                if (!(obj instanceof WidgetSize)) continue;
                this.widgetSize = (WidgetSize)obj;
            }
        }
    }

    private void update() {
        DataBoolean[] values = DataBoolean.values();
        String[] items = new String[values.length];
        DataBoolean[] dataBooleanArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DataBoolean value = dataBooleanArray[n2];
            items[value.ordinal()] = value.value();
            ++n2;
        }
        this.cbPrimary.setItems(items);
        if (this.widget != null) {
            this.txID.setText(this.widget.getId());
            int idxPrimary = this.widget.getPrimary().ordinal();
            this.cbPrimary.select(idxPrimary);
            Integer instance = this.widget.getMaxInstance();
            if (instance != null) {
                this.spInstance.setSelection(instance.intValue());
            }
        }
        if (this.widgetLabel != null) {
            this.txLabel.setText(this.widgetLabel.getContent());
        }
        if (this.widgetContent != null) {
            this.txContent.setText(this.widgetContent.getSrc());
        }
        if (this.widgetSize != null) {
            this.txPreview.setText(this.widgetSize.getPreview());
        }
        this.metaDataTableViewer.setInput((Object)this.widget.getContent());
    }

    protected void okPressed() {
        this.modifyWidget();
        super.okPressed();
    }

    private void modifyWidget() {
        String id = this.txID.getText();
        String primary = this.cbPrimary.getText();
        int maxInstance = this.spInstance.getSelection();
        String label = this.txLabel.getText();
        String content = this.txContent.getText();
        String preview = this.txPreview.getText();
        this.widget.setId(id);
        this.widget.setPrimary(DataBoolean.fromValue((String)primary));
        this.widget.setMaxInstance(Integer.valueOf(maxInstance));
        this.widgetLabel.setContent(label);
        this.widgetContent.setSrc(content);
        this.widgetSize.setPreview(preview);
    }
}

