/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.web.editor.TizenWebSourceEditor;
import org.tizen.web.editor.configuration.Activator;
import org.tizen.web.editor.configuration.ConfigurationException;
import org.tizen.web.editor.configuration.ConfiguratorFactory;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.FeaturePage;
import org.tizen.web.editor.configuration.page.LocalizationPage;
import org.tizen.web.editor.configuration.page.OverviewPage;
import org.tizen.web.editor.configuration.page.PolicyPage;
import org.tizen.web.editor.configuration.page.PreferencePage;
import org.tizen.web.editor.configuration.page.PrivilegePage;
import org.tizen.web.editor.configuration.page.TizenPage;
import org.tizen.web.editor.configuration.support.IConfigurationDependent;

public class ConfigurationEditor
extends FormEditor
implements IResourceChangeListener {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String ConfigurationEditorID = "org.tizen.web.editor.configuration.ConfigurationEditor";
    protected ITizenConfigurator config;
    protected List<IEditorPart> sourceEditors;
    protected StructuredTextEditor sourceEditor;
    public int overviewPageIndex;
    public int featurePageIndex;
    public int privilegePageIndex;
    public int policyPageIndex;
    public int localizationPageIndex;
    public int preferencesPageIndex;
    public int tizenPageIndex;
    public int sourceIndex;
    public boolean isClosed;

    public ConfigurationEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.sourceEditors = new LinkedList<IEditorPart>();
        this.isClosed = false;
    }

    private void addPagesForWebApp() throws PartInitException {
        OverviewPage overviewPage = new OverviewPage(this);
        this.overviewPageIndex = this.addPage((IFormPage)overviewPage);
        this.setActivePage(this.overviewPageIndex);
        this.sourceEditors.add((IEditorPart)overviewPage);
        FeaturePage featurePage = new FeaturePage(this);
        this.featurePageIndex = this.addPage((IFormPage)featurePage);
        this.setActivePage(this.featurePageIndex);
        this.sourceEditors.add((IEditorPart)featurePage);
        PrivilegePage privilegePage = new PrivilegePage(this);
        this.privilegePageIndex = this.addPage((IFormPage)privilegePage);
        this.setActivePage(this.privilegePageIndex);
        this.sourceEditors.add((IEditorPart)privilegePage);
        PolicyPage policyPage = new PolicyPage(this);
        this.policyPageIndex = this.addPage((IFormPage)policyPage);
        this.setActivePage(this.policyPageIndex);
        this.sourceEditors.add((IEditorPart)policyPage);
        LocalizationPage localizationPage = new LocalizationPage(this);
        this.localizationPageIndex = this.addPage((IFormPage)localizationPage);
        this.setActivePage(this.localizationPageIndex);
        this.sourceEditors.add((IEditorPart)localizationPage);
        PreferencePage preferencePage = new PreferencePage(this);
        this.preferencesPageIndex = this.addPage((IFormPage)preferencePage);
        this.setActivePage(this.preferencesPageIndex);
        this.sourceEditors.add((IEditorPart)preferencePage);
        TizenPage tizenPage = new TizenPage(this);
        this.tizenPageIndex = this.addPage((IFormPage)tizenPage);
        this.setActivePage(this.tizenPageIndex);
        this.sourceEditors.add((IEditorPart)tizenPage);
        this.sourceEditor = new TizenWebSourceEditor();
        this.sourceIndex = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
        this.setPageText(this.sourceIndex, Messages.SourcePage_ID);
        this.setActivePage(this.overviewPageIndex);
        this.setFocus();
    }

    protected void addPages() {
        try {
            IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
            TizenProjectType projectType = null;
            if (file != null) {
                IProject project = file.getProject();
                projectType = ProjectUtil.getTizenProjectType((IProject)project);
            }
            if (projectType != null && TizenProjectType.TIZEN_WEB_WIDGET_APPLICATION == projectType) {
                this.addPagesForWebApp();
            } else {
                this.addPagesForWebApp();
            }
        }
        catch (PartInitException e) {
            MessageDialog.open((int)1, (Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.ConfigurationEditor_MessageDialog_CreatePageError, (String)e.getMessage(), (int)0);
        }
        this.refresh(false);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public IProject getProject() {
        return this.config.getProject();
    }

    public ITizenConfigurator getConfig() {
        return this.config;
    }

    public void doSave(final IProgressMonitor monitor) {
        if (!this.getProject().exists()) {
            this.close(false);
            return;
        }
        try {
            if (this.sourceEditor.isDirty()) {
                this.sourceEditor.doSave(monitor);
                boolean bSubEditorDirty = false;
                for (IEditorPart formPage : this.sourceEditors) {
                    if (!formPage.isDirty()) continue;
                    bSubEditorDirty = true;
                }
                if (!bSubEditorDirty) {
                    this.refresh(false);
                } else {
                    this.config = this.getConfigurator();
                    if (this.config == null) {
                        throw new ConfigurationException(Messages.ConfigurationEditor_MessageDialog_ReloadError);
                    }
                    for (IEditorPart formPage : this.sourceEditors) {
                        if (!formPage.isDirty()) continue;
                        IConfigurationDependent cd = (IConfigurationDependent)formPage;
                        cd.saveStatus(this.config);
                        cd.loadStatus(this.config);
                        formPage.doSave(monitor);
                    }
                    this.config.doSave();
                    this.sourceEditor.setInput(this.getEditorInput());
                }
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConfigurationEditor.this.config.getProject().build(15, monitor);
                        }
                        catch (CoreException e) {
                            ConfigurationEditor.this.logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                });
            } else {
                for (IEditorPart formPage : this.sourceEditors) {
                    if (!formPage.isDirty()) continue;
                    formPage.doSave(monitor);
                }
                if (this.config == null) {
                    throw new ConfigurationException(Messages.ConfigurationEditor_MessageDialogWithToggle_Message);
                }
                this.config.doSave();
                this.reloadPage(this.overviewPageIndex);
            }
        }
        catch (IOException e) {
            MessageDialog.open((int)1, (Shell)this.getSite().getShell(), (String)Messages.ConfigurationEditor_MessageDialog_SaveError, (String)e.getMessage(), (int)0);
        }
        catch (ConfigurationException e) {
            MessageDialog.open((int)1, (Shell)this.getSite().getShell(), (String)Messages.ConfigurationEditor_MessageDialog_ReloadError, (String)e.getMessage(), (int)0);
        }
    }

    public void reloadPage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.sourceEditors.size()) {
            return;
        }
        IConfigurationDependent page = (IConfigurationDependent)this.sourceEditors.get(pageIndex);
        page.loadStatus(this.config);
    }

    public void refresh(boolean synchronously) {
        if (synchronously) {
            SWTUtil.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ConfigurationEditor.this.refresh();
                }
            });
        } else {
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ConfigurationEditor.this.refresh();
                }
            });
        }
    }

    protected void refresh() {
        try {
            this.config = this.getConfigurator();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.config == null) {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            boolean dontShowDialog = preferenceStore.getBoolean("org.tizen.web.editor.configuration.SHOW_MALFORMED_DIALOG");
            if (!dontShowDialog) {
                MessageDialogWithToggle dialog = MessageDialogWithToggle.open((int)1, (Shell)Display.getCurrent().getActiveShell(), (String)Messages.ConfigurationEditor_MessageDialogWithToggle_Title, (String)Messages.ConfigurationEditor_MessageDialogWithToggle_Message, (String)Messages.ConfigurationEditor_MessageDialogWithToggle_ToggleMessage, (boolean)false, (IPreferenceStore)preferenceStore, (String)"org.tizen.web.editor.configuration.SHOW_MALFORMED_DIALOG", (int)0);
                preferenceStore.setValue("org.tizen.web.editor.configuration.SHOW_MALFORMED_DIALOG", dialog.getToggleState());
            }
        } else {
            try {
                SWTUtil.refreshLocal((IProject)this.config.getProject(), (int)1);
                for (IEditorPart formPage : this.sourceEditors) {
                    IConfigurationDependent cd = (IConfigurationDependent)formPage;
                    cd.loadStatus(this.config);
                }
                this.config.validate();
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            Status status = new Status(4, "org.tizen.web.editor.configuration", Messages.ConfigurationEditor_InputError);
            throw new PartInitException((IStatus)status);
        }
        super.init(site, editorInput);
    }

    protected ITizenConfigurator getConfigurator() {
        ITizenConfigurator config = null;
        try {
            IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
            if (file != null) {
                config = ConfiguratorFactory.unmarshalWidgetConfiguration(file.getProject());
            }
        }
        catch (ConfigurationException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return config;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int type = event.getType();
        if (type == 4 || type == 2) {
            this.isClosed = true;
            final IEditorInput input = this.getEditorInput();
            if (!(input instanceof IFileEditorInput)) {
                return;
            }
            final IFile file = ((IFileEditorInput)input).getFile();
            SWTUtil.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = ConfigurationEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (file.getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(input);
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        } else if (!this.isClosed && type == 1) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        String resourceName;
                        IResource res = delta.getResource();
                        int kind = delta.getKind();
                        if (((kind & 2) != 0 || (kind & 1) != 0) && (resourceName = res.getName()) != null && (resourceName.equals(ConfigurationEditor.this.config.getIconSrc()) || resourceName.equals(ConfigurationEditor.this.config.getContentSrc()))) {
                            SWTUtil.asyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ConfigurationEditor.this.reloadPage((this).ConfigurationEditor.this.overviewPageIndex);
                                }
                            });
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
    }

    public void setFocus() {
        FormPage selectedPage = (FormPage)this.getSelectedPage();
        if (selectedPage != null) {
            selectedPage.setFocus();
        }
    }
}

