/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public interface HttpContent {
    public Buffer getContentType();

    public Buffer getLastModified();

    public Buffer getIndirectBuffer();

    public Buffer getDirectBuffer();

    public Resource getResource();

    public long getContentLength();

    public InputStream getInputStream() throws IOException;

    public void release();

    public static class ResourceAsHttpContent
    implements HttpContent {
        private static final Logger LOG = Log.getLogger(ResourceAsHttpContent.class);
        final Resource _resource;
        final Buffer _mimeType;
        final int _maxBuffer;

        public ResourceAsHttpContent(Resource resource, Buffer mimeType) {
            this._resource = resource;
            this._mimeType = mimeType;
            this._maxBuffer = -1;
        }

        public ResourceAsHttpContent(Resource resource, Buffer mimeType, int maxBuffer) {
            this._resource = resource;
            this._mimeType = mimeType;
            this._maxBuffer = maxBuffer;
        }

        @Override
        public Buffer getContentType() {
            return this._mimeType;
        }

        @Override
        public Buffer getLastModified() {
            return null;
        }

        @Override
        public Buffer getDirectBuffer() {
            return null;
        }

        @Override
        public Buffer getIndirectBuffer() {
            InputStream inputStream = null;
            try {
                if (this._resource.length() <= 0L || (long)this._maxBuffer < this._resource.length()) {
                    Buffer buffer = null;
                    return buffer;
                }
                ByteArrayBuffer buffer = new ByteArrayBuffer((int)this._resource.length());
                inputStream = this._resource.getInputStream();
                buffer.readFrom(inputStream, (int)this._resource.length());
                ByteArrayBuffer byteArrayBuffer = buffer;
                return byteArrayBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Couldn't close inputStream. Possible file handle leak", e);
                    }
                }
            }
        }

        @Override
        public long getContentLength() {
            return this._resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        @Override
        public void release() {
            this._resource.release();
        }
    }
}

