/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.feature.support;

import java.text.MessageFormat;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.ui.dialog.PopupDialog;
import org.tizen.common.util.DialogUtil;
import org.tizen.web.config.schema.model.Feature;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.feature.support.AddFeatureLabelProvider;
import org.tizen.web.editor.configuration.feature.support.FeatureFilter;

public class AddFeatureDialog
extends PopupDialog {
    static final String FEATURE_SCREEN_SIZE_ALL = "http://tizen.org/feature/screen.size.all";
    static final String FEATURE_SCREEN_SIZE_NORMAL = "http://tizen.org/feature/screen.size.normal";
    private ITizenConfigurator configurator;
    private Label selectCountLabel;
    private CheckboxTableViewer featureTableViewer;
    private FeatureFilter featureFilter;

    public AddFeatureDialog(Shell parentShell, String title, ITizenConfigurator configurator) {
        super(parentShell, title);
        this.configurator = configurator;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setInput();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Text filterText = new Text(composite, 2176);
        filterText.setMessage(Messages.SEARCH_TEXT_MESSAGE);
        GridData data = new GridData(768);
        data.widthHint = 510;
        filterText.setLayoutData((Object)data);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text filter = (Text)event.widget;
                AddFeatureDialog.this.featureFilter.setSearchText(filter.getText());
                AddFeatureDialog.this.featureTableViewer.refresh();
                int selectionCnt = AddFeatureDialog.this.featureTableViewer.getCheckedElements().length;
                AddFeatureDialog.this.selectCountLabel.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, selectionCnt));
            }
        });
        this.selectCountLabel = new Label(composite, 0);
        GridData layoutData = new GridData(128);
        this.selectCountLabel.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, 0));
        this.selectCountLabel.setLayoutData((Object)layoutData);
        Table table = new Table(composite, 2848);
        this.featureTableViewer = new CheckboxTableViewer(table);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        data = new GridData(1808);
        data.heightHint = 200;
        table.setLayoutData((Object)data);
        new TableViewerColumn((TableViewer)this.featureTableViewer, 0);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.featureTableViewer.getTable().setLayout((Layout)tableLayout);
        this.featureTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.featureTableViewer.setLabelProvider((IBaseLabelProvider)new AddFeatureLabelProvider());
        this.featureFilter = new FeatureFilter();
        this.featureTableViewer.addFilter((ViewerFilter)this.featureFilter);
        this.featureTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                int selectionCnt = AddFeatureDialog.this.featureTableViewer.getCheckedElements().length;
                AddFeatureDialog.this.selectCountLabel.setText(MessageFormat.format(Messages.AddPrivilegeDialog_PrivilegeSelectionCount, selectionCnt));
            }
        });
        return composite;
    }

    private void setInput() {
        TreeSet<String> availableFeatureNames = new TreeSet<String>();
        for (Feature feature : this.configurator.getKnwonFeatures()) {
            availableFeatureNames.add(feature.getName());
        }
        for (Feature feature : this.configurator.getFeatures()) {
            availableFeatureNames.remove(feature.getName());
        }
        this.featureTableViewer.setInput(availableFeatureNames);
    }

    protected void okPressed() {
        Object feature;
        Object[] objs = this.featureTableViewer.getCheckedElements();
        String errorMsg = "";
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            feature = objectArray[n2];
            String featureName = feature.toString();
            if (featureName.equals(FEATURE_SCREEN_SIZE_ALL)) {
                errorMsg = Messages.AddFeatureWizard_WarningAllScreenSize;
            } else if (featureName.equals(FEATURE_SCREEN_SIZE_NORMAL)) {
                errorMsg = Messages.AddFeatureWizard_WarningNormalScreenSize;
            }
            ++n2;
        }
        if (!StringUtils.isEmpty((CharSequence)errorMsg) && DialogUtil.openQuestionDialog((String)errorMsg) == 128) {
            return;
        }
        objectArray = objs;
        n = objs.length;
        n2 = 0;
        while (n2 < n) {
            feature = objectArray[n2];
            this.configurator.setFeature(feature.toString());
            ++n2;
        }
        super.okPressed();
    }
}

