/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder.ide.visitor;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.LinkedResource;
import org.tizen.common.file.Resource;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.FilenameUtil;
import org.tizen.web.builder.ide.manager.BuildManager;
import org.tizen.web.common.WebConstant;

public class ResourceVisitor
implements IResourceDeltaVisitor,
IResourceVisitor {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected IProgressMonitor monitor;
    protected static final Map<IProject, Collection<org.tizen.common.file.IResource>> originResources = new HashMap<IProject, Collection<org.tizen.common.file.IResource>>();
    private static final SimpleFileFilter defaultFilter = new SimpleFileFilter(true);
    protected final Collection<org.tizen.common.file.IResource> deltaFileResources = new LinkedHashSet<org.tizen.common.file.IResource>();
    protected FileHandler fileHandler = new StandardFileHandler();
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();

    public boolean visit(IResource eclipseResource) throws CoreException {
        if (!this.canVisit(eclipseResource)) {
            return true;
        }
        org.tizen.common.file.IResource resource = null;
        switch (eclipseResource.getType()) {
            case 4: {
                try {
                    this.initResources((IProject)eclipseResource);
                    break;
                }
                catch (IOException e) {
                    throw this.newCoreException(e);
                }
            }
            case 1: 
            case 2: {
                resource = this.createResource(eclipseResource);
                originResources.get(eclipseResource.getProject()).add(resource);
                if (!this.filter.accept(resource.getFileHandler().getCurrentWorkingDirectory(), resource.getPath())) break;
                this.deltaFileResources.add(resource);
                break;
            }
        }
        return true;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource eclipseResource = delta.getResource();
        if (!this.canVisit(eclipseResource)) {
            return true;
        }
        IProject project = eclipseResource.getProject();
        org.tizen.common.file.IResource resource = null;
        switch (delta.getKind()) {
            case 1: 
            case 8: {
                this.logger.debug("{} was added.", (Object)eclipseResource.getFullPath().toString());
                resource = this.createResource(eclipseResource);
                originResources.get(project).add(resource);
                break;
            }
            case 2: 
            case 16: {
                this.logger.debug("{} was removed.", (Object)eclipseResource.getFullPath().toString());
                resource = ResourceVisitor.getOriginResource(eclipseResource);
                originResources.get(project).remove(resource);
                break;
            }
            case 4: {
                this.logger.debug("{} was changed.", (Object)eclipseResource.getFullPath().toString());
                resource = this.doDeltaChanged(eclipseResource);
            }
        }
        if (resource != null && this.canVisit(resource.getFileHandler().getCurrentWorkingDirectory(), resource.getPath())) {
            this.deltaFileResources.add(resource);
            this.deltaFileResources.addAll(BuildManager.getRelatedResources(project.getName(), resource));
        }
        return true;
    }

    private org.tizen.common.file.IResource doDeltaChanged(IResource eclipseResource) throws CoreException {
        org.tizen.common.file.IResource resource = null;
        switch (eclipseResource.getType()) {
            case 4: {
                if (BuildManager.getBuildDependency(eclipseResource.getName()) != null) break;
                eclipseResource.accept((IResourceVisitor)this);
                ResourceVisitor.deleteBuiltDirectory((IProject)eclipseResource);
                break;
            }
            case 1: 
            case 2: {
                resource = ResourceVisitor.getOriginResource(eclipseResource);
                if (resource != null) break;
                this.logger.debug("{} was changed but resource does not exist in originResources.", (Object)eclipseResource.getFullPath());
                resource = this.createResource(eclipseResource);
                break;
            }
        }
        return resource;
    }

    private void initResources(IProject project) throws IOException {
        Collection<org.tizen.common.file.IResource> resources = originResources.get(project);
        if (resources == null) {
            resources = new LinkedHashSet<org.tizen.common.file.IResource>();
            originResources.put(project, resources);
        } else {
            resources.clear();
        }
        defaultFilter.clearExcludes();
        String[] stringArray = WebConstant.DEFAULT_EXCLUDING_RESOURCES;
        int n = WebConstant.DEFAULT_EXCLUDING_RESOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            defaultFilter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
            ++n2;
        }
    }

    public static void deleteBuiltDirectory(IProject project) throws CoreException {
        IFolder folder = project.getFolder(".build");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        folder.delete(true, null);
    }

    private boolean canVisit(IResource resource) {
        String projectPath = resource.getProject().getFullPath().toString();
        String relativePath = FilenameUtil.getRelativePath2((String)projectPath, (String)resource.getFullPath().toString());
        return this.canVisit(projectPath, relativePath);
    }

    protected boolean canVisit(String cwd, String relativePath) {
        return defaultFilter.accept(cwd, relativePath) && this.filter.accept(cwd, relativePath);
    }

    public org.tizen.common.file.IResource createResource(IResource resource) {
        if (resource.isLinked()) {
            LinkedResource res = new LinkedResource(this.fileHandler, resource.getProjectRelativePath().toOSString());
            res.setLinked(true);
            res.setRealRelativePath(FilenameUtil.getRelativePath2((String)this.fileHandler.getCurrentWorkingDirectory(), (String)resource.getLocation().toOSString()));
            return res;
        }
        return new Resource(this.fileHandler, resource.getProjectRelativePath().toOSString());
    }

    public static org.tizen.common.file.IResource getOriginResource(IResource eclipseResource) {
        Collection<org.tizen.common.file.IResource> resources = originResources.get(eclipseResource.getProject());
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        String relativePath = FilenameUtil.getRelativePath2((String)eclipseResource.getProject().getFullPath().toString(), (String)eclipseResource.getFullPath().toString());
        for (org.tizen.common.file.IResource resource : resources) {
            if (!resource.getPath().equals(relativePath)) continue;
            return resource;
        }
        return null;
    }

    public void setExcludes(String[] excludes) {
        this.filter.clearExcludes();
        if (excludes != null) {
            String[] stringArray = excludes;
            int n = excludes.length;
            int n2 = 0;
            while (n2 < n) {
                String exclude = stringArray[n2];
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
                ++n2;
            }
        }
    }

    public CoreException newCoreException(Throwable e) {
        return new CoreException((IStatus)new Status(4, "org.tizen.web.builder", e.getMessage(), e));
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void handleCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new CancellationException();
        }
    }
}

